<?php $__env->startSection('title', 'Gestion des resultats'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="//cdn.jsdelivr.net/npm/alertifyjs@1.13.1/build/css/alertify.min.css"/>
<link rel="stylesheet" href="//cdn.jsdelivr.net/npm/alertifyjs@1.13.1/build/css/themes/default.min.css"/>
<style>
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <form action="<?php echo e(route('resultat.pdf')); ?>" id="myForm" method="get"  target="_blank">
                            <input type="hidden" name="classe" id="classe" value="<?php echo e($classe['id']); ?>">
                            <input type="hidden" name="cutting" id="cutting" value="<?php echo e($cutting->id); ?>">
                            <div class="card">
                                <div class="card-header pb-0">
                                    <div class="d-flex justify-content-between">
                                        <h4>Resultat Scolaire <?php echo e(ucfirst($cutting->cutting->libelle)); ?></h4>
                                        <span class="form-control-variant" style="font-size: 15px">
                                            <strong class="mr-2"><?php echo e($classe['libelle']); ?></strong>[<?php echo e($prof ? ($prof->user->sexe == 'F' ? 'Mme '.strtoupper($prof->user->first_name).' '.ucwords($prof->user->last_name):'M. '.strtoupper($prof->user->first_name).' '.ucwords($prof->user->last_name)):'Non defini'); ?>]
                                        </span>
                                        <span>
                                            <button type="submit" id="btn" class="btn btn-sm py-2" title="pdf"><img src="<?php echo e(asset('assets/images/imprimer.png')); ?>" alt="" srcset=""></button>
                                            <a href="<?php echo e(route('resultat.show', $classe['id'])); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1"><i class="fas fa-reply mx-0"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <hr class="mx-3 my-0">
                                <div class="card-block">
                                    <div class="dt-responsive table-responsive">
                                        <div class="tab-content card-block">
                                            <table id="realtime-reorder" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="width: 5%">N°</th>
                                                        <th class="text-center">Nom</th>
                                                        <th class="text-center">Prénoms</th>
                                                        <th class="text-center">Sexe</th>
                                                        <th class="text-center">Matricule</th>
                                                        <th class="text-center">Moyenne</th>
                                                        <th class="text-center">Rang</th>
                                                        <th class="text-center" style="width: 10%">
                                                            <input type="checkbox" id="checkAll">
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $i = 1; ?>
                                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                        <td class="ml-2"><?php echo e(strtoupper($item['first_name'])); ?></td>
                                                        <td class="ml-2"><?php echo e(ucwords($item['last_name'])); ?></td>
                                                        <td class="text-center"><?php echo e($item['sexe'] == 'F' ? 'Feminin':'Masculin'); ?></td>
                                                        <td class="text-center"><?php echo e($item['matricule']); ?></td>
                                                        <td class="text-center"><?php echo e($item['moyenne']); ?></td>
                                                        <td class="text-center"><?php echo e($item['rang']); ?></td>
                                                        <td class="text-center">
                                                            <input type="checkbox" name="tags[]" value="<?php echo e($item['inscription_id']); ?>" class="<?php echo e($item['moyenne'] != 'nc' ? 'item':null); ?>" <?php echo e($item['moyenne'] == 'nc' ? 'disabled':null); ?>>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                                
                                            </table>
                                        </div> 
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="//cdn.jsdelivr.net/npm/alertifyjs@1.13.1/build/alertify.min.js"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){
            document.getElementById('checkAll').addEventListener('change', function() {
                document.querySelectorAll('.item').forEach(cb => cb.checked = this.checked);
            });
            

            $('#btn').on('click', function(e){
                e.preventDefault();
                let tags = [];
                $('input[name="tags[]"]:checked').each(function() {
                    tags.push($(this).val());
                });

                if(tags.length){
                   $('#myForm').submit(); // e.target refers to the form element
                }
                else{
                    alertify.error('Une erreur est survenue.');
                }
            });
            
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views/pages/resultats/list_classe.blade.php ENDPATH**/ ?>