@extends('app')
@section('title', 'Change password')
@section('content')
<div class="pcoded-inner-content">
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                @include('includes._alert')
                <div class="row">
                    <div class="col-sm-8" style="margin: auto">
                        <div class="card">
                            <div class="card-header my-2">
                                <div class="text-center">
                                    <h4>Changement de mot de passe</h4>
                                    <span class="form-control-variant">Les champ avec asterisk (<code>*</code>) sont obligatoires.</span>
                                </div>
                            </div>
                            <div class="card-block py-3">
                                <form action="{{route('pwd.update')}}" method="post">
                                    @csrf
                                    <div class="form-group row mb-3">
                                        <label class="col-sm-3 col-form-label" for="current_password">Mot de passe actuel<span class="text-danger">*</span> :</label>
                                        <div class="col-sm-9">
                                            <input type="password" name="current_password" class="form-control" id="current_password" placeholder="Mot de passe acteul">
                                            @error('current_password')
                                                <span class="form-bar text-danger" role="alert">
                                                    {{$message}}
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row mb-3">
                                        <label class="col-sm-3 col-form-label" for="password">Nouveau mot de passe<span class="text-danger">*</span> :</label>
                                        <div class="col-sm-9">
                                            <input type="password" name="password" class="form-control" id="password" placeholder="Nouveau mot de passe">
                                            @error('password')
                                                <span class="form-bar text-danger" role="alert">
                                                    {{$message}}
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row mb-3">
                                        <label class="col-sm-3 col-form-label" for="password_confirmation">Confirmer le mot de passe<span class="text-danger">*</span> :</label>
                                        <div class="col-sm-9">
                                            <input type="password" name="password_confirmation" class="form-control" id="password_confirmation" placeholder="Confirmer le mot de passe">
                                            @error('password_confirmation')
                                                <span class="form-bar text-danger" role="alert">
                                                    {{$message}}
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <hr class="mt-4">
                                    <div class="text-center">
                                        <button type="submit" class="btn-inverse btn-outline-inverse btn-sm w-25">Confirmer</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script src="{{asset('assets/js/pcoded.min.js')}}"></script>
<script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
<script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
@endsection