@extends('auth')
@section('title', 'forgot password')
@section('content')
<form method="post" action="{{route('password.update')}}" class="md-float-material form-material">
    @csrf
    <div class="text-center">
        <img src="{{asset('assets/images/logo.png')}}" alt="logo.png">
    </div>
    <div class="auth-box card">
        <div class="card-block">
            <div class="row m-b-20">
                <div class="col-md-12">
                    <h3 class="text-left">Réinitialisation du mot de passe</h3>
                </div>
            </div>

            @error('email')
                <div class="alert alert-danger background-danger">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <i class="icofont icofont-close-line-circled text-white"></i>
                    </button>
                    <span class="form-bar" role="alert">
                        {{$message}}
                    </span>
                </div>
            @enderror
            <input type="hidden" name="token" value="{{request()->token}}">
            <div class="form-group form-primary">
                <label for="email">Adresse mail : </label>
                <input type="email" name="email" id="email" class="form-control" value="{{ old('email') }}" placeholder="votre adresse mail">
                @error('email')
                    <span class="form-bar text-danger" role="alert">
                        {{$message}}
                    </span>
                @enderror
            </div>
            <div class="form-group form-primary">
                <label for="email">Nouveau mot de passe : </label>
                <input type="password" name="password" class="form-control @error('password') is-invalid @enderror" placeholder="Password">
                @error('password')
                    <span class="form-bar text-danger" role="alert">
                        {{$message}}
                    </span>
                @enderror
            </div>
            <div class="form-group form-primary">
                <label for="email">Confiemz le nouveau mot de passe : </label>
                <input type="password" name="password_confirmation" class="form-control @error('password_confirmation') is-invalid @enderror" placeholder="Confirm Password">
                @error('password_confirmation')
                    <span class="form-bar text-danger" role="alert">
                        {{$message}}
                    </span>
                @enderror
            </div>
            <div class="row">
                <div class="col-md-12 mt-2">
                    <button type="submit" class="btn btn-primary btn-md btn-block waves-effect text-center m-b-20">Reset Password</button>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 text-center">
                    <span class="text-inverse m-b-0">Thank you, back to</span>
                    <span class="text-inverse"><a href="{{route('login')}}"><b class="f-w-600">Login.</b></a></span>
                </div>
            </div>
        </div>
    </div>
</form>
@endsection