<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('absence_primaries', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->enum('period', [1,2]);
            $table->string('dateAbsence');
            $table->string('week_number');
            $table->unsignedBigInteger('inscription_id');
            $table->unsignedBigInteger('classe_id');
            $table->foreign('inscription_id')->references('id')->on('inscriptions')->onDelete('cascade');
            $table->foreign('classe_id')->references('id')->on('classes')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('absence_primaries');
    }
};
