@extends('app')
@section('title', 'List note')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header pb-0 mb-0">
                                <div class="d-flex justify-content-between pb-0 mb-0">
                                    <h4>Liste des notes - 
                                        <strong style="font-size: 19px">{{ucfirst($class->libelle)}}</strong>
                                    </h4>
                                    <span class="form-control-variant" style="font-size: 17px">
                                        <strong class="mr-2">{{ucfirst($decoup->cutting->libelle.' [ '.($matter->matter->abbreviated ?? $matter->matter->libelle).' ]')}}</strong>
                                    </span>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" title="Approuvez les moyennes" data-toggle="modal" data-target="#ModalConfirm" style="display: {{$approved ? 'none':''}}"><i class="fa fa-thumbs-up m-0"></i></button>
                                        @if (!$approved)
                                        <a href="{{route('evaluation.bonnus', $string)}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Bonnus moyenne"><i class="fa fa-qrcode mx-0"></i></a>
                                        @endif
                                        <a href="{{route('evaluation.pdf', $string)}}" target="_blank" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Télécharger la fiche"><i class="fa fa-download mx-0"></i></a>
                                        <a href="{{route('evaluation.return', $class->id.'_'.$matter->id)}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 ml-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="mx-3 mt-0">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive px-lg-3">
                                    <table id="saving-reorder" class="table table-striped table-bordered nowrap">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="width: 5px"></th>
                                                <th class="text-uppercase" style="width: 20px">Matricule</th>
                                                <th class="text-uppercase" style="width: 80px">Nom et prénoms</th>
                                                <th class="text-uppercase" style="width: 10px">Genre</th>
                                                @for ($i = 0; $i < $eval; $i++)
                                                <th class="text-center text-uppercase" style="width: 30px" title="Note {{$i+1}}">N{{$i+1}}</th>
                                                @endfor
                                                <th class="text-uppercase text-center" style="width: 15px">Moyenne</th>
                                                <th class="text-uppercase text-center" style="width: 5%">Rang</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $t = 1 @endphp
                                            @foreach ($datas as $item)
                                            <tr>
                                                <th class="text-center py-1">
                                                    <img src="{{ asset($item['sexe'] == 'F' ? 'assets/images/admin_woman.png':'assets/images/admin_man.png') }}" class="img-radius m-0 p-0" alt="Photo Stuedent" style="height: 40px; width: 40px; border: 1px solid grey">
                                                    @php $t++; @endphp
                                                </th>
                                                <td class="py-2"><div class="mt-2">{{$item['matricule']}}</div></td>
                                                <td class="py-2" title="{{ $item['name'] }}">
                                                    <div class="mt-2">{{ Str::limit($item['name'], '27', '...') }}</div>
                                                </td>
                                                <td class="py-2"><div class="mt-2">{{ucfirst($item['sexe'] == 'F' ? 'Féminin':'Masculin')}}</div></td>
                                                @for ($i = 0; $i < $eval; $i++)
                                                <td class="text-center py-2">
                                                    <div class="mt-2">{{$item['notes'][$i]['note'] ?? 'nc'}}</div>
                                                </td>
                                                @endfor
                                                <th class="py-2 text-center">
                                                    <div class="mt-2">{{$item['moyen'] ? $item['moyen']['moyenne']:calculMoyenneMatter($item['notes'])}}</div>
                                                </th>
                                                <td class="py-2 text-center">
                                                    <div class="mt-2">{{$item['moyen'] ? $item['moyen']['rang']:'--'}}</div>
                                                </td>
                                            </tr>
                                            @endforeach 
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
{{-- Modal --}}
<div class="modal fade" id="ModalConfirm" tabindex="-1" role="dialog" aria-labelledby="ModalConfirmTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="ModalConfirmLongTitle">Confirmation</h5>
          <span style="font-size: 17px">{{ucfirst($decoup->cutting->libelle)}}</span>
        </div>
        <div class="modal-body py-3 text-center">
            <p class="mt-2">
                <strong style="font-size: 19px">Confirmation des moyenne !</strong>
            </p>
            " Apres cette action plus de modification <br> ou de suppression à votre niveau "
        </div>
        <div class="modal-footer">
            <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
            <a href="{{route('evaluation.approved', $string)}}" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</a>
        </div>
      </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){

            // Autoriser les touches numériques (0-9) et la touche backspace (code 8)
            $('.myInput').on('keypress', function(e) {
                var charCode = e.which ? e.which : e.keyCode;
                if (charCode < 48 || charCode > 57) {
                    e.preventDefault(); // Empêche la saisie si ce n'est pas un chiffre
                }
            });

            $('#btnEdit').on('click', function(){
                $('#btnSubmit').slideDown();
                $(this).slideUp();
                $('.myInput').css('border','1px #000 dashed');
            });
        })
    </script>
@endsection