<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('scolarities', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('type');
            $table->enum('niveau', [0, 1]);
            $table->enum('serie', [0, 1]);
            $table->unsignedBigInteger('amount_id');
            $table->unsignedBigInteger('school_id');
            $table->unsignedBigInteger('school_year_id');
            $table->unsignedBigInteger('level_id')->nullable();
            $table->unsignedBigInteger('serie_id')->nullable();
            $table->foreign('amount_id')->references('id')->on('amounts')->onDelete('cascade');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('school_year_id')->references('id')->on('school_years')->onDelete('cascade');
            $table->foreign('level_id')->references('id')->on('levels')->onDelete('cascade');
            $table->foreign('serie_id')->references('id')->on('series')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('scolarities');
    }
};
