<?php

namespace App\Http\Controllers;

use App\Models\Classe;
use App\Models\Setting;
use App\Models\Student;
use App\Models\SchoolYear;
use App\Models\Nationality;
use App\Models\Inscription;
use App\Models\ParentEleve;
use App\Events\PaymentGetEvent;
use App\Joabs\StatutPyramideJob;
use App\Imports\StudentExcelImport;
use App\Http\Requests\StudentRequest;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Http\Request;

class StudentController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        try{
            $data = Setting::where('school_id',auth()->user()->school_id)->first();
            $students = Student::where('school_id', auth()->user()->school_id)->where('status', '1')->count();
            return view('pages.student.index',[
                'nombre' => $students,
                'statistics' => $this->inscriptionStatistik($data),
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    public function dataTable1(){
        $query = Student::where('school_id', auth()->user()->school_id)->where('status', '1')->orderBy('first_name')->orderBy('last_name')->get();
        return DataTables::of($query)
        ->addColumn('image', function($row) {
            $url = asset($row->photo ? $row->urlStudent():($row->sexe == 'F' ? 'assets/images/stdt1_woman.png':'assets/images/stdt1_man.png'));
            return ('<img src="'.$url.'" class="img-radius m-0 p-0" alt="Photo Stuedent" style="height: 40px; width: 40px; border: 1px solid grey">');
        })
        ->addColumn('matricule', function ($row) {
            return ('<p class="m-0 pt-2">'.strtoupper($row->matricule).'</p>');
        })
        ->addColumn('firstName', function ($row) {
            return ('<p class="m-0 pt-2">'.strtoupper($row->first_name).'</p>');
        })
        ->addColumn('lastName', function ($row) {
            return ('<p class="m-0 pt-2">'.ucwords($row->last_name).'</p>');
        })
        ->addColumn('genre', function ($row) {
            return ('<p class="m-0 pt-2">'.ucwords($row->sexe == 'F' ? 'Feminin':'Masculin').'</p>');
        })
        ->addColumn('dateBirth', function ($row) {
            return ('<p class="m-0 pt-2">'.date('d-m-Y', strtotime($row->date_birth)).'</p>');
        })
        ->addColumn('placeBirth', function ($row) {
            return ('<p class="m-0 pt-2">'.ucwords($row->place_birth).'</p>');
        })
        ->addColumn('action', function ($row) {
            $url_1 = route('student.show',$row->id); $url_2 = route('student.edit',$row->id);
            return ('<div class="card-block remove-label m-0 pt-1 pb-0 text-center">
                <a href="'.$url_1.'" class="btn btn-sm btn-primary text-center px-2" title="Detail"><i class="fas fa-eye m-0"></i></a>
                <a href="'.$url_2.'" class="btn btn-sm btn-info text-center px-2" title="Edit"><i class="fas fa-edit m-0"></i></a>
            </div>');
        })
        ->rawColumns(['image', 'matricule', 'firstName', 'lastName', 'genre', 'dateBirth', 'placeBirth', 'action'])
        ->make(true);
    }



    public function index1()
    {
       try{
            $data = Setting::where('school_id',auth()->user()->school_id)->first();
            $count = Student::where('school_id', auth()->user()->school_id)->where('status', '0')->count();
            return view('pages.student.index1',[
                'nombre' => $count,
                'statistics' => $this->inscriptionStatistik($data),
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        } 
    }


    public function dataTable2()
    {
        $query = Student::where('school_id', auth()->user()->school_id)->where('status', '0')->orderBy('first_name')->orderBy('last_name')->get();
        return DataTables::of($query)
        ->addColumn('image', function($row) {
            $url = asset($row->photo ? $row->urlStudent():($row->sexe == 'F' ? 'assets/images/stdt1_woman.png':'assets/images/stdt1_man.png'));
            return ('<img src="'.$url.'" class="img-radius m-0 p-0" alt="Photo Stuedent" style="height: 40px; width: 40px; border: 1px solid grey">');
        })
        ->addColumn('matricule', function ($row) {
            return ('<p class="m-0 pt-2">'.strtoupper($row->matricule).'</p>');
        })
        ->addColumn('firstName', function ($row) {
            return ('<p class="m-0 pt-2">'.strtoupper($row->first_name).'</p>');
        })
        ->addColumn('lastName', function ($row) {
            return ('<p class="m-0 pt-2">'.ucwords($row->last_name).'</p>');
        })
        ->addColumn('genre', function ($row) {
            return ('<p class="m-0 pt-2">'.ucwords($row->sexe == 'F' ? 'Feminin':'Masculin').'</p>');
        })
        ->addColumn('dateBirth', function ($row) {
            return ('<p class="m-0 pt-2">'.date('d-m-Y', strtotime($row->date_birth)).'</p>');
        })
        ->addColumn('placeBirth', function ($row) {
            return ('<p class="m-0 pt-2">'.ucwords($row->place_birth).'</p>');
        })
        ->addColumn('action', function ($row) {
            $url_1 = route('student.show',$row->id); $url_2 = route('student.edit',$row->id);
            return ('<div class="card-block remove-label m-0 pt-1 pb-0 text-center">
                <a href="'.$url_1.'" class="btn btn-sm btn-primary text-center px-2 mx-1" title="Detail"><i class="fas fa-eye m-0"></i></a>
                <a href="'.$url_2.'" class="btn btn-sm btn-info text-center px-2 mx-1" title="Edit"><i class="fas fa-edit m-0"></i></a>
                <button class="btn btn-sm btn-danger text-white text-center px-2 mx-1 deleteBtn" title="Delete" data-id="'.$row->id.'"><i class="far fa-trash-alt m-0"></i></button>
            </div>');
        })
        ->rawColumns(['image', 'matricule', 'firstName', 'lastName', 'genre', 'dateBirth', 'placeBirth', 'action'])
        ->make(true);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create($val)
    {
        try{
            $explod = explode('_', $val);
            $datas = $explod[1] ? ParentEleve::where('school_id', auth()->user()->school_id)->where('id', $explod[0])->first():null;
            $school = Setting::where('school_id', auth()->user()->school_id)->first();
            $nationality = Nationality::orderby('libelle', 'ASC')->get();
            return view('pages.student.create',[
                'school' => $school,
                'types' => $this->typeEnseignement($school->school->typeEnseignements),
                'parent' => $datas,
                'nationality' => $nationality,
                'data' => [],
                'year' => $this->actifYear(),
                'idParent' => $explod[0]
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StudentRequest $request)
    {
        try{
            $school = auth()->user()->school_id;
            if(in_array($request['type'], ['Prescolaire', 'Primaire', 'Prescolaire&Primaire'])){
                $parent = ParentEleve::where('school_id', $school)->where('id', $request['idParent'])->first();
                $val = $parent['telephon1'].$parent['telephon2'];
                $request['matricule'] = $this->matriculePrimaire($val);
            }
            $mat = $request->validate(['matricule' => 'required|string|unique:students,matricule']); // Validation de matricule 

            /** @var UploadedFile $img */ 
            if($request['photo']){
                $img = $request->validate(['photo' => 'image|mimes:jpg,png,jpeg']);
                $name = $request['type'].'_'.$mat['matricule'].'.png';
                $file = $img['photo']->storeAs('eleves', $name, 'public');
            }

            // Create student
            $student = Student::create([
                'matricule' => str_replace(' ', '', $mat['matricule']),
                'first_name' => strtolower($request->nom),
                'last_name' => strtolower($request->prenom),
                'sexe' => $request->sexe,
                'date_birth' => $request->dateNais,
                'place_birth' => strtolower($request->lieuNais),
                'nationalitie_id' => $request->nationalite,
                'place_residence' => strtolower($request->residence),
                'first_name_father' => strtolower($request->NomPere),
                'last_name_father' => strtolower($request->prenomPere),
                'profession_father' => strtolower($request->profPere),
                'first_name_mother' => strtolower($request->NomMere),
                'last_name_mother' => strtolower($request->prenomMere),
                'profession_mother' => strtolower($request->profMere),
                'type' => changeVal($request->type),
                'photo' => $file ?? null,
                'parent_eleve_id' => $request->idParent,
                'school_id' => $school,
                'school_year_id' => $request->idYear,
            ]);

            if($student){
                $val = $this->saveInscription(
                    $student['id'],$school, explode('_',$request->level)[0] ,$request->classe, $request->idYear, $request->redoublant, $request->typeStud ?? null, 
                    $request->affecte ?? null, $request->boursier ?? null, $request->serie ? explode('_', $request->serie)[0]:null, $request->lv2 ?? null
                );
                $class = Classe::where('id', $request->classe)->where('school_id', $school)->first();
                $class->update(['inscrits' => $class['inscrits']+=1]);

                // Déclenchement de l’événement
                if(VerifyBox(auth()->user()->school->setting, 'box')){
                event(new PaymentGetEvent($val, $class['id'], auth()->user()->school_id, $class['school_year_id']));
                }

                // Déclenchement de Job ---------------------->
                if(auth()->user()->school->belonging == 'cdec'){
                    $class['type'] == 'secondaire' ? StatutPyramideJob::dispatch($this->getSexe($student['id']), $class['school_year_id'], $class['level_id'], $class['serie_id'], auth()->user()->school_id, $request['affecte'], $request['redoublant']):null;
                }

                return redirect()->route('inscription.index')->with([
                    'str' => 'success',
                    'msg' => 'Inscription effectuée avec success.'
                ]);
            }
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        try{
            $data = Student::find($id);
            return view('pages.student.detail', [
                'data' => $data, 
                'year' => $this->actifYear()
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        try{
            $data = Student::find($id);
            $school = Setting::where('school_id', auth()->user()->school_id)->first();
            $nationality = Nationality::orderby('libelle', 'ASC')->get();
            return view('pages.student.create',[
                'school' => $school,
                'types' => [],
                'nationality' => $nationality,
                'data' => $data,
                'year' => $this->actifYear()
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        try{
            $data = $request->validate([
                'matricule' => 'nullable|string',
                'nom' => 'required|string',
                'prenom' => 'required|string',
                'sexe' => 'required|string',
                'dateNais' => 'required|string',
                'lieuNais' => 'required|string',
                'nationalite' => 'required|string',
                'residence' => 'required|string',
                'NomPere' => 'nullable|string',
                'prenomPere' => 'nullable|string',
                'profPere' => 'nullable|string',
                'NomMere' => 'nullable|string',
                'prenomMere' => 'nullable|string',
                'profMere' => 'nullable|string',
                'status' => 'nullable|integer'
            ]);

            // Recupere l'eleve en question 
            $student = Student::find($id);
            /** @var UploadedFile $img */ 
            if($request['photo']){
                $img = $request->validate(['photo' => 'image|mimes:jpg,png,jpeg']);
                if ($student->photo && Storage::exists('app/public/eleves/'.$student->photo)) {
                    Storage::delete('app/public/eleves/'.$student->photo);
                }
                $name = $student['type'].'_'.$request['matricule'].'.png';
                $file = $img['photo']->storeAs('eleves', $name, 'public');
            }

            // Save modification
            $student->update([
                'matricule' => str_replace(' ', '', ($request['matricule'] ?? $student['matricule'])),
                'first_name' => strtolower($data['nom']),
                'last_name' => strtolower($data['prenom']),
                'sexe' => $data['sexe'],
                'date_birth' => $data['dateNais'],
                'place_birth' => strtolower($data['lieuNais']),
                'status' => $request['status'] ?? '0',
                'nationalitie_id' => $data['nationalite'],
                'place_residence' => strtolower($data['residence']),
                'first_name_father' => strtolower($data['NomPere']),
                'last_name_father' => strtolower($data['prenomPere']),
                'profession_father' => strtolower($data['profPere']),
                'first_name_mother' => strtolower($data['NomMere']),
                'last_name_mother' => strtolower($data['prenomMere']),
                'profession_mother' => strtolower($data['profMere']),
                'photo' => $file ?? null,
            ]);

            return redirect()->route('student.index')->with([
                'str' => 'info',
                'msg' => 'Modification éffecutée avec succes.'
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function search(Request $request){
        try{
            $data = Student::where('matricule', $request['data'])->where('school_id', auth()->user()->school_id)->get();
            return sizeof($data) ? 200:201;
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function download(){
        try{
            $filename = 'student_new.xlsx';
            return response()->download(storage_path('app/public/download/'.$filename));
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function fileStore(Request $request)
    {
        try{
            $request->validate(['files' => 'required|mimes:xlsx']);
            $school = Setting::where('school_id', auth()->user()->school_id)->first();
            $table = $this->typeEnseignementTable($school->school->typeEnseignements);
            Excel::import(new StudentExcelImport(auth()->user()->school_id, $this->actifYear()->id, $table), $request->file('files'));

            return back()->with([
                'str' => 'info',
                'msg' => 'Importation réussie !'
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Search student the specified resource from storage.
     */
    public function delete(Request $request){
        try{
            $data = Student::where('id', $request['data'])->first();
            $dts = [
                'id' => $data->id,
                'first' => strtoupper($data->first_name),
                'last' => ucwords($data->last_name),
                'matricule' => $data->matricule,
                'created' => date('d/m/Y', strtotime($data->created_at))
            ];
            return response()->json($dts);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        try{
            $val = $request->validate([
                'id' => 'required|string'
            ]);
            $data = Student::Where('id', $val['id'])->where('school_id', auth()->user()->school_id)->first();
            if ($data) {
                if ($data->photo && Storage::exists('app/public/eleves/'.$data->photo)) {
                    Storage::delete('app/public/eleves/'.$data->photo);
                }
                $data->delete();
                return back()->with([
                    'str' => 'info',
                    'msg' => 'Elève supprimé avec succès !'
                ]);
            } 
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }


    protected function matriculePrimaire($val) {
        $caracteres = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $longueurMax = strlen($caracteres) - 1;
        $mats = '';
    
        for ($i = 0; $i < 4; $i++) {
            $mats .= $val[rand(0, (strlen($val) - 1))];
        }
    
        return $mats.$caracteres[rand(0, $longueurMax)];
    }


    protected function typeEnseignement($tab){
        $dts = []; $prim = 0; $cycle = 0;
        foreach($tab as $item){
            if($item['id'] < 3 && $prim == 0){
                $dts[] = ['type' => verifyPrimaire($tab), 'libelle' => verifyPrimaire($tab), 'check' => null];
                $prim++;
            }
            elseif($item['id'] < 5 && $cycle == 0){
                $dts[] = ['type' => verifySeconde($tab), 'libelle' => verifySeconde($tab), 'check' => 1];
                $cycle++;
            }
            elseif($item['id'] == 5){
                $dts[] = ['type' => 'technique', 'libelle' => ucfirst($item['type_enseignement']), 'check' => null];
            }
            elseif($item['id'] == 6){
                $dts[] = ['type' => 'superieur', 'libelle' => ucfirst($item['type_enseignement']), 'check' => null]; 
            }
        }

        return $dts;
    }


    protected function saveInscription($student, $school, $level, $classe, $year, $redoublant, $typeStud = null, $affect = null, $boursier = null, $serie = null, $lv2 = null)
    {
        $result = Inscription::create([
            'redoublant' => $redoublant,
            'affecte' => $affect,
            'boursier' => $boursier,
            'lv2' => $lv2,
            'serie_id' => $serie,
            'level_id' => $level,
            'student_id' => $student,
            'classe_id' => $classe,
            'school_id' => $school,
            'school_year_id' => $year,
            'ancient' => $typeStud ?? '1' // 1 = ancien élève
        ]);
        return $result ? $result->id:null;
    }



    /**
     * Remove the specified resource from storage.
     */
    protected function typeEnseignementTable($dts)
    {
        $tab = []; $primaire = 0; $cycle = 0;
        foreach ($dts as $item) {
            if(!$primaire && ($item['id'] == 1 || $item['id'] == 2)){
                $tab[] = 'Primaire'; $primaire++;
            }
            elseif(!$cycle && ($item['id'] == 3 || $item['id'] == 4)){
                $tab[] = 'Secondaire'; $cycle++;
            }
            elseif($item['id'] == 5){
                $tab[] = 'Technique';
            }
            elseif($item['id'] == 6){
                $tab[] = 'Superieur';
            }
        }
        return $tab;
    }


    /**
     * Remove the specified resource from storage.
     */
    protected function inscriptionStatistik($dts)
    {
        $tab = []; $primaire = 0; $cycle = 0;
        foreach ($dts->school->typeEnseignements as $item) {
            if(!$primaire && ($item['id'] == 1 || $item['id'] == 2)){
                $val = verifyPrimaire($dts->school->typeEnseignements);
                $tab[] = [
                    'total' => $this->nbreTotalStudent($val), 
                    'nbreF'  => $this->nbreInscrisSelonSexe($val, 'F'),
                    'nbreM'  => $this->nbreInscrisSelonSexe($val, 'M'),
                    'libelle' => $val
                ];$primaire++;
            }
            elseif(!$cycle && ($item['id'] == 3 || $item['id'] == 4)){
                $val = verifySeconde($dts->school->typeEnseignements);
                $tab[] = [
                    'total' => $this->nbreTotalStudent($val),
                    'nbreF'  => $this->nbreInscrisSelonSexe($val, 'F'),
                    'nbreM'  => $this->nbreInscrisSelonSexe($val, 'M'),
                    'libelle' => $val
                ]; $cycle++;
            }
            elseif($item['id'] == 5){
                $val = $item['type_enseignement'];
                $tab[] =[
                    'total' => $this->nbreTotalStudent($val),
                    'nbreF'  => $this->nbreInscrisSelonSexe($val, 'F'),
                    'nbreM'  => $this->nbreInscrisSelonSexe($val, 'M'),
                    'libelle' => $val
                ];
            }
            elseif($item['id'] == 6){
                $val = $item['type_enseignement'];
                $tab[] =[
                    'total' => $this->nbreTotalStudent($val),
                    'nbreF'  => $this->nbreInscrisSelonSexe($val, 'F'),
                    'nbreM'  => $this->nbreInscrisSelonSexe($val, 'M'),
                    'libelle' => $val
                ];
            }
        }
        return $tab;
    }



    protected function nbreTotalStudent($type)
    {
        $nbre =  Student::where('type', changeVal($type))->where('status', '1')->where('school_id', auth()->user()->school_id)->count();
        return ($nbre <= 9 ? '0'.$nbre:$nbre);
    }


    protected function nbreInscrisSelonSexe($type, $sexe)
    {
        $nbre =  Student::where('type', changeVal($type))->where('sexe', $sexe)->where('status', '1')->where('school_id', auth()->user()->school_id)->count();
        return ($nbre <= 9 ? '0'.$nbre:$nbre);
    }

    protected function getSexe($id){
        $val = Student::find($id);
        return $val['sexe'];
    }

    protected function actifYear()
    {
        return SchoolYear::where('status', '1')->first();
    }

}
