<?php

namespace App\Http\Controllers;
use App\Models\Level;
use App\Models\Setting;
use App\Models\Serie;
use App\Models\SchoolSerie;
use App\Models\FiliereSchool;
use App\Models\Coefficient;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;


class LevelController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        try{
            $data = Setting::where('school_id',auth()->user()->school_id)->first(); 
            return view('pages.level.index',['data' => $this->typeEnseignement($data)]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function list(Request $request)
    {
        try{
            $dts = $request['data'] > 9 ? $this->schoolMatterLevelAutre($request['data']):$this->schoolMatterLevelPrimaire($request['data']);
            $level = Level::find($request['data']);
            return response()->json(['data' => $dts, 'level' => ucwords($level->level)]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function storeSerie(Request $request)
    {
        try{
            $vls = $request->validate([
                'getSerie' => 'required|string'
            ]);
            SchoolSerie::create([
                'serie_id' => $this->serie(mb_strtoupper($vls['getSerie']), $request['2nd'], $request['1ere'], $request['tle']),
                'school_id' => auth()->user()->school_id
            ]);
            return back()->with([
                'str' => 'success',
                'msg' => 'Série ajoutée avec succes.',
                'string' => 'technique'
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.',
                'string' => 'technique'
            ]);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function storeFiliere(Request $request)
    {
        try{
            $vls = $request->validate([
                'name' => 'required|string',
                'abrege' => 'required|string'
            ]);
            FiliereSchool::create([
                'level_id' => $this->filiere($vls['name'], $vls['abrege']),
                'school_id' => auth()->user()->school_id
            ]);
            return back()->with([
                'str' => 'success',
                'msg' => 'Filière ajoutée avec succes.',
                'string' => 'supérieur'
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.',
                'string' => 'supérieur'
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    public function searchLevel(Request $request)
    {
        try{
            $dts = Level::where('id', $request['data'])->where('status', '1')->first();
            return response()->json($dts);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }


    public function searchSerie(Request $request)
    {
        try{
            $val = explode('_', $request['val']);
            $dts = Level::where('id',$val[0])->where('status', '1')->first();
            $lib = $dts['code'] ?? ucwords($dts['level']);
            if(in_array($request['lib'], ['Collège - Lycée', 'Lycée'])){
                $data =  $this->getSerieLycee($val[1]);
            }
            elseif($request['lib'] == 'technique'){
                $data = $this->getSerietechnique($val[1]);
            }
            else{
                $data = $this->getAnneeSuperieur();
            }
            return response()->json(['data' => $data, 'libelle' => $lib]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }


    public function mattiere(Request $request)
    {
        try{
            $level = Level::where('id',$request['data'])->where('status', '1')->first();
            $serie = Serie::where('id',$request['serie'])->where('status', '1')->first();
            $lib =( $level['code'] ?? ucwords($level['level'])).' '.$serie['serie'];
            return response()->json(['data' =>  $this->schoolMatterLevelSerie($request['data'], $request['serie']), 'libelle' => $lib]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }


   /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        try{
            $vls = $request->validate([
                'libelle1' => 'required|string',
                'libelle2' => 'nullable|string'
            ]);
            $dts = Level::where('id', $id)->where('status', '1')->first();
            $dts->update([
                'level' => $vls['libelle1'],
                'code' => $vls['libelle2'] ?? null,
            ]);
            return back()->with([
                'str' => 'info',
                'msg' => 'Mis à jour effectué avec succes.'
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        try{
            $dts = FiliereSchool::where('level_id', $id)->where('school_id', auth()->user()->school_id)->first();
            if($dts){
                $dts->delete();
                return back()->with([
                    'str' => 'info',
                    'msg' => 'Filière désactivée avec succes.',
                    'string' => 'supérieur'
                ]);
            }
            else{
                return back()->with([
                    'str' => 'warning',
                    'msg' => 'Vous n\'êtes pas éligible pour cette action.'
                ]);
            }
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }


    /**
     * Remove the specified resource from storage.
     */
    protected function typeEnseignement($dts){
        $tab = []; $i = 0; $primaire = 0; $cycle = 0;
        $data = [1 => 'realtime-reorder', 2 => 'basic-col-reorder', 3 => 'saving-reorder', 4 => 'predefine-reorder', 5 => null];
        foreach ($dts->school->typeEnseignements as $item) {
            if(!$primaire && ($item['id'] == 1 || $item['id'] == 2)){
                $tab[] = [
                    'nbre' => $i+=1, 
                    'tab' => $data[$i], 
                    'libelle' => verifyPrimaire($dts->school->typeEnseignements),
                    'data' => verifyGetId($dts->school->typeEnseignements, 1, 2) == 1 ? Level::where('type_enseignement_id', $item['id'])->where('status', '1')->get():Level::where('type_enseignement_id', 1)->orWhere('type_enseignement_id', 2)->where('status', '1')->get(),
                    '2nd' => [],
                    '1ere' => [],
                    'tle' => [],
                ];$primaire++;
            }
            elseif(!$cycle && ($item['id'] == 3 || $item['id'] == 4)){
                $tab[] = [
                    'nbre' => $i+=1,
                    'tab' => $data[$i], 
                    'libelle' => verifySeconde($dts->school->typeEnseignements),
                    'data' => verifyGetId($dts->school->typeEnseignements, 3, 4) == 1 ? Level::where('type_enseignement_id', $item['id'])->where('status', '1')->get():Level::where('type_enseignement_id', '3')->orWhere('type_enseignement_id', '4')->where('status', '1')->get(),
                    '2nd' => getLevelSerie($dts->school->series, '2nd', 'secondaire'),
                    '1ere' => getLevelSerie($dts->school->series, '1ere', 'secondaire'),
                    'tle' => getLevelSerie($dts->school->series, 'tle', 'secondaire'),
                ]; $cycle++;
            }
            elseif($item['id'] == 5){
                $val = $item['type_enseignement'];
                $tab[] =[
                    'nbre' => $i+=1, 
                    'tab' => $data[$i], 
                    'libelle' => $val,
                    'data' => Level::where('type_enseignement_id', $item['id'] == 5 ? '4':$item['id'])->where('status', '1')->get(),
                    '2nd' => getLevelSerie($dts->school->series, '2nd', $val),
                    '1ere' => getLevelSerie($dts->school->series, '1ere', $val),
                    'tle' => getLevelSerie($dts->school->series, 'tle', $val),
                    
                ];
            }
            elseif($item['id'] == 6){
                $val = $item['type_enseignement'];
                $tab[] =[
                    'nbre' => $i+=1, 
                    'tab' => $data[$i], 
                    'libelle' => $val,
                    'data' => $dts->school->levels,
                    '2nd' => [],
                    '1ere' => [],
                    'tle' => [],
                ];
            }
        }
        return $tab;
    }


    /**
     * Remove the created serie.
     */
    protected function serie($serie, $snd = null, $pmre = null, $tle = null){
        $dt = Serie::where('serie', $serie)->first();
        if(!$dt){
            $dt = Serie::create([
                'serie' => $serie,
                '2nd' => $snd ?? '0',
                '1ere' => $pmre ?? '0',
                'tle' => $tle ?? '0',
                'type' => 'technique'
            ]);
        }
        return $dt['id'];
    }


     /**
     * Remove the created serie.
     */
    protected function filiere($filiere, $abrege = null){
        $dt = Level::where('level', $filiere)->orWhere('code', $abrege)->first();
        if(!$dt){
            $dt = Level::create([
                'level' => $filiere,
                'code' => $abrege ?? null,
                'type_enseignement_id' => '6'
            ]);
        }
        return $dt['id'];
    }


    protected function schoolMatterLevelPrimaire($val){
        $matters =  DB::table('primary_matters')
        ->join('level_primary_matters', 'primary_matters.id', '=', 'level_primary_matters.primary_matter_id')
        ->select('primary_matters.id', 'primary_matters.libelle', 'level_primary_matters.points')
        ->where('level_primary_matters.level_id', '=', $val)
        ->orderBy('primary_matters.libelle')
        ->get();

        return $matters;
    }


    protected function getAnneeSuperieur()
    {
        $dts = Serie::where('type', 'superieur')->get();
        $tab = [];
        foreach($dts as $item){
            $tab[] = [
                'id' => $item['id'],
                'libelle' => $item['serie']
            ];
        }
        return $tab;
    }


    protected function getSerieLycee($id)
    {
        $dts = Serie::where($id, '1')->where('type', 'secondaire')->get();
        $tab = [];
        foreach($dts as $item){
            $tab[] = [
                'id' => $item['id'],
                'libelle' => $item['serie']
            ];
        }
        return $tab;
    }


    protected function getSerietechnique($lib)
    {
        $dts = DB::table('series')
        ->join('school_serie', 'series.id', '=', 'school_serie.serie_id')
        ->select('series.serie','series.id')->where('school_serie.school_id', '=', auth()->user()->school_id)
        ->where('series.'.$lib, '=', '1')->where('series.type', '=', 'technique')->get();
        $tab = [];
        foreach($dts as $item){
            $tab[] = [
                'id' => $item->id,
                'libelle' => $item->serie
            ];
        }
        return $tab;
    }


    protected function schoolMatterLevelAutre($val){
        $matters =  DB::table('matters')
        ->join('level_matter', 'matters.id', '=', 'level_matter.matter_id')
        ->select()->where('level_matter.school_id', '=', auth()->user()->school_id)
        ->where('level_matter.level_id', '=', $val)
        ->where('level_matter.matter_id', '<>', '14')
        ->orderBy('matters.libelle')->get();

        $tabs = [];
        foreach($matters as $item){
            $tabs[] = [
                'id' => $item->matter_id,
                'libelle' => $item->libelle,
                'points' => Coefficient::where('id',$item->coefficient_id)->first()['valeur']
            ];
        }
        return $tabs;
    }



    protected function schoolMatterLevelSerie($val, $serie){
        $matters =  DB::table('matters')
        ->join('level_matter', 'matters.id', '=', 'level_matter.matter_id')
        ->select()->where('level_matter.school_id', '=', auth()->user()->school_id)
        ->where('level_matter.level_id', '=', $val)
        ->where('level_matter.matter_id', '<>', '14')
        ->where('level_matter.serie_id', '=', $serie)
        ->orderBy('matters.libelle')->get();

        $tabs = [];
        foreach($matters as $item){
            $tabs[] = [
                'id' => $item->matter_id,
                'libelle' => $item->libelle,
                'points' => Coefficient::where('id',$item->coefficient_id)->first()['valeur']
            ];
        }
        return $tabs;
    }
}
