<?php

namespace App\Http\Controllers;

use App\Models\SchoolYear;
use App\Models\Setting;
use App\Models\Classe;
use App\Models\AfterNoonTime;
use App\Models\MorningTime;
use App\Models\WeekDay;
use App\Models\TimeMorning;
use App\Models\TimeAfter;
use App\Models\User;
use App\Models\Matter;
use App\Models\ClasseEnseignant;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use PDF;

class EmploiTempsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($string)
    {
        try{
            $val = explode('_', $string);
            $class = Classe::where('id', $val[0])->where('school_id', auth()->user()->school_id)->first();
            $morning = MorningTime::where('school_id', $class['school_id'])->get();
            $after = AfterNoonTime::where('school_id', $class['school_id'])->get();
            return view('pages.times.index',[
                'days' => $this->getDays($class['type']),
                'morning' => $morning,
                'after' => $after,
                'class' => $class,
                'dtsMrg' => $this->getMorning($class),
                'dtsAfter' => $this->getAfters($class),
                'string' => $val[1],
                'existe' => (count($this->getMorning($class)) || count($this->getAfters($class))) ? true:false
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * get return classe the form for creating a new resource.
     */
    public function getReturn($string)
    {
        return redirect()->route('classe.index')->with([
            'str' => '',
            'msg' => '',
            'lib' => $string
        ]);
    }

    /**
     * generate pdf the form for creating a new resource.
     */
    public function generatePdf($id)
    {
        try{
            $class = Classe::where('id', $id)->where('school_id', auth()->user()->school_id)->first();
            $setting = Setting::where('school_id', $class['school_id'])->first();
            $morning = MorningTime::where('school_id', $class['school_id'])->get();
            $after = AfterNoonTime::where('school_id', $class['school_id'])->get();
            $pdf = PDF::loadView('pdf.emploi_temps', [
                'days' => $this->getDays($class['type']),
                'morning' => $morning,
                'after' => $after,
                'class' => $class,
                'school' => $setting,
                'dtsMrg' => $this->getMorning($class),
                'dtsAfter' => $this->getAfters($class),
            ]);
            $pdf->setPaper('A4', 'portrait'); // ou 'A4', 'A3', etc.
            // return $pdf->download('emploi_du_temps.pdf');
            return $pdf->stream('emploi_du_temps'.$class['libelle'].'.pdf');
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create($string)
    {
        try{
            $val = explode('_', $string);
            $class = Classe::where('id', $val[0])->where('school_id', auth()->user()->school_id)->first();
            $morning = MorningTime::where('school_id', $class['school_id'])->get();
            $after = AfterNoonTime::where('school_id', $class['school_id'])->get();
            return view('pages.times.create',[
                'days' => $this->getDays($class['type']),
                'morning' => $morning,
                'after' => $after,
                'classe' => $class,
                'matter' => $this->matter($class['level_id'], $class['serie_id'], $class['lv2'], $class['additif']),
                'dtsMrg' => $this->getMorning($class) ?? null,
                'dtsAfter' => $this->getAfters($class) ?? null,
                'string' => $val[1]
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $class)
    {
        try{
            $vals = $request->validate([
                'nbreM' => 'required|integer',
                'nbreA' => 'required|integer',
                'year' => 'required|integer',
            ]);
            $matMng = $request['matMng'];
            $matAft = $request['matAfter'];
            $i = 0;
            $this->deleteMorningTime(auth()->user()->school_id,$class);
            $this->deleteAfterNoonTiem(auth()->user()->school_id,$class);
            foreach($request['day'] as $day){
                $i <= $vals['nbreM'] ? $this->saveMorning($day, $matMng[$i], $class, $i+1,$vals['year']):null;
                $i <= $vals['nbreA'] ? $this->saveAfter($day, $matAft[$i], $class, $i+1,$vals['year']):null;
                $i++;
            }
            return redirect()->route('time.index',$request['infoClass'])->with([
                'str' => 'success',
                'msg' => 'Emploi du temps crée.'
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Request $request){
        try{
            $datas = $this->getEnseignantMatter($request['id']);
            return response()->json($datas);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    public function add_create($string)
    {
        try{
            $val = explode('_', $string);
            $class = Classe::where('id', $val[0])->where('school_id', auth()->user()->school_id)->first();
            $profs = User::where('typeEnseignant','professeur')->where('school_id', $class['school_id'])->where('status', '1')->orderBy('first_name')->orderBy('last_name')->get();
            $exists = ClasseEnseignant::where('classe_id', $val[0])->get();
            return view('pages.times.add_teacher',[
                'classe' => $class,
                'profs' => $profs ?? [],
                'exists' => $exists,
                'matter' => $this->teacherMatter($class['level_id'], $class['serie_id'], $class['lv2'], $class['additif']),
                'string' => $val[1]
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function add_store(Request $request)
    {
        try{
            $vals = $request->validate([
                'class' => 'required|integer',
            ]);
            $prof = $request['profs'];
            $matter = $request['matter'];
            $this->deleteClasseEnseignant($vals['class']); // Supprimer les données existantes de cette classe
            $i = 0;
            while($i < sizeof($prof)){
                if($prof[$i] && $matter[$i]){
                    ClasseEnseignant::create([
                        'user_id' => $prof[$i],
                        'matter_id' => $matter[$i],
                        'classe_id' => $vals['class'],
                        'prof_prl' => $request['pp'] == $i+1 ? '1':'0',
                    ]);
                }
                $i++;
            }
            return redirect()->route('time.index',$request['infoClass'])->with([
                'str' => 'success',
                'msg' => 'Enseignant ajouté avec succes.'
            ]);

        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Update the specified resource in storage.
     */
    protected function getEnseignantMatter($id){
        $tab = [];
        $datas = ClasseEnseignant::where('classe_id', $id)->get();
        foreach($datas as $item){
            $tab[] = [
                'name' => ucfirst(($item->user->sexe == "F" ? 'Mde ':'M. ').$item->user->first_name.' '.$item->user->last_name),
                'mat' => ucfirst($item->matter->abbreviated ?? $item->matter->libelle),
                'pp' => $item->prof_prl ?? null
            ];
        }
        return $tab;
    }

    /**
     * Update the specified resource in storage.
     */
    public function deleteClasseEnseignant($id)
    {
        ClasseEnseignant::where('classe_id', $id)->delete();
    }

    /**
     * Remove the specified resource from storage.
     */
    protected function deleteMorningTime($school,$class)
    {
        TimeMorning::where('school_id', $school)->where('classe_id', $class)->delete();
    }


    /**
     * Remove the specified resource from storage.
     */
    protected function deleteAfterNoonTiem($school,$class)
    {
        TimeAfter::where('school_id', $school)->where('classe_id', $class)->delete();
    }


    /**
     * Remove the specified resource from storage.
     */
    protected function matter($level, $serie = null, $lv2 = null, $additif = null)
    {
        if($lv2 == 'mixte'){
            $dts = DB::table('matters')
            ->join('level_matter', 'matters.id', '=', 'level_matter.matter_id')
            ->select('matters.id', 'matters.libelle', 'matters.abbreviated')
            ->where('level_matter.school_id', '=', auth()->user()->school_id)
            ->where('level_matter.level_id', '=', $level)
            ->where('level_matter.serie_id', '=', $serie ?? null)
            ->where('matters.libelle', '<>', 'espagnol')
            ->where('matters.libelle', '<>', 'allemand')
            ->where('level_matter.matter_id', '<>', '15')
            ->orderBy('matters.libelle')
            ->get();$serie ? $dts[] = $this->mixteMatiere($level):null;
            // $dts = $this->matterGetClassMixte($level, $serie);
        }
        else{
            $dts = $this->matterGetClassNonMixte($level, $serie, $lv2);
        }
        $additif = $additif ? ($additif == 'AP' ? 'Mus':'AP'):null;
        
        return $additif ? $dts->where('abbreviated', '<>', $additif):$dts->where('libelle', '<>','Arts plastique')->where('libelle', '<>','Musique');
    }



    protected function teacherMatter($level, $serie = null, $lv2 = null, $additif = null){
        if($lv2 == 'mixte'){
            $dts = $this->matterGetClassMixte($level, $serie);
        }
        else{
            // $lv2 = $lv2 == 'allemand' ? 'espagnol':'allemand';
            $dts = $this->matterGetClassNonMixte($level, $serie, $lv2);
        }
        $additif = $additif ? ($additif == 'AP' ? 'Mus':'AP'):null;
        return $additif ? $dts->where('abbreviated', '<>', $additif):$dts->where('libelle', '<>','Arts plastique')->where('libelle', '<>','Musique');
    }

    /**
     * Remove the specified resource from storage.
     */
    protected function getDays($type){
        $days = WeekDay::get();
        switch ($type) {
            case $type == "superieur":
                return $days;
                break;
            case $type == "primaire":
                return $days->where('id', '<>', '3')->where('id', '<>', '6');
                break;
            default:
                return $days->where('id', '<>', '6');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    protected function saveMorning($day, $matters, $class, $ligne, $year){
        foreach($matters as $item){
            if($item != null){
                TimeMorning::create([
                    'school_id' => auth()->user()->school_id,
                    'school_year_id' => $year,
                    'classe_id' => $class,
                    'matter_id' => explode('_',$item)[1],
                    'morning_time_id' => explode('_',$item)[0],
                    'week_day_id' => $day,
                    'ligne'  => $ligne
                ]);
            }
        }
    }


    /**
     * Remove the specified resource from storage.
     */
    protected function saveAfter($day, $matters = null, $class, $ligne, $year){
        foreach($matters as $item){
            if($item != null){
                TimeAfter::create([
                    'school_id' => auth()->user()->school_id,
                    'school_year_id' => $year,
                    'classe_id' => $class,
                    'matter_id' => explode('_',$item)[1],
                    'after_noon_time_id' => explode('_',$item)[0],
                    'week_day_id' => $day,
                    'ligne'  => $ligne
                ]);
            }
        }
    }


    protected function matterGetClassMixte($level, $serie = null)
    {
        $dts = DB::table('matters')
        ->join('level_matter', 'matters.id', '=', 'level_matter.matter_id')
        ->select('matters.id', 'matters.libelle', 'matters.abbreviated')
        ->where('level_matter.school_id', '=', auth()->user()->school_id)
        ->where('level_matter.level_id', '=', $level)
        ->where('level_matter.serie_id', '=', $serie ?? null)
        ->where('matters.libelle', '<>', 'mixte')
        ->where('level_matter.matter_id', '<>', '15')
        ->orderBy('matters.libelle')
        ->get();

        return $dts;
    }


    protected function matterGetClassNonMixte($level, $serie = null, $lv2)
    {
        $lv2 = $lv2 == 'allemand' ? 'espagnol':'allemand';
        $dts = DB::table('matters')
        ->join('level_matter', 'matters.id', '=', 'level_matter.matter_id')
        ->select('matters.id', 'matters.libelle', 'matters.abbreviated')
        ->where('level_matter.school_id', '=', auth()->user()->school_id)
        ->where('level_matter.level_id', '=', $level)
        ->where('level_matter.serie_id', '=', $serie ?? null)
        ->where('matters.libelle', '<>', $lv2)
        ->where('matters.libelle', '<>', 'mixte')
        ->where('level_matter.matter_id', '<>', '15')
        ->orderBy('matters.libelle')
        ->get();

        return $dts;
    }


    protected function mixteMatiere($level)
    {
        $dts = DB::table('matters')
            ->join('level_matter', 'matters.id', '=', 'level_matter.matter_id')
            ->select('matters.id', 'matters.libelle', 'matters.abbreviated')
            ->where('level_matter.school_id', '=', auth()->user()->school_id)
            ->where('level_matter.level_id', '=', $level)
            ->where('matters.libelle', '=', 'mixte')->first();
        return $dts;
    }


    /**
     * Remove the specified resource from storage.
     */
    protected function getMorning($class){
        return TimeMorning::where('school_id', $class['school_id'])->where('classe_id', $class['id'])->get();
    }


    /**
     * Remove the specified resource from storage.
     */
    protected function getAfters($class){
        return TimeAfter::where('school_id', $class['school_id'])->where('classe_id', $class['id'])->get();
    }
}