<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use App\Models\SchoolYear;
use App\Models\Classe;
use App\Models\Inscription;
use App\Models\LevelMatter;
use App\Models\CuttingSchoolYear;
use App\Models\WeekDay;
use App\Models\TimeAfter;
use App\Models\TimeMorning;
use App\Models\Absence;
use App\Models\AbsencePrimary;
use App\Models\Sanction;
use App\Models\Inscrption;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class AppelController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        try{
            $data = Setting::where('school_id',auth()->user()->school_id)->first();
            return view('pages.appels.index',[
                'data' => $this->typeEnseignement($data)
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        try{
            $url = to_route('appel.return', $request['matter'].'_'.$request['classed']);
            $val = $request->validate([
                'cutting' => 'required|integer',
                'classed' => 'required|integer',
                'matter' => 'required|string',
                'date' => 'required|date',
                'period' => 'required|integer'
            ]);

            // Si tu veux en français :
            if(!$this->verifytAppel($val['classed'],$val['matter'],$val['cutting'],$val['date'],$val['period'])){
                $exite = $this->getTime($val['period'],$val['classed'],$val['matter'],$val['date']);
                if(sizeof($exite) != null){
                    $class = Classe::where('id', $val['classed'])->first();
                    $matter = LevelMatter::where('matter_id', $val['matter'])->where('school_id', auth()->user()->school_id)->first();
                    $lv2 = $class['lv2'] == 'mixte' ? (verifyLv2($matter->matter->libelle) ? $matter->matter->libelle:null):null;
                    return view('pages.appels.create',[
                        'datas' => $this->getStudent($class->id, $lv2),
                        'class' => $class,
                        'matter' => $matter,
                        'time' => $exite,
                        'today' => $val['date'],
                        'decoupage' => $val['cutting'],
                        'period' => $val['period']
                    ]);
                }
                else{
                    return $url->with([
                        'str' => 'warning',
                        'msg' => 'Informations incompatibles à l\'emploi du temps de la classe!'
                    ]);
                }
            }
            else{
                return $url->with([
                    'str' => 'info',
                    'msg' => 'Appel effectué !'
                ]);
            }
        }
        catch (\Exception $e) {
            return $url->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }


    /**
     * Show the form for creating a new resource.
     */
    public function primary_create(Request $request, $id)
    {
        try{
            $val = $request->validate([
                'classed' => 'required|integer',
                'weeks' => 'required|string',
                'date' => 'required|date',
                'period' => 'required|integer'
            ]);
            $toDay = ['Monday', 'Tuesday', 'Thursday', 'Friday'];
            if(in_array(date("l", strtotime(date($request['date']))),$toDay)){
                $exist = AbsencePrimary::where('period', $request['period'])->where('week_number', $request['weeks'])->where('dateAbsence', $request['date'])->count();
                if(!$exist){
                    $class = Classe::where('id', $id)->first();
                    return view('pages.appels.create_primary',[
                        'class' => $class,
                        'today' => $val['date'],
                        'weeks' => $val['weeks'],
                        'period' => $val['period'],
                        'datas' => $this->getStudent($id),
                    ]);
                }
                else{
                    return to_route('appel.primary',$id)->with([
                        'str' => 'info',
                        'msg' => 'Appel effectué !'
                    ]);  
                }
            }
            else{
                return to_route('appel.primary',$id)->with([
                    'str' => 'warning',
                    'msg' => 'Date inconforme aux jours des cours.'
                ]);
            }
            
        }
        catch (\Exception $e) {
            return  to_route('appel.primary',$id)->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        if($request['type'] == 'primaire'){
            $created = AbsencePrimary::create([
                'period' => $request['period'],
                'inscription_id' => $request['valeur'],
                'classe_id' => $request['classed'],
                'dateAbsence' => $request['dateAb'],
                'week_number' => $request['week'],
            ]);
        }
        else{
            $tab = explode('_', $request['valeur']);
            $created = Absence::create([
                'period' => $request['period'],
                'inscription_id' => $tab[1],
                'matter_id' => $request['matter'],
                'classe_id' => $request['classed'],
                'dateAbsence' => $request['dateAb'],
                'cutting_school_year_id' => $request['cutting'],
                'time_after_id' => $request['period'] == 2 ? $tab[0]:null,
                'time_morning_id' => $request['period'] == 1 ? $tab[0]:null
            ]);
            if(in_array($request['type'], ['secondaire', 'technique'])){
                $created ? $this->saveSanction($tab[1], $request['cutting']):null;
            }
        }
        // Message de return ------------------------------------>
        return $val = $created ? 200:201;
    }


    /**
     * Store a newly created resource in storage.
     */
    public function notStore(Request $request)
    {
        if($request['type'] == 'primaire'){
            $repond = AbsencePrimary::where('period', $request['period'])->where('dateAbsence', $request['dateAb'])->where('inscription_id', $request['valeur'])->where('week_number', $request['week'])->first();
            $repond ? $repond->delete():null;
        }
        else{
            $tab = explode('_', $request['valeur']);
            $repond = Absence::where('period', $request['period'])->where('dateAbsence', $request['dateAb'])->where('inscription_id', $tab[1])->where('matter_id', $request['matter'])->where('cutting_school_year_id', $request['cutting'])->first();
            $repond ? $repond->delete():null;
            if(in_array($request['type'], ['secondaire', 'technique'])){
                $repond ? $this->deleteSanction($tab[1], $request['cutting']):null;
            }
        }
        // Message de return ------------------------------------>
        return $repond ? 200:201;
    }


    /**
     * Display the specified resource.
     */
    public function show(Request $request)
    {
        try{
            $val = $request->validate(['select' => 'required|string']);
            $type = ['secondaire' => 'general', 'technique' => 'technique', 'superieur' => 'superieur'];
            $val = explode('_', $val['select']);
            $class = Classe::where('id', $val[1])->first();
            $matter = LevelMatter::where('matter_id', $val[0])->where('school_id', auth()->user()->school_id)->first();
            $cutting = CuttingSchoolYear::where('type', $type[$class['type']])->where('school_year_id', $this->yearActif()['id'])->get();
            $lv2 = $class['lv2'] == 'mixte' ? (verifyMatterLv2($matter->matter->id) ? $matter->matter->libelle:null):null;
            return view('pages.appels.detail',[
                'datas' => $this->getCutting($cutting, $val[1], $val[0], $lv2),
                'class' => $class,
                'matter' => $matter
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    
    /**
     * Display the specified resource.
     */
    public function primary($id)
    {
        try{
            $weekNumber = date("W", strtotime(date("Y-m-d"))); // Deternimation du nombre de la semaine
            $class = Classe::where('id', $id)->first();
            return view('pages.appels.detail_primary',[
                'class' => $class,
                'weekNumber' => $weekNumber,
                'datas' => $this->getStudentPrimary($id, $weekNumber)
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Search the specified resource.
     */
    public function search(Request $request)
    {
        try{
            $stud = Inscription::where('id', $request['student'])->first();
            $student = strtoupper($stud->student->first_name).' '.ucwords($stud->student->last_name);
            $dtas = AbsencePrimary::where('inscription_id', $request['student'])->where('week_number', $request['weeks'])->get();
           return response()->json(['student' => $student, 'datas' => $dtas]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }


    /**
     * Display the specified resource.
     */
    public function return(string $string)
    {
        try{
            $type = ['secondaire' => 'general', 'technique' => 'technique', 'superieur' => 'superieur'];
            $val = explode('_', $string);
            $class = Classe::find($val[1]);
            $matter = LevelMatter::where('matter_id', $val[0])->where('school_id', auth()->user()->school_id)->first();
            $cutting = CuttingSchoolYear::where('type', $type[$class['type']])->where('school_year_id', $this->yearActif()['id'])->get();
            $lv2 = $class['lv2'] == 'mixte' ? (verifyMatterLv2($matter->matter->id) ? $matter->matter->libelle:null):null;
            return view('pages.appels.detail',[
                'datas' => $this->getCutting($cutting, $val[1], $val[0], $lv2),
                'class' => $class,
                'matter' => $matter
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $string)
    {
        try{
            $vals = explode('_', $string);
            $inscris = Inscription::find($vals[2]);
            $cutting = CuttingSchoolYear::find($vals[0]);
            $matter = LevelMatter::where('matter_id', $vals[1])->where('school_id', auth()->user()->school_id)->first();
            $data = Absence::where('inscription_id', $vals[2])->where('matter_id', $vals[1])->where('cutting_school_year_id', $vals[0])->orderBy('dateAbsence', 'DESC')->get();
            return view('pages.appels.edit',[
                'data' => $data,
                'inscris' => $inscris,
                'matter' => $matter,
                'cutting' => $cutting
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        try{
            $vals = $request->validate([
                'type' => 'required|integer',
                'string' => 'required|string',
                'absId' => 'required|string',
                'typeEnseig' => 'required|string',
            ]);
            $data = Absence::find($vals['absId']);
            if(in_array($request['typeEnseig'], ['secondaire', 'technique'])){
                $data ? $this->deleteSanction($data['inscription_id'], $data['cutting_school_year_id']):null;
            }
            
            if($vals['type'] == 2){
                $data->delete();
            }
            elseif($vals['type'] == 1){
                $data->update([
                    'justified' => '1',
                    'motifs' => $request['motif'] ?? 'Motif non indiqué',
                ]);
            }
            return back()->with([
                'str' => 'info',
                'msg' => 'Justificatif approuvé.'
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }


    /**
     * Get data class the specified resource from storage.
     */
    protected function typeEnseignement($dts)
    {
        $tab = []; $i = 0; $primaire = 0; $cycle = 0;
        $school = auth()->user()->school_id;
        $data = [1 => 'realtime-reorder', 2 => 'basic-col-reorder', 3 => 'saving-reorder', 4 => 'predefine-reorder', 5 => null];
        foreach ($dts->school->typeEnseignements as $item) {
            if(!$primaire && ($item['id'] == 1 || $item['id'] == 2)){
                $tab[] = [
                    'nbre' => $i+=1, 
                    'tab' => $data[$i], 
                    'libelle' => verifyPrimaire($dts->school->typeEnseignements),
                    'data' => Classe::where('type', 'primaire')->where('school_year_id', $this->yearActif()['id'])->where('status', '1')->where('school_id', $school)->get()
                ];$primaire++;
            }
            elseif(!$cycle && ($item['id'] == 3 || $item['id'] == 4)){
                $tab[] = [
                    'nbre' => $i+=1,
                    'tab' => $data[$i], 
                    'libelle' => verifySeconde($dts->school->typeEnseignements),
                    'data' => Classe::where('type', 'secondaire')->where('school_year_id', $this->yearActif()['id'])->where('status', '1')->where('school_id', $school)->get(),
                ];$cycle++;
            }
            elseif($item['id'] == 5){
                $val = $item['type_enseignement'];
                $tab[] =[
                    'nbre' => $i+=1, 
                    'tab' => $data[$i], 
                    'libelle' => ucfirst($val),
                    'data' => Classe::where('type', 'technique')->where('school_year_id', $this->yearActif()['id'])->where('status', '1')->where('school_id', $school)->get(),
                ];
            }
            elseif($item['id'] == 6){
                $val = $item['type_enseignement'];
                $tab[] =[
                    'nbre' => $i+=1, 
                    'tab' => $data[$i], 
                    'libelle' => $val,
                    'data' => Classe::where('type', 'superieur')->where('school_year_id', $this->yearActif()['id'])->where('status', '1')->where('school_id', $school)->get(),
                ];
            }
        }
        return $tab;
    }


    /**
     * Gestion the cutting school year the specified resource from storage.
     */
    protected function getCutting($cutting, $classe, $matter, $lv2 = null)
    {
        $tabs = [];$i = 1;
        $data = [1 => 'realtime-reorder', 2 => 'basic-col-reorder', 3 => 'saving-reorder', 4 => 'predefine-reorder', 5 => null];
        foreach($cutting as $item){
            $tabs[] = [
                'id' => $item->id,
                'libelle' => $item->cutting['libelle'], 
                'actif' => $item->status,
                'tab' => $data[$i],
                'data' => $this->getStudentAbsence($classe, $matter, $item->id, $lv2)
            ];
            $i++;
        }
        return $tabs;
    }


    private function getJourSemaine($date)
    {
        $jours = [
            'Monday' => 'Lundi',
            'Tuesday' => 'Mardi',
            'Wednesday' => 'Mercredi',
            'Thursday' => 'Jeudi',
            'Friday' => 'Vendredi',
            'Saturday' => 'Samedi',
            'Sunday' => 'Dimanche'
        ];
        $jour_en = date('l', strtotime($date));

       return $jours[$jour_en];
    }


    private function getTime($int, $class, $matter, $date)
    {
        $day = WeekDay::where('day', strtolower($this->getJourSemaine($date)))->first();
        if($int == 1){
            $dts = TimeMorning::where('classe_id', $class)->where('matter_id', $matter)->where('week_day_id', $day['id'])->where('school_id', auth()->user()->school_id)->get();
        }
        else{
            $dts = TimeAfter::where('classe_id', $class)->where('matter_id', $matter)->where('week_day_id', $day['id'])->where('school_id', auth()->user()->school_id)->get();
        }
        return $dts;
    }


    private function getStudentAbsence($class, $matter, $cutting, $lv2 = null)
    {
        $tab = [];
        foreach($this->getStudent($class, $lv2) as $item){
            $tab[] = [
                'id' => $item['id'],
                'name' => strtoupper($item['first_name']).' '.ucwords($item['last_name']),
                'matricule' => $item['matricule'],
                'sexe' => $item['sexe'],
                'photo' => $item['photo'],
                'nbre_abs' => Absence::where('inscription_id', $item['id'])->where('cutting_school_year_id', $cutting)->where('matter_id', $matter)->count(),
                'nbre_abs_justif' => Absence::where('inscription_id', $item['id'])->where('cutting_school_year_id', $cutting)->where('matter_id',$matter)->where('justified', '1')->count(),
                'nbre_abs_injustif' => Absence::where('inscription_id', $item['id'])->where('cutting_school_year_id', $cutting)->where('matter_id',$matter)->where('justified', '0')->count(),
            ];
        }
        return $tab;
    }


    private function getStudentPrimary($idClasse, $weeks)
    {
        $tab = [];
        foreach($this->getStudent($idClasse) as $item){
            $tab[] = [
                'id' => $item['id'],
                'name' => strtoupper($item['first_name']).' '.ucfirst($item['last_name']),
                'matricule' => $item['matricule'],
                'sexe' => $item['sexe'],
                'photo' => $item['photo'],
                'nbre_mtn' => AbsencePrimary::where('inscription_id', $item['id'])->where('week_number', $weeks)->where('period', '1')->count(),
                'nbre_midi' => AbsencePrimary::where('inscription_id', $item['id'])->where('week_number', $weeks)->where('period', '2')->count(),
            ];
        }
        return $tab;
    }


    protected function getStudent($class, $lv2 = null)
    {
        return $lv2 != null ? $this->classeEndLv2($class, $lv2):$this->classeSimple($class);
    }


    protected function classeEndLv2($class, $lv2)
    {
        $data = DB::table('inscriptions')
        ->join('students', 'students.id', '=', 'inscriptions.student_id')
        ->select('inscriptions.id', 'students.first_name', 'students.last_name', 'students.matricule', 'students.photo', 'students.sexe')
        ->where('inscriptions.classe_id', '=', $class)
        ->where('inscriptions.lv2', '=', strtolower($lv2))
        ->orderBy('students.first_name')->orderBy('students.last_name')->get();
        return json_decode($data, true);
    }


    protected function classeSimple($class)
    {
        $data = DB::table('inscriptions')
        ->join('students', 'students.id', '=', 'inscriptions.student_id')
        ->select('inscriptions.id', 'students.first_name', 'students.last_name', 'students.matricule', 'students.photo', 'students.sexe')
        ->where('inscriptions.classe_id', '=', $class)
        ->orderBy('students.first_name')->orderBy('students.last_name')->get();
        return json_decode($data, true);
    }


    private function verifytAppel($class, $matter, $cutting, $date, $period)
    {
        $count = Absence::where('classe_id',$class)->where('cutting_school_year_id',$cutting)->where('matter_id',$matter)->where('dateAbsence',$date)->where('period',$period)->count();
        return $count;
    }


    protected function saveSanction($student, $cutting)
    {
        Sanction::create([
            'motif_sanction_id' => 1,
            'inscription_id' => $student,
            'motif' => 'absence injustifiées',
            'cutting_school_year_id' => $cutting
        ]);
    }


    protected function deleteSanction($student, $cutting)
    {
        $data = Sanction::where('motif_sanction_id', '1')->where('inscription_id', $student)->where('cutting_school_year_id', $cutting)->first();
        $data->delete();
    }


    /**
     * Get school year actif the specified resource from storage.
     */
    protected function yearActif(){
        $dts = SchoolYear::where('status', '1')->first();
        return $dts;
    }

}