<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="Educas est une application de gestion d'ecole dans son ensemble">
    <meta name="author" content="Jean-Marius Yao">
    <title>Liste des notes {{($matter->matter->abbreviated ?? $matter->matter->libelle)}} {{$class->libelle}}</title>
</head>
<style>
    @page {
        margin: 1cm 0.5cm 1cm 0.5cm; /* haut droite bas gauche */
    }
    
    body {
        font-size: .875em;
        overflow-x: hidden;
        color: #353c4e;
        font-family: "Open Sans", sans-serif;
    }

    /* applies border to the table */
    #tabled,th,td {
        border: 1px solid #dee2e6;
        padding: 10px;
        text-align: center
    }

    #tabled {
        width: 100%;
        border: 1px solid #dee2e6;
        border-collapse: collapse;
        table-layout: auto;
        border-spacing: 2px;
    }

    th, td {
        white-space: nowrap;
    }
</style>
<body>
    <header style="margin: 5px auto; border-bottom: 1px solid #dee2e6; height: 100px; padding-bottom: 15px">
        <div style="display: flex; flex-direction: row; justify-content: space-between;">
            <table style="width: 100%">
                <tbody>
                    <tr style="margin-bottom: 0%">
                        <td style="width: 50%; border:none">
                            <div style="text-align: center; font-size: 8px">Ministère de l'Education Nationale, de l'Enseignement <br> Technique et de la   Formation Professionnelle</div>
                        </td>
                        <td style="width: 50%; border:none">
                            <div style="text-align: center; font-size: 8px;">
                                <b >REPUBLIQUEDE COTE D'IVOIRE</b><br>
                                <i>Union - Discipline - Travail</i>
                            </div>
                        </td>
                    </tr>
                    <tr style="margin-bottom: 0%">
                        <td style="width: 40%; border:none">
                            <img src="{{public_path($school->logoUrl())}}" class="m-b-10 w-100" alt="Logo établissement" style="height: 55px;">
                        </td>
                        <td style="width: 60%; border:none">
                            <div style="text-align: center">
                                <div style="text-align: center;">
                                    <b style="font-size: 15px;">{{mb_strtoupper($school->school->name_school)}}</b><br>
                                    <i style="font-size: 9px">{{$school->address_email}} / {{$school->phon_school}}</i><br>
                                    <i style="font-size: 11px;">Année Scolaire : <b>{{$class->schoolYear->school_year}}</i>
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </header>
    {{-- <hr> --}}
    <section style="margin: 5px auto;">
        <div style="margin-top: 20px">
            <div style="margin-top: 35px; text-align: center; font-size:21px; text-decoration: underline;">
                <b>LISTE NOTES {{strtoupper($decoup->cutting->libelle)}} {{strtoupper($matter->matter->abbreviated ?? $matter->matter->libelle)}} {{$class->libelle}}</b>
            </div>
            <table id="tabled" style="margin-top: 25px">
                <thead>
                    <tr>
                        <th class="text-center" style="width: 3%">N°</th>
                        <th class="text-uppercase" style="width: 100px">Nom et prénoms</th>
                        {{-- <th class="text-uppercase" style="width: 10px">Genre</th> --}}
                        <th class="text-uppercase" style="width: 20px">Matricule</th>
                        <th class="text-center text-uppercase" style="width: 30px">CF</th>
                        <th class="text-center text-uppercase" style="width: 30px">OG</th>
                        <th class="text-center text-uppercase" style="width: 30px">EO</th>
                        <th class="text-uppercase text-center" style="width: 7%">Moyenne</th>
                        <th class="text-uppercase text-center" style="width: 5%">Rang</th>
                    </tr>
                </thead>
                <tbody>
                    @php $i = 1 @endphp
                    @foreach ($datas as $item)
                    <tr>
                        <th class="text-center py-2">
                            <div class="mt-2">{{$i <= 9 ? '0'.$i++:$i++}}</div>
                        </th>
                        <td class="py-2" style="text-align:left">
                            <div class="mt-2">{{$item['name']}}</div>
                        </td>
                        {{-- <td class="py-2"><div class="mt-2">{{ucfirst($item['sexe'] == 'F' ? 'F':'M')}}</div></td> --}}
                        <td class="py-2" style="text-align:left"><div class="mt-2">{{$item['matricule']}}</div></td>
                        <td class="p-0" style="padding: 0%">
                            <table class="table" style="margin: 0%; padding:0%">
                                <tr style="margin: 0%; padding:0%">
                                    @foreach ($item['notes']['CF']['notes'] as $item1)
                                    <td class="text-center m-0 py-1" style="margin: 0%; padding: 5px 0px">{{$item1['note']}}</td>
                                    @endforeach
                                </tr>
                                <tr style="margin: 0%; padding:0%">
                                    <td colspan="5" style="padding-top:0%; padding-bottom:0%; text-align: center">{{$item['notes']['CF']['moyenne']}}</td>
                                </tr>
                            </table>
                        </td>
                        <td class="p-0" style="padding: 0%">
                            <table class="table p-0 m-0">
                                <tr style="margin: 0%; padding:0%">
                                    @foreach ($item['notes']['OG']['notes'] as $item3)
                                    <td class="text-center m-0 py-1" style="margin: 0%; padding: 5px 0px">{{$item3['note']}}</td>
                                    @endforeach
                                </tr>
                                <tr style="margin: 0%; padding:0%">
                                    <td colspan="5" style="padding-top:0%; padding-bottom:0%; text-align: center">{{$item['notes']['OG']['moyenne']}}</td>
                                </tr>
                            </table>
                        </td>
                        <td class="p-0" style="padding: 0%">
                            <table class="table p-0 m-0">
                                <tr style="margin: 0%; padding:0%">
                                    @foreach ($item['notes']['EO']['notes'] as $item2)
                                    <td class="text-center m-0 py-1" style="margin: 0%; padding: 5px 0px">{{$item2['note']}}</td>
                                    @endforeach
                                </tr>
                                <tr style="margin: 0%; padding:0%">
                                    <td colspan="5" style="padding-top:0%; padding-bottom:0%; text-align: center">{{$item['notes']['EO']['moyenne']}}</td>
                                </tr>
                            </table>
                        </td>
                        <th class="py-2 text-center">
                            <div class="mt-2">{{$item['moyen'] ? $item['moyen']['moyenne']:'--'}}</div>
                        </th>
                        <td class="py-2 text-center">
                            <div class="mt-2">{{$item['moyen'] ? $item['moyen']['rang']:'--'}}</div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </section>
</body>
</html>