@extends('app')
@section('title','List student')
@section('link')
    <!-- Data Table Css -->
    <link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
    <link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/extensions/autofill/css/autoFill.dataTables.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/extensions/autofill/css/select.dataTables.min.css')}}">
    <style>
        .dataTables_length label{
            display: none;
        }
    </style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between mb-2">
                                    <h4>Student Inactif - {{count($students) <= 9 ? '0'.count($students):count($students)}}</h4>
                                    <span>
                                        <a href="{{route('student.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="mx-3 my-0">
                            <div class="card-block my-0">
                                <div class="dt-responsive table-responsive">
                                    <div class="tab-content card-block">
                                        <table id="autofill" class="table table-striped table-bordered nowrap mt-3">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="width:15px">N°</th>
                                                    <th>Matricule</th>
                                                    <th>Nom</th>
                                                    <th>Prénoms</th>
                                                    <th>Genre</th>
                                                    <th>Date de nais...</th>
                                                    <th>Lieu de nais...</th>
                                                    <th>Résidence</th>
                                                    <th>Photo</th>
                                                    <th class="text-center">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php $i = 1; @endphp
                                                @foreach ($students as $student)
                                                <tr>
                                                    <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                    <td>{{$student->matricule}}</td>
                                                    <td>{{strtoupper($student->first_name)}}</td>
                                                    <td>{{ucwords($student->last_name)}}</td>
                                                    <td>{{ucfirst($student->sexe == 'F' ? 'Féminin':'Masculin')}}</td>
                                                    <td>{{$student->date_birth}}</td>
                                                    <td>{{ucwords($student->place_birth)}}</td>
                                                    <td>{{ucwords($student->place_residence)}}</td>
                                                    <td class="text-center">
                                                        @if ($student->photo)
                                                        <img src="{{asset($student->urlStudent())}}" class="img-radius mx-0" alt="User-Profile-Image" style="height:40px; width:40px">
                                                        @else
                                                        <img src="{{asset($student->sexe == 'F' ? 'assets/images/stdt_w.png':'assets/images/stdt_m.png')}}" class="img-radius mx-0" alt="User-Profile-Image" style="height:40px; width:40px">
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <div class="card-block remove-label m-0 p-0 text-center">
                                                            <a href="{{route('student.show',$student->id)}}" class="btn btn-sm btn-primary text-center px-2" title="Detail"><i class="fas fa-ellipsis-h m-0"></i></a>
                                                            <a href="{{route('student.edit',$student->id)}}" class="btn btn-sm btn-info text-center px-2" title="Edit"><i class="fas fa-edit m-0"></i></a>
                                                            <button class="getIdStudent btn btn-sm btn-danger text-white text-center px-2" title="Delete" data-id="{{$student->id}}" data-toggle="modal" data-target="#modalCenter"><i class="far fa-trash-alt m-0"></i></button>
                                                        </div>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div> 
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="modalCenter" tabindex="-1" role="dialog" aria-labelledby="modalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="modalLongTitle">Delete Student</h5>
            </div>
            <div class="modal-body">
            <div class="row">
                <div class="col-12 text-center">
                    <div class="divInfo" id="divInfo"></div>
                    <p class="my-0">
                        <strong>Vous êtes sur le point de faire une suppression définitive.</strong>
                    </p>
                    <span>Cliquez sur le 'Valider' pour achéver l'action.</span>
                </div>
            </div>
            </div>
            <form action="#" method="post" id="formDelete">
                @csrf 
                @method('delete')
                <div class="modal-footer">
                    <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                    <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/jszip.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/pdfmake.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/vfs_fonts.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.select.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/extensions-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){

            $urls = window.location.href;
            $url = $urls.split('student');

            // Delete Student ................................ 
            $(document).on('click', '.getIdStudent', function() {
                $('#modalUser, #roleModal').remove();
                $id = $(this).data('id');
                $('#formDelete').attr('action', $url[0]+'student/destroy/'+$id);
                $.ajax({
                    url: '{{ route('student.delete') }}',
                    method: 'GET',
                    data: { data: $id},
                    success: function(response){
                        if(response){
                            $('#divInfo').append(
                                '<h5 class="mb-1 mt-2" id="modalUser">'+response['first_name']+' '+response['last_name']+'</h5>'+
                                '<p class="text-muted" id="roleModal"><strong>'+response['matricule']+'</strong></p>'
                            );
                            $('div#modalCenter').fadeIn();
                        }
                    }
                });
            });
        })
    </script>
@endsection