@extends('app')
@section('title', 'Add new student')
@section('link')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<link rel="stylesheet" href="{{asset('bower_components/select2/dist/css/select2.min.css')}}"/>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="card">
                    <div class="card-header mb-0 pb-0">
                        <div class="d-flex justify-content-between pb-2">                        
                            <h4>{{$data ? 'Edition d\'élève':'Ajout de nouvel élève'}}</h4>
                            <span class="m-0 p-0 text-center">
                                Les champ avec asterisk (<code>*</code>) sont obligatoires. <br>
                            </span>
                            <span>
                                <a href="{{route($data ? 'student.index':'inscription.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply m-0"></i></a>
                            </span>
                        </div>
                    </div>
                    <hr class="my-0 mx-3">
                    <div class="card-block mt-3 text-center">
                        <strong class="text-danger" id="getExist" style="display: none">Vous utilisez un matricule déjà présent !</strong>
                        <form action="{{route($data ? 'student.update':'student.store', $data ? $data->id:null)}}" method="post" enctype="multipart/form-data">
                            @csrf
                            @method($data ? 'put':'post')
                            @if (!$data)
                            <input type="hidden" value="{{$idParent}}" name="idParent">
                            <input type="hidden" value="{{$year->id}}" name="idYear">
                            @endif
                            <div class="row mb-2" style="display: {{$data ? 'none':'block'}}">
                                <div class="col-12">
                                    <div class="text-left">
                                        <label class="col-form-label text-left" for="type">Type d'enseignement<span class="text-danger">*</span> :</label>
                                        @php $j = 0; @endphp
                                        @foreach ($types as $item)
                                        <span class="ml-3 my-0">
                                            <input type="radio" class="type" name="type" value="{{$item['type']}}" id="{{$item['type']}}" {{old('type') == $item['type'] ? 'checked':($j == 0 ? 'checked':'')}} {{$data ? 'disabled':''}}>
                                            <label class="col-form-label m-1" for="{{$item['type']}}">{{ucfirst($item['libelle'])}}</label>
                                        </span>
                                        @php $j++ @endphp
                                        @endforeach
                                    </div>
                                    <div class="text-left">
                                        <span class="mr-3">Type d'apprenant au sien de l'établissement :</span>
                                        <span class="mr-2">
                                            <input type="radio" name="typeStud" id="ancient" value="1" {{old('typeStud') == '1' ? 'checked':'checked'}}> 
                                            <label for="ancient">Ancien</label>
                                        </span>
                                        <span class="mr-2">
                                            <input type="radio" name="typeStud" id="new" value="0" {{old('typeStud') == '0' ? 'checked':''}}>
                                            <label for="new">Nouvel</label>
                                        </span>
                                    </div>
                                </div> 
                            </div>
                            
                            <div class="row mb-0 text-left">
                                <div class="col-md-4 mb-2" id="divMatricule">
                                    <div class="form-group">
                                        <label class="col-form-label" for="matricule">Matricule Elève<span class="text-danger">*</span> :</label>
                                        <input type="text" name="matricule" id="matricule" class="form-control @error('matricule') is-invalid @enderror" value="{{old('matricule', $data ? $data->matricule:null)}}" placeholder="Entrez le matricule de l'élève" {{$data ? ($data['type'] == 'primaire' ? 'disabled':''):''}}>
                                        @error('matricule')
                                            <span class="form-bar text-danger" role="alert">
                                                {{$message}}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="nom">Nom Elève<span class="text-danger">*</span> :</label>
                                        <input type="text" name="nom" id="nom" class="form-control @error('nom') is-invalid @enderror" value="{{old('nom', $data ? $data->first_name:null)}}" placeholder="Entrez le nom de l'élève">
                                        @error('nom')
                                            <span class="form-bar text-danger" role="alert">
                                                {{$message}}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="prenom">Prénoms Elève<span class="text-danger">*</span> :</label>
                                        <input type="text" name="prenom" id="prenom" class="form-control @error('prenom') is-invalid @enderror" value="{{old('prenom', $data ? $data->last_name:null)}}" placeholder="Entrez le prénoms de l'élève">
                                        @error('prenom')
                                            <span class="form-bar text-danger" role="alert">
                                                {{$message}}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="sexe">Genre<span class="text-danger">*</span> :</label><br>
                                        <span class="mr-3">
                                            <input type="radio" name="sexe" id="feminin" value="F" {{ old('sexe') == 'F' ? 'checked':null }} {{$data ? ($data->sexe == 'F' ? 'checked':null):null}}>
                                            <label class="col-form-label m-1" for="feminin">Féminin</label>
                                        </span>
                                        <span class="ml-3">
                                            <input type="radio" name="sexe" id="masculin" value="M" {{ old('sexe') == 'M' ? 'checked':null }} {{$data ? ($data->sexe == 'M' ? 'checked':null):'checked'}}>
                                            <label class="col-form-label m-1" for="masculin">Masculin</label>
                                        </span><br>
                                        @error('sexe')
                                            <span class="form-bar text-danger" role="alert">
                                                {{$message}}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="dateNais">Date de naissance<span class="text-danger">*</span> :</label>
                                        <input type="text" name="dateNais" id="dateNais" class="form-control bg-white @error('dateNais') is-invalid @enderror" value="{{old('dateNais', $data ? $data->date_birth:null)}}" placeholder="Entrez la date de naissance">
                                        @error('dateNais')
                                            <span class="form-bar text-danger" role="alert">
                                                {{$message}}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="lieuNais">Lieu de naissance<span class="text-danger">*</span> :</label>
                                        <input type="text" name="lieuNais" id="lieuNais" class="form-control @error('lieuNais') is-invalid @enderror" value="{{old('lieuNais', $data ? $data->place_birth:null)}}" placeholder="Entrez le lieu de naissance">
                                        @error('lieuNais')
                                            <span class="form-bar text-danger" role="alert">
                                                {{$message}}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="nationalite">Nationalité<span class="text-danger">*</span> :</label><br>
                                        <select name="nationalite" id="nationalite" class="form-control select2 bg-white @error('nationalite') is-invalid @enderror">
                                            <option value="">Selectionner la nationalité</option>
                                            @foreach ($nationality as $item)
                                            <option value="{{$item['id']}}" {{ old('nationalite') == $item['id'] ? 'selected':null }} {{$data ? ($data->nationalitie_id == $item['id'] ?'selected':null):null}}>{{ucfirst($item['libelle'])}}</option>
                                            @endforeach
                                        </select><br>
                                        @error('nationalite')
                                            <span class="form-bar text-danger" role="alert">
                                                {{$message}}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="col-form-label" for="residence">Lieu de résidence<span class="text-danger">*</span> :</label>
                                        <input type="text" name="residence" id="residence" class="form-control @error('residence') is-invalid @enderror" value="{{old('residence', $data ? $data->place_residence:null)}}" placeholder="Entrez le lieu de résidence">
                                        @error('residence')
                                            <span class="form-bar text-danger" role="alert">
                                                {{$message}}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="col-form-label" for="photo">La photo de l'élève :</label>
                                        <input type="file" name="photo" id="photo" class="form-control">
                                        @error('photo')
                                            <span class="form-bar text-danger" role="alert">
                                                {{$message}}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-0 text-left">
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="NomPere">Nom du père biologique<span class="text-danger">*</span> :</label>
                                        <input type="text" name="NomPere" id="NomPere" class="form-control @error('NomPere') is-invalid @enderror" value="{{old('NomPere', $data ? $data->first_name_father:($parent ? ($parent['sexe'] == 'H' ? $parent['first_name'] :null):null))}}" placeholder="Entrez le nom du père biologie de l'élève">
                                        @error('NomPere')
                                            <span class="form-bar text-danger" role="alert">
                                                {{$message}}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="prenomPere">Prénoms du père biologique<span class="text-danger">*</span> :</label>
                                        <input type="text" name="prenomPere" id="prenomPere" class="form-control @error('prenomPere') is-invalid @enderror" value="{{old('prenomPere', $data ? $data->last_name_father:($parent ? ($parent['sexe'] == 'H' ? $parent['last_name'] :null):null))}}" placeholder="Entrez le prénoms du père biologie de l'élève">
                                        @error('prenomPere')
                                            <span class="form-bar text-danger" role="alert">
                                                {{$message}}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="profPere">Profession du père biologique<span class="text-danger">*</span> :</label>
                                        <input type="text" name="profPere" id="profPere" class="form-control @error('profPere') is-invalid @enderror" value="{{old('profPere', $data ? $data->profession_father:($parent ? ($parent['sexe'] == 'H' ? $parent['profession'] :null):null))}}" placeholder="Entrez la profession du père biologie de l'élève">
                                        @error('profPere')
                                            <span class="form-bar text-danger" role="alert">
                                                {{$message}}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="NomMere">Nom de la mère biologique<span class="text-danger">*</span> :</label>
                                        <input type="text" name="NomMere" id="NomMere" class="form-control @error('NomMere') is-invalid @enderror" value="{{old('NomMere', $data ? $data->first_name_mother:($parent ? ($parent['sexe'] == 'F' ? $parent['first_name'] :null):null))}}" placeholder="Entrez le nom de la mère biologie de l'élève">
                                        @error('NomMere')
                                            <span class="form-bar text-danger" role="alert">
                                                {{$message}}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="prenomMere">Prénoms de la mère biologique<span class="text-danger">*</span> :</label>
                                        <input type="text" name="prenomMere" id="prenomMere" class="form-control @error('prenomMere') is-invalid @enderror" value="{{old('prenomMere', $data ? $data->last_name_mother:($parent ? ($parent['sexe'] == 'F' ? $parent['last_name'] :null):null))}}" placeholder="Entrez le prénoms de la mère biologie de l'élève">
                                        @error('prenomMere')
                                            <span class="form-bar text-danger" role="alert">
                                                {{$message}}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4 mb-2">
                                    <div class="form-group">
                                        <label class="col-form-label" for="profMere">Profession de la mère biologique<span class="text-danger">*</span> :</label>
                                        <input type="text" name="profMere" id="profMere" class="form-control @error('profMere') is-invalid @enderror" value="{{old('profMere', $data ? $data->profession_mother:($parent ? ($parent['sexe'] == 'F' ? $parent['profession'] :null):null))}}" placeholder="Entrez la profession de la mère biologie de l'élève">
                                        @error('profMere')
                                            <span class="form-bar text-danger" role="alert">
                                                {{$message}}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row text-left" id="detaiStudent" style="display: none">
                                <hr class="my-3 mx-3 w-100 text-center">
                                <div class="col-12">
                                    <p style="font-size:18px; font-weight: bold; text-decoration: underline;">Année scolaire {{$year->school_year}}</p>
                                </div>
                                <div class="col-12 col-md-4 mb-3" id="divAffecte">
                                    <label>Affectué(e) :</label><br>
                                    <span class="mr-2">
                                        <input type="radio" name="affecte" id="AffOui" value="oui">
                                        <label for="oui">Oui</label>
                                    </span>
                                    <span class="mr-2">
                                        <input type="radio" name="affecte" id="AffNon" value="non">
                                        <label for="non">Non</label>
                                    </span>
                                </div>
                                <div class="col-12 col-md-4 mb-3">
                                    <label>Redoublant(e) :</label><br>
                                    <span class="mr-2">
                                        <input type="radio" name="redoublant" id="RedoubOui" value="oui">
                                        <label for="oui">Oui</label>
                                    </span>
                                    <span class="mr-2">
                                        <input type="radio" name="redoublant" id="RedoubNon" value="non" checked>
                                        <label for="non">Non</label>
                                    </span>
                                </div>
                                <div class="col-12 col-md-4 mb-3" id="divBoursier">
                                    <label>Boursier(e) :</label><br>
                                    <span class="mr-2">
                                        <input type="radio" name="boursier" id="BoursOui" value="oui">
                                        <label for="oui">Oui</label>
                                    </span>
                                    <span class="mr-2">
                                        <input type="radio" name="boursier" id="BoursNon" value="non">
                                        <label for="non">Non</label>
                                    </span>
                                </div> 
                                <div class="col-12 col-md-4 mb-3">
                                    <div class="form-group mb-3">
                                        <label for="level" class="form-label">Niveau<span class="text-danger">*</span> :</label><br>
                                        <select name="level" id="level" class="form-control select2 bg-white">
                                            <option value="">Selection one option</option>
                                        </select>                                       
                                    </div>
                                </div>
                                <div class="col-12 col-md-4 mb-3" id="divSerie" style="display: none">
                                    <div class="form-group mb-3">
                                        <label for="serie" class="form-label"><span id="bockSerie"></span><span class="text-danger">*</span> :</label><br>
                                        <select name="serie" id="serie" class="form-control select2 bg-white">
                                            <option value="">Selection one option</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-12 col-md-4" id="divLv2" style="display: none">
                                    <label>LV2 (Langue Vivante 2) :</label><br>
                                    <span class="mx-2" title="Allemand">
                                        <input type="radio" class="lv2" name="lv2" value="allemand" id="lv2All">
                                        <label for="lv2All">All</label>
                                    </span>
                                    <span class="mx-2" title="Espagnol">
                                        <input type="radio" class="lv2" name="lv2" value="espagnol" id="lv2Esp">
                                        <label for="lv2Esp">Esp</label>
                                    </span>
                                </div>
                                <div class="col-12 col-md-4 mb-3" id="divClasse">
                                    <div class="form-group mb-3">
                                        <label for="classe" class="form-label">Classe<span class="text-danger">*</span> :</label><br>
                                        <select name="classe my-0" id="classe" class="form-control select bg-white">
                                            {{-- <option value="">Selection one option</option> --}}
                                        </select><br>
                                        <span class="getClass text-danger my-0" id="indispoClass" style="display: none"> Classe non disponible !</option>
                                    </div>
                                </div>
                            </div>

                            <div style="display: {{$data ? 'block':'none'}}">
                                <span class="mx-3" title="{{$data ? ($data->status ? 'Actif':'Inactif'):null}}">
                                    <input type="checkbox" name="status" id="status" value="1" {{ $data ? ($data->status ? 'checked':null):null}}>
                                    <label for="status" class="mx-1 form-control-variant">Status</label>
                                </span>
                            </div>
                            <div class="text-center">
                                <button type="submit" class="btn btn-inverse btn-outline-inverse py-2"><i class="fas fa-check-circle"></i> Valider les informations</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/fr.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<script src="{{asset('assets/js/pcoded.min.js')}}"></script>
<script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
<script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
<script>
    $(document).ready(function(){
        // Verifie si le matricule existent déjà
        $('#matricule').on('change', function(){
            let val = $(this).val();
            if(val){
                $.ajax({
                    url: '{{ route('student.search') }}',
                    method: 'GET',
                    data: {
                        data: val
                    },
                    success: function(response){
                        if(response == 200){
                            $('#getExist').slideDown();
                        }
                        else{
                            $('#getExist').slideUp();
                        }
                    
                    },
                });
            }
        });

        $type = $('input[name="type"]:checked').val();
        if($type){
            getViewEndType($type);
        }

        // value get type enseignement
        $('.type').on('change', function(){
            getViewEndType($(this).val());
        });


        // value get level
        $('#level').on('change', function(){
            $('.valSerie').remove();$('#indispoClass').slideUp();
            $('.valClasse').remove();
            let val = $(this).val().split('_');
            if((val[0] > 13) && (val[0] != 17)){
                $('#divSerie').slideDown();$('select[name="serie"]').removeAttr('disabled');
                $('#divLv2').slideUp();$('#lv2All').prop("checked", false);
                $("#libSerie").remove();
                $("input[name='type']:checked").prop("value") != 'superieur' ? $('#bockSerie').append('<span id="libSerie">Serie</span>'):$('#bockSerie').append('<span id="libSerie">Niveau</span>');
                $.ajax({
                    url: '{{ route('inscription.serie') }}',
                    method: 'GET',
                    data: {
                        libelle: val[1],
                        level: $("input[name='type']:checked").prop("value")
                    },
                    success: function(data){
                        $i = 0;
                        while($i < data.length){
                            $('#serie').append('<option value="'+data[$i].id+'_'+data[$i].serie+'" class="valSerie">'+data[$i].serie+'</option>');
                            $i++;
                        }
                    }
                });
            }
            else if((val[0] > 11) &&( val[0] != 17)){
                $('#divSerie').slideUp();$('select[name="serie"]').attr('disabled', 'disabled');
                $('#divLv2').slideDown();$('#lv2All').prop("checked", true);
                if($("input[name='lv2']:checked").prop("value")){
                    $('.valClasse').remove();
                    getClasseLv2(val[0], $("input[name='lv2']:checked").prop("value"));
                }
            }
            else if((val[0] < 12) || (val[0] == 17)){
                $('#divSerie').slideUp();$('select[name="serie"]').attr('disabled', 'disabled');
                $('#divLv2').slideUp();$('#lv2All').prop("checked", false);
                getClasseNonSerie(val[0]);
            }
        });


        $('#serie').on('change', function() {
            $val = $(this).val().split('_');
            let lvl = $('#level').val().split('_');
            if($val[1] == "A" || $val[1] == "A1" || $val[1] == "A2" || (($val[1] == "C") && (lvl[0] == 14))){
                $('#divLv2').slideDown();$('#lv2All').prop("checked", true);
                $('.valClasse').remove();
                getClasseLv2Serie(lvl[0], $("input[name='lv2']:checked").prop("value"),$val[0]);
            }
            else{
                $('#divLv2').slideUp();$('#lv2All').prop("checked", false);
                getClasseLv2Serie(lvl[0],null,$val[0]);
            }
        });
        
        
        $('.lv2').on('change', function() {
            if($("input[name='lv2']:checked").prop("value")){
                let val = $('#level').val().split('_');
                $('.valClasse').remove();
                getClasseLv2(val[0], $("input[name='lv2']:checked").prop("value"));
            }
        });


        // Initialiser le date picker sur le champ avec l'ID 'datepicker'
        flatpickr("#dateNais", {
            locale: "fr",  // Utilise le français pour l'affichage
            dateFormat: "d-m-Y", // Format de la date
            altInput: true, // Afficher un format alternatif de la date
            altFormat: "d-m-Y", // Format alternatif pour afficher la date
        });

        // add select2
        $('.select2').select2();



        function getViewEndType($vals){
            $('#detaiStudent').slideDown(); $('#indispoClass').slideUp();
            $('.valSerie').remove();
            $('.valClasse').remove();
            if($.inArray($vals, ['Prescolaire', 'Primaire', 'Prescolaire - Primaire'])){
                $('#divAffecte,#divBoursier,#divSerie').slideUp();
                $("#AffOui").prop("checked", false);
                $('#BoursNon').prop("checked", false);
                $('#divLv2').slideUp();$('#lv2All').prop("checked", false);
                $('select[name="serie"]').attr('disabled', 'disabled');
            }
            else{
                $('#divAffecte,#divBoursier').slideDown();
                $("#AffOui").prop("checked", true);
                $('#BoursNon').prop("checked", true);
                $('#divLv2').slideUp();$('#lv2All').prop("checked", false);
                $('select[name="serie"]').attr('disabled', 'disabled');
            }

            // Recuperation des nivaux selon le type d'enseignement choisit
            $.ajax({
                url: '{{ route('inscription.level') }}',
                method: 'GET',
                data: {
                    libelle: $vals
                },
                success: function(data){
                    $('.valLevel').remove();
                    $i = 0;
                    while($i < data.length){
                        $('#level').append('<option value="'+data[$i].id+'_'+data[$i].code+'" class="valLevel">'+data[$i].code+'</option>');
                        $i++;
                    }
                }
            });
        }


        function getClasseNonSerie($id){
            $.ajax({
                url: '{{ route('inscription.classe') }}',
                method: 'GET',
                data: {
                    id: $id,
                    lv2: null,
                    serie: null
                },
                success: function(data){
                    $('.valClasse').remove();
                    if(data.length){
                        $('#indispoClass').slideUp();
                        $i = 0;
                        while($i < data.length){
                            $('#classe').append('<option value="'+data[$i].id+'" class="valClasse">'+data[$i].libelle+'</option>');
                            $i++;
                        }
                    }
                    else{
                       // $('#indispoClass').slideDown()
                        $('#classe').append('<option class="valClasse">Classe non disponible !</option>');
                    }
                    
                }
            });
        }


        function getClasseLv2($id, $lv2){
            $.ajax({
                url: '{{ route('inscription.classe') }}',
                method: 'GET',
                data: {
                    id: $id,
                    lv2: $lv2,
                    serie: null
                },
                success: function(data){
                    $('.valClasse').remove();
                    if(data.length){
                        $('#indispoClass').slideUp();
                        $i = 0;
                        while($i < data.length){
                            $('#classe').append('<option value="'+data[$i].id+'" class="valClasse">'+data[$i].libelle+'</option>');
                            $i++;
                        }
                    }
                    else{
                        //$('#indispoClass').slideDown()
                        $('#classe').append('<option class="valClasse">Classe non disponible !</option>');
                    }
                    
                }
            });
        }


        function getClasseLv2Serie($id, $lv2 = null, $serie = null){
            $.ajax({
                url: '{{ route('inscription.classe') }}',
                method: 'GET',
                data: {
                    id: $id,
                    lv2: $lv2 ?? null,
                    serie: $serie ?? null
                },
                success: function(data){
                    $('.valClasse').remove();
                    if(data.length){
                        $('#indispoClass').slideUp();
                        $i = 0;
                        while($i < data.length){
                            $('#classe').append('<option value="'+data[$i].id+'" class="valClasse">'+data[$i].libelle+'</option>');
                            $i++;
                        }
                    }
                    else{
                       // $('#indispoClass').slideDown()
                        $('#classe').append('<option class="valClasse">Classe non disponible !</option>');
                    }
                    
                }
            });
        }
    })
</script>
@endsection