@extends('app')
@section('title', 'material')
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12"> 
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between">
                                    <h4>Gestion Activité Parascolaire</h4>
                                    <span>
                                        <a href="{{route('report1.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span> 
                                </div>
                            </div>
                            <hr class="mx-3 mt-0">
                            <div class="card-block">
                                <div class="row">
                                    <div class="col-md-12">
                                        <form action="{{ route('report1.store') }}" method="post">
                                            @csrf
                                            <input type="hidden" name="val" value="3">
                                            <div class="form-group">
                                                <table class="table table-bordered my-2">
                                                    <head>
                                                        <tr>
                                                            <th class="text-center" style="width: 30%"></th>
                                                            <th class="text-center" style="width: 35%">Existence</th>
                                                            <th class="text-center" style="width: 35%">Fonctionnel</th>
                                                        </tr>
                                                    </head>
                                                    <body>
                                                        <tr>
                                                            <th class="text-left">Infirmerie</th>
                                                            <td class="text-center">
                                                                <span class="mr3-">
                                                                    <input type="radio" name="col1[1]" id="infExist1" class="infExist" value="1" checked>
                                                                    <label for="infExist1">Oui</label>
                                                                </span>
                                                                <span class="ml-3">
                                                                    <input type="radio" name="col1[1]" id="infExist2" class="infExist" value="0">
                                                                    <label for="infExist2">Non</label>
                                                                </span>
                                                            </td>
                                                            <td class="text-center">
                                                                <span class="mr3-">
                                                                    <input type="radio" name="col2[1]" id="fontion1" value="1" checked>
                                                                    <label for="fontion1">Oui</label>
                                                                </span>
                                                                <span class="ml-3">
                                                                    <input type="radio" name="col2[1]" id="fontion2" value="0">
                                                                    <label for="fontion2">Non</label>
                                                                </span>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <th class="text-left">Bibliothèque</th>
                                                            <td class="text-center">
                                                                <span class="mr3-">
                                                                    <input type="radio" name="col1[2]" class="boblExist" id="boblExist1" value="1" checked>
                                                                    <label for="boblExist1">Oui</label>
                                                                </span>
                                                                <span class="ml-3">
                                                                    <input type="radio" name="col1[2]" class="boblExist" id="boblExist2" value="0">
                                                                    <label for="boblExist2">Non</label>
                                                                </span>
                                                            </td>
                                                            <td class="text-center">
                                                                <span class="mr3-">
                                                                    <input type="radio" name="col2[2]" id="bobFont1" value="1" checked>
                                                                    <label for="bobFont1">Oui</label>
                                                                </span>
                                                                <span class="ml-3">
                                                                    <input type="radio" name="col2[2]" id="bobFont2" value="0">
                                                                    <label for="bobFont2">Non</label>
                                                                </span>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <th class="text-left">Foyer</th>
                                                            <td class="text-center">
                                                                <span class="mr3-">
                                                                    <input type="radio" name="col1[3]" id="forExist1" class="forExist" value="1" checked>
                                                                    <label for="forExist1">Oui</label>
                                                                </span>
                                                                <span class="ml-3">
                                                                    <input type="radio" name="col1[3]" id="forExist2" class="forExist" value="0">
                                                                    <label for="forExist2">Non</label>
                                                                </span>
                                                            </td>
                                                            <td class="text-center">
                                                                <span class="mr3-">
                                                                    <input type="radio" name="col2[3]" id="forFont1" value="1" checked>
                                                                    <label for="forFont1">Oui</label>
                                                                </span>
                                                                <span class="ml-3">
                                                                    <input type="radio" name="col2[3]" id="forFont2" value="0">
                                                                    <label for="forFont2">Non</label>
                                                                </span>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <th class="text-left">Coopérative</th>
                                                            <td class="text-center">
                                                                <span class="mr3-">
                                                                    <input type="radio" name="col1[4]" id="coopExist1" class="coopExist" value="1" checked>
                                                                    <label for="coopExist1">Oui</label>
                                                                </span>
                                                                <span class="ml-3">
                                                                    <input type="radio" name="col1[4]" id="coopExist2" class="coopExist" value="0">
                                                                    <label for="coopExist2">Non</label>
                                                                </span>
                                                            </td>
                                                            <td class="text-center">
                                                                <span class="mr3-">
                                                                    <input type="radio" name="col2[4]" id="coopFont1" value="1" checked>
                                                                    <label for="coopFont1">Oui</label>
                                                                </span>
                                                                <span class="ml-3">
                                                                    <input type="radio" name="col2[4]" id="coopFont2" value="0">
                                                                    <label for="coopFont2">Non</label>
                                                                </span>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <th class="text-left">Théâtre</th>
                                                            <td class="text-center">
                                                                <span class="mr3-">
                                                                    <input type="radio" name="col1[5]" id="theExist1" class="theExist" value="1" checked>
                                                                    <label for="theExist1">Oui</label>
                                                                </span>
                                                                <span class="ml-3">
                                                                    <input type="radio" name="col1[5]" id="theExist2" class="theExist" value="0">
                                                                    <label for="theExist2">Non</label>
                                                                </span>
                                                            </td>
                                                            <td class="text-center">
                                                                <span class="mr3-">
                                                                    <input type="radio" name="col2[5]" id="theFont1" value="1" checked>
                                                                    <label for="theFont1">Oui</label>
                                                                </span>
                                                                <span class="ml-3">
                                                                    <input type="radio" name="col2[5]" id="theFont2" value="0">
                                                                    <label for="theFont2">Non</label>
                                                                </span>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <th class="text-left">Club (Santé, VIH-SIDA, Culture, Cuisine, etc... )</th>
                                                            <td class="text-center">
                                                                <span class="mr3-">
                                                                    <input type="radio" name="col1[6]" id="cubExist1" class="cubExist" value="1" checked>
                                                                    <label for="cubExist1">Oui</label>
                                                                </span>
                                                                <span class="ml-3">
                                                                    <input type="radio" name="col1[6]" id="cubExist2" class="cubExist" value="0">
                                                                    <label for="cubExist2">Non</label>
                                                                </span>
                                                            </td>
                                                            <td class="text-center">
                                                                <span class="mr3-">
                                                                    <input type="radio" name="col2[6]" id="cubFont1" value="1" checked>
                                                                    <label for="cubFont1">Oui</label>
                                                                </span>
                                                                <span class="ml-3">
                                                                    <input type="radio" name="col2[6]" id="cubFont2" value="0">
                                                                    <label for="cubFont2">Non</label>
                                                                </span>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <th class="text-left">Musique/Art Plastique</th>
                                                            <td class="text-center">
                                                                <span class="mr3-">
                                                                    <input type="radio" name="col1[7]" id="musExist1" class="musExist" value="1" checked>
                                                                    <label for="musExist1">Oui</label>
                                                                </span>
                                                                <span class="ml-3">
                                                                    <input type="radio" name="col1[7]" id="musExist2" class="musExist" value="0">
                                                                    <label for="musExist2">Non</label>
                                                                </span>
                                                            </td>
                                                            <td class="text-center">
                                                                <span class="mr3-">
                                                                    <input type="radio" name="col2[7]" id="musFont1" value="1" checked>
                                                                    <label for="musFont1">Oui</label>
                                                                </span>
                                                                <span class="ml-3">
                                                                    <input type="radio" name="col2[7]" id="musFont2" value="0">
                                                                    <label for="musFont2">Non</label>
                                                                </span>
                                                            </td>
                                                        </tr>
                                                    </body>
                                                </table>
                                            </div>
                                            <hr class="text-center mt-lg-5">
                                            <div class="text-center py-3">
                                                <button type="submit" class="btn btn-inverse btn-outline-inverse py-1"> <i class="fas fa-check-circle"></i> Valider les informations</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
    
    <script src="{{ asset('assets/js/pcoded.min.js') }}"></script>
    <script src="{{ asset('assets/js/vartical-layout.min.js') }}"></script>
    <script src="{{ asset('assets/js/jquery.mCustomScrollbar.concat.min.js') }}"></script>
    <script>
        $(document).ready(function() {

            // Infirmerie
            $('.infExist').on('click', function() {
               verify($(this).val(), 'fontion1', 'fontion2')
            });

            //  Bibliothèque
            $('.boblExist').on('click', function() {
                verify($(this).val(), 'bobFont1', 'bobFont2')
            });

            // Foyer
            $('.forExist').on('click', function() {
                verify($(this).val(), 'forFont1', 'forFont2')
            });

            // Coopérative
            $('.coopExist').on('click', function() {
                verify($(this).val(), 'coopFont1', 'coopFont2')
            });

            // Théâtre
            $('.theExist').on('click', function() {
                verify($(this).val(), 'theFont1', 'theFont2')
            });

            // Club
            $('.cubExist').on('click', function() {
                verify($(this).val(), 'cubFont1', 'cubFont2')
            });

            // Musique/Art Plastique
            $('.musExist').on('click', function() {
                verify($(this).val(), 'musFont1', 'musFont2')
            });


            // -----------------------------------------
            function verify($val, $checked1, $checked2){
               if($val == 1){
                    $('#'+$checked1).prop('checked', true);
                }
                else{
                    $('#'+$checked2).prop('checked', true);
                } 
            }
        });
    </script>
@endsection