@extends('app')
@section('title', 'Evaluation par matière')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4>Détail des moyennes</h4>
                                    <span class="form-control-variant" style="font-size: 15px">
                                        <strong class="mr-2">{{$classe['libelle']}}</strong>[{{$enseignant ? ($enseignant->user->sexe == "F" ? 'Mde. ':'Mr. ').strtoupper($enseignant->user->first_name).' '.ucwords($enseignant->user->last_name):'Non défini'}}]
                                    </span>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" id="btnEdit" title="Edit moyen..." data-toggle="modal" data-target="#editModal"><i class="fab fa-cloudsmith mx-0"></i></button>
                                        <a href="#" id="unclassified" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="unclassified"><i class="fab fa-sith mx-0"></i></a>
                                        <a href="#" id="download" target="_blank" class="btn btn-inverse btn-outline-inverse btn-sm py-1" title="Download pdf"><i class="fas fa-download mx-0"></i> </a>
                                        <a href="{{route('moyenne.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        @foreach ($datas as $item)
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left {{$item['actif'] == 1 ? 'active':''}}" data-lib="{{$item['libelle']}}" id="{{$item['actif'] == 1 ? 'active':'inactif'}}" data-actif="{{$item['actif']}}" data-id="{{$item['id']}}" data-toggle="tab" href="#home{{$item['id']}}" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i>{{ucfirst($item['libelle'])}}
                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        @endforeach
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        @foreach ($datas as $item)
                                        <div class="tab-pane {{$item['actif'] == 1 ? 'active':''}}" id="home{{$item['id']}}" role="tabpanel">
                                            <table id="{{$item['tab']}}" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="width: 3%">N°</th>
                                                        <th class="text-center">Nom & Prénoms</th>
                                                        <th class="text-center">Sexe</th>
                                                        <th class="text-center">Matricule</th>
                                                        @foreach ($matters as $matter)
                                                        <th class="text-center" title="{{$matter['libelle']}}">{{$matter['abbreviated'] ?? $matter['libelle']}}</th>
                                                        @endforeach
                                                        <th class="text-center" title="Moyenne">Moy</th>
                                                        <th class="text-center">Rang</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @php $i = 1; @endphp
                                                    @foreach ($item['data'] as $data)
                                                    <tr>
                                                        <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                        <td class="text-left" title="{{$data['name']}}">{{Str::limit($data['name'], 17, '...')}}</td>
                                                        <td class="text-center">{{$data['sexe']}}</td>
                                                        <td class="text-center">{{$data['matricule']}}</td>
                                                        @foreach ($data['moyens'] as $moyen)
                                                        <td class="text-center">{{$moyen ? $moyen['moyenne']:'nc'}}</td>
                                                        @endforeach
                                                        <th class="text-center">{{$data['moyen']}}</th>
                                                        <td class="text-center">{{$data['rang']}}</td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        @endforeach
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Modal Delete Evaluation-->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <form action="{{route('moyenne.edit')}}" method="post">
            @csrf
            @method('get')
            <div class="modal-header bg-dark py-2">
                <h5 class="modal-title" id="editModalLongTitle">Select one matter</h5>
                <span style="font-style: 17px" id="editTitle"></span>
            </div>
            <div class="modal-body py-3">
                <label for="matter">Select matter<span class="text-danger">*</span> :</label>
                <select name="matter" id="matter" class="form-control"required>
                    <option value="">Select one option</option>
                </select>
                <input type="hidden" name="cutting" value="" id="idCutting">
                <input type="hidden" name="classe" value="{{$classe['id']}}" id="idClasse">
            </div>
            <div class="modal-footer mt-2">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){

            var url = window.location.href;
            const myArray = url.split("detail");

            $('#idCutting').val($("#active").data('id'));
            let vals = $('#idClasse').val()+'_'+$("#active").data('id');
            $('#download').attr('href', myArray[0]+'file/'+vals);
            $('#unclassified').attr('href', myArray[0]+'unclassified/'+vals);
            
            $('.nav-link').on('click', function(){
                $('#idCutting').val($(this).data('id'));
                let vals = $('#idClasse').val()+'_'+$(this).data('id');
                $('#download').attr('href', myArray[0]+'file/'+vals);
                $('#unclassified').attr('href', myArray[0]+'unclassified/'+vals);
            });


            $('#btnEdit').on('click', function() {
                $idClass = $('#idClasse').val(); $idCtting = $('#idCutting').val();
                $('.matters').remove();
                if($idClass && $idCtting){
                    $.ajax({
                        url: '{{ route('moyenne.matter') }}',
                        method: 'GET',
                        data: {
                            idClasse: $idClass,
                            idCutting: $idCtting
                        },
                        success: function(data){
                            $('#editTitle').text(data['cutting']);
                            console.log(data);
                            $i = 0;
                            while ($i < data['matters'].length) {
                                $mats = data['matters'][$i].abbreviated ?  (data['matters'][$i].abbreviated).toUpperCase():data['matters'][$i].libelle;
                                $('#matter').append('<option class="matters" value="'+data['matters'][$i].id+'" title="'+data['matters'][$i].libelle+'">'+$mats+'</option>');
                                $i++;
                            }
                        }
                    });
                }
            });
        })
    </script>
@endsection