<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('series', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('serie')->unique();
            $table->enum('2nd',[0,1])->default(0);
            $table->enum('1ere',[0,1])->default(0);
            $table->enum('tle',[0,1])->default(0);
            $table->enum('type', ['secondaire', 'technique', 'superieur']);
            $table->enum('status',[0,1])->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('series');
    }
};
