<?php

namespace App\Listeners;

use App\Events\BilanMatiereEvent;
use App\Models\MoyenneAnnuelleBilan;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class BilanMatiereListener
{
    public function handle(BilanMatiereEvent $event): void
    {
        $resut = MoyenneAnnuelleBilan::where('inscription_id', $event->student)->where('libelle_bilan_id', $event->bilan)->where('school_year_id', $event->year)->first();
        if($resut){
            $val = explode(' ', $event->libelle);
            $resut->update([
                'coeffs' => $event->coeff,
                'rang_trim' => $event->rang,
                'bilan_'.$val[1] => $event->moyenne
            ]);
        }
        else{
           MoyenneAnnuelleBilan::create([
                'bilan_1' => $event->moyenne,
                'school_year_id' => $event->year,
                'inscription_id' => $event->student,
                'school_id' => $event->school,
                'libelle_bilan_id' => $event->bilan
           ]); 
        }
    }
}
