<?php

namespace App\Jobs;

use App\Models\ResultatClasse;
use App\Jobs\ClassementClasseJob;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;

class CalculResultatClasseJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $class;
    protected $school;
    protected $decoupage;
    // protected $yearActif;
    /**
     * Create a new job instance.
     */
    public function __construct($class, $school, $decoupage)
    {
        $this->class = $class;
        $this->school = $school;
        $this->decoupage = $decoupage;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $table = $this->moyenneVerify();
        $result = ResultatClasse::where('classe_id', $this->class)->where('cutting_school_year_id', $this->decoupage)->first();
        if($result){
            $result->update([
                'moyenne' => $this->sommeMoyenne(),
                'nbre_non_classe' => $this->nbreNonClasse(),
                'nbre_superieur' => $table[0],
                'nbre_entre' => $table[1],
                'nbre_inferieur' => $table[2],
                'moyenne_moins_classe' => $this->moyennePlusBas(),
                'moyenne_elevee_classe' => $this->moyennePlusEleve()
            ]);
        }
        else{
            ResultatClasse::create([
                'classe_id' => $this->class,
                'school_id' => $this->school,
                'moyenne' => $this->sommeMoyenne(),
                'nbre_non_classe' => $this->nbreNonClasse(),
                'nbre_superieur' => $table[0],
                'nbre_entre' => $table[1],
                'nbre_inferieur' => $table[2],
                'moyenne_moins_classe' => $this->moyennePlusBas(),
                'moyenne_elevee_classe' => $this->moyennePlusEleve(),
                'cutting_school_year_id' => $this->decoupage
            ]);
        }

        // attendre 10 secondes
        ClassementClasseJob::dispatch($this->class, $this->decoupage)->delay(now()->addSeconds(1));

    }


    private function sommeMoyenne()
    {
        $somme = DB::table('moyenne_trimestrielles')
        ->join('inscriptions', 'inscriptions.id', '=', 'moyenne_trimestrielles.inscription_id')
        ->where('inscriptions.classe_id', '=', $this->class)
        ->where('moyenne_trimestrielles.cutting_school_year_id', '=', $this->decoupage)
        ->where('moyenne_trimestrielles.moyenne', '!=', 'nc')->sum('moyenne');
        $result = ($somme / $this->nbreStudentClasse());
        return round($result, 2);
    }


    private function nbreStudentClasse()
    {
        $nbre = DB::table('moyenne_trimestrielles')
        ->join('inscriptions', 'inscriptions.id', '=', 'moyenne_trimestrielles.inscription_id')
        ->where('inscriptions.classe_id', '=', $this->class)
        ->where('moyenne_trimestrielles.cutting_school_year_id', '=', $this->decoupage)
        ->where('moyenne_trimestrielles.moyenne', '!=', 'nc')->count();
        return $nbre;
    }


    private function nbreNonClasse()
    {
        $nbre = DB::table('moyenne_trimestrielles')
        ->join('inscriptions', 'inscriptions.id', '=', 'moyenne_trimestrielles.inscription_id')
        ->where('inscriptions.classe_id', '=', $this->class)
        ->where('moyenne_trimestrielles.cutting_school_year_id', '=', $this->decoupage)
        ->where('moyenne_trimestrielles.moyenne', '=', 'nc')->count();
        return $nbre;
    }


    private function moyenneVerify()
    {
        $data = $this->moyenneGet();
        $superior = 0; $between = 0; $lower = 0;
        foreach($data as $item){
            if($item['moyenne'] >= 10){
                $superior++;
            }
            elseif($item['moyenne'] < 8.5){
                $lower++;
            }
            else{
                $between++; 
            }
        }
        return [$superior, $between, $lower];
    }


    // Réccuperation de la moyenne la plus basse de la classe
    private function moyennePlusBas()
    {
        $val = min($this->moyenneGet());
        return $val ? $val['moyenne']:null;
    }


    // Réccuperation de la moyenne la plus élévée de la classe
    private function moyennePlusEleve()
    {
        $val = max($this->moyenneGet());
        return $val ? $val['moyenne']:null;
    }

    private function moyenneGet()
    {
        $data = DB::table('moyenne_trimestrielles')
        ->join('inscriptions', 'inscriptions.id', '=', 'moyenne_trimestrielles.inscription_id')
        ->select('moyenne_trimestrielles.moyenne')
        ->where('inscriptions.classe_id', '=', $this->class)
        ->where('moyenne_trimestrielles.cutting_school_year_id', '=', $this->decoupage)
        ->where('moyenne_trimestrielles.moyenne', '!=', 'nc')->get();
        return json_decode($data, true);
    }
}
