<?php

namespace App\Http\Controllers;

use App\Models\SchoolYear;
use Carbon\Carbon;
use Illuminate\Http\Request;

class SchoolYearController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        try{
            $datas = SchoolYear::orderBy('school_year', 'DESC')->get();
            return view('pages.school_year.index',['datas' => $datas]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        try{
            $data = [];
            $decoupage = ['trimestre', 'semestre'];
            return view('pages.school_year.create',[
                'data' => $data, 
                'decoupage' => $decoupage
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'schoolYear' => 'required|string|unique:school_years,school_year',
            'decoupage' => 'required|string',
        ]);

        if(!(explode('-',$validated['schoolYear'])[1] >= Carbon::now()->format('Y'))){
            return redirect()->route('school_year.index')->with([
                'str' => 'danger',
                'msg' => 'Informations erronées !'
            ]);
        }

        // Verifier qu'il n'y a pas d'année scolaire activée
        SchoolYear::where('status', '1')->update(['status' => '0']);

        SchoolYear::create([
            'school_year' => $validated['schoolYear'],
            'decoupage' => $validated['decoupage']
        ]);

        return redirect()->route('school_year.index')->with([
            'str' => 'success',
            'msg' => 'Enregistrement effectué !'
        ]);
    }


    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        try{
            $data = SchoolYear::find($id);
            $decoupage = ['trimestre', 'semestre'];
            return view('pages.school_year.create',[
                'data' => $data, 
                'decoupage' => $decoupage
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'schoolYear' => 'required|string',
            'decoupage' => 'required|string',
            'status' => 'nullable|string',
        ]);
        
        // Verifier qu'il n'y a pas d'année scolaire activée
        if($request['status']){
            SchoolYear::where('status', '1')->update(['status' => '0']);
        }

        $data = SchoolYear::find($id);
        $data->update([
            'school_year' => $validated['schoolYear'],
            'decoupage' => $validated['decoupage'],
            'status' => $request['status'] ? '1':'0',
        ]);

        return redirect()->route('school_year.index')->with([
            'str' => 'info',
            'msg' => 'Mis à jour effectué !'
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        try{
            $data = SchoolYear::find($id);
            if($data){
                $data->delete(); 
            }
            return redirect()->route('school_year.index')->with([
                'str' => 'info',
                'msg' => 'Suppression effectuée !'
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }
}
