<?php

namespace App\Http\Controllers;

use App\Models\Classe;
use App\Models\Setting;
use App\Models\Material;
use App\Models\SchoolYear;
use App\Models\StatutStudent;
use App\Models\UniversAutre;
use App\Models\UniversSocial;
use App\Models\UniversLangue;
use App\Models\UniversScience;
use App\Models\Recapitulatif;
use App\Models\OriginStudent;
use App\Models\ResultatExamen;
use App\Models\DoubleVacation;
use App\Models\Extracurricular;
use App\Models\PyramideStudent;
use App\Models\PersonnelSchool;
use App\Models\PersonnelDouble;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use PDF;

class SchoolReportController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        try{
            $year = $this->yearActif();
            return view('pages.rapport.index',[
               'personnel' => PersonnelSchool::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->first(),
               'discipline' => UniversLangue::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->first(),
               'materiel' => Material::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->first(),
               'activity' => Extracurricular::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->first(),
               'student' => OriginStudent::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->first(),
               'vacation' => DoubleVacation::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->first(),
               'examen' => ResultatExamen::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->first()
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }


    public function getPdf(){
        try{
            $setting = Setting::where('school_id', auth()->user()->school_id)->first();
            $year = $this->yearActif();
            $pdf = PDF::loadView('pdf.rapport1', [
                'school' => $setting,
                'year' => $year,
                'socials' => UniversSocial::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->orderBy('order')->get(),
                'langues' => UniversLangue::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->orderBy('order')->get(),
                'sciences' => UniversScience::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->orderBy('order')->get(),
                'autres' => UniversAutre::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->orderBy('order')->get(),
                'totals' => Recapitulatif::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->orderBy('order')->get(),
                'extrats' => Extracurricular::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->orderBy('order')->get(),
                'materiels' => Material::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->orderBy('order')->get(),
                'vacation' => DoubleVacation::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->first(),
                'nbreCndts' => ResultatExamen::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->select('ivoirien_g', 'ivoirien_f', 'etranger_g', 'etranger_f')->orderBy('order')->get(),
                'adminCndts' => ResultatExamen::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->select('ivoirien_g_ad', 'ivoirien_f_ad', 'etranger_g_ad', 'etranger_f_ad')->orderBy('order')->get(),
                'admins' => ResultatExamen::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->select('ivoirien_g_pr', 'ivoirien_f_pr', 'ivoirien_t_pr', 'etranger_g_pr', 'etranger_f_pr', 'etranger_t_pr')->orderBy('order')->get(),
                'students' => OriginStudent::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->select('col_g_1', 'col_f_2', 'col_g_3', 'col_f_4', 'col_g_5', 'col_f_6')->orderBy('order')->get(),
                'bilans' => OriginStudent::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->select('col_g_7', 'col_f_8')->orderBy('order')->get(),
                'statuts' => $this->getStatutStudent(),
                'nbreClsCl1' => $this->getClasses($year['id']), // Total Classe Cycle 1
                'nbreClsCl2' => $this->getClasses2nde($year['id']), // Total Classe Cycle é
                'pyramideNonRoubant1' => $this->pyramideNonRoubant1(),
                'pyramideRoubant1' => $this->pyramideRoubant1(),
                'NonRoubant2' => $this->pyramideNonRoubant2($year['id']),
                'Roubant2' => $this->pyramideRoubant2($year['id']),
                'totalNonRoubant2' => $this->totalNonDoublant2($year['id'], 'non'),
                'totalRoubant2' => $this->totalNonDoublant2($year['id'], 'oui'),
                'personnel' => PersonnelSchool::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->first(),
                'educateur' => PersonnelDouble::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->where('order', '1')->get(),
                'entretien' => PersonnelDouble::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->where('order', '2')->get(),
                'securites' => PersonnelDouble::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->where('order', '3')->get(),
                'autres' => PersonnelDouble::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->where('order', '4')->get(),
            ]);
            $pdf->setPaper('A4', 'portrait'); // ou 'A4', 'A3', etc.
            return $pdf->stream('ropport_de_rentree_'.$year['school_year'].'.pdf');
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        try{
            $val = $request->validate(['select' => 'required|string']);
            return match(true) {
                ($val['select'] == 1) => view('pages.rapport.personnel'),
                ($val['select'] == 2) => view('pages.rapport.material'),
                ($val['select'] == 3) => view('pages.rapport.activity'),
                ($val['select'] == 4) => view('pages.rapport.examen'),
                ($val['select'] == 5) => view('pages.rapport.student'),
                ($val['select'] == 6) => view('pages.rapport.vacation'),
                ($val['select'] == 7) => view('pages.rapport.discipline'),
                default => back()->with([
                    'str' => 'danger',
                    'msg' => 'Une erreur est survenue !'
                ])
            };
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try{
            return match(true) {
                ($request['val'] == 1) => $this->getPersonnel($request),
                ($request['val'] == 2) => $this->getMaterial($request),
                ($request['val'] == 3) => $this->getActivity($request),
                ($request['val'] == 4) => $this->getExamen($request),
                ($request['val'] == 5) => $this->getStudent($request),
                ($request['val'] == 6) => $this->getVocation($request),
                ($request['val'] == 7) => $this->getDiscipline($request),
                default => back()->with([
                    'str' => 'danger',
                    'msg' => 'Une erreur est survenue !'
                ])
            };
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    private function getPersonnel($dts){
        $year = $this->yearActif();
        PersonnelSchool::where('school_year_id', $year['id'])->where('school_id', auth()->user()->school_id)->delete();

        // Save data
        PersonnelSchool::create([
            'name_directeur' => $dts['NameDirecteur'],
            'phon_directeur' => $dts['NumDirecteur'],
            'name_adjoint' => $dts['NameAdjoint'],
            'phon_adjoint' => $dts['NumAdjoint'],
            'name_secretaire' => $dts['NameSecreteire'],
            'phon_secretaire' => $dts['NumSecreteire'],
            'name_fichier' => $dts['NameFichier'],
            'phon_fichier' => $dts['NumFichier'],
            'name_comptable' => $dts['NameComptable'],
            'phon_comptable' => $dts['NumComptable'],
            'homologation_1' => $dts['created'],
            'homologation_2' => $dts['opening'],
            'school_id' => auth()->user()->school_id,
            'school_year_id' => $year['id']
        ]);

        $this->personnel($dts['NameEduca'], $dts['NumEduca'], 1, $year['id']);
        $this->personnel($dts['NameEntretien'], $dts['NumEntretien'], 2, $year['id']);
        $this->personnel($dts['NameSecurit'], $dts['NumSecurit'], 3, $year['id']);
        $this->personnel($dts['nameAutre'], $dts['numAutre'], 4, $year['id'], $dts['fontAutre']);

        return to_route('report1.index')->with([
            'str' => 'success',
            'msg' => 'Enregistrement effectué'
        ]);
    }

    private function personnel($name, $phon, $order, $year, $autre = null){
        PersonnelDouble::where('school_year_id', $year)->where('school_id', auth()->user()->school_id)->where('order', $order)->delete();
        $i = 0;
        while($i < count($name)){
            PersonnelDouble::create([
                'name' => $name[$i],
                'phon' => $phon[$i],
                'autres' => $autre ? strtolower($autre[$i]):null,
                'order' => $order,
                'school_id' => auth()->user()->school_id,
                'school_year_id' => $year
            ]);
            $i++;
        }
    }


    private function getMaterial($dts){
        $val = $dts->validate([
            'col1' => 'required|array',
            'col2' => 'required|array',
            'col3' => 'required|array',
            'col4' => 'required|array',
            'col5' => 'required|array',
            'col1.*' => 'required|string',
            'col2.*' => 'required|string',
            'col3.*' => 'required|string',
            'col4.*' => 'required|string',
            'col5.*' => 'required|string',
        ]);
        $year = $this->yearActif();
        Material::where('school_year_id', $year['id'])->where('school_id', auth()->user()->school_id)->delete();
        $i = 1;
        while($i <= 2){
            Material::create([
                'col1' => $val['col1'][$i],
                'col2' => $val['col2'][$i],
                'col3' => $val['col3'][$i],
                'col4' => $val['col4'][$i],
                'col5' => $val['col5'][$i],
                'order' => $i,
                'school_id' => auth()->user()->school_id,
                'school_year_id' => $year['id'],
            ]);
            $i++;
        }
        return to_route('report1.index')->with([
            'str' => 'success',
            'msg' => 'Enregistrement effectué'
        ]);
    }


    private function getActivity($dts){
        $val = $dts->validate([
            'col1' => 'required|array',
            'col2' => 'required|array',
            'col1.*' => 'required|string',
            'col2.*' => 'required|string',
        ]);
        $year = $this->yearActif();
        Extracurricular::where('school_year_id', $year['id'])->where('school_id', auth()->user()->school_id)->delete();
        $i = 1;
        while($i <= sizeof($val['col1'])){
            Extracurricular::create([
                'exists' => $val['col1'][$i],
                'functional' => $val['col2'][$i],
                'order' => $i,
                'school_id' => auth()->user()->school_id,
                'school_year_id' => $year['id'],
            ]);
            $i++;
        }
        return to_route('report1.index')->with([
            'str' => 'success',
            'msg' => 'Enregistrement effectué'
        ]);
    }



    private function getExamen($dts){
        $val = $dts->validate([
            'col1' => 'required|array',
            'col2' => 'required|array',
            'col3' => 'required|array',
            'col4' => 'required|array',
            'col5' => 'required|array',
            'col6' => 'required|array',
            'col7' => 'required|array',
            'col8' => 'required|array',
        ]);
       $year = $this->yearActif();
       ResultatExamen::where('school_year_id', $year['id'])->where('school_id', auth()->user()->school_id)->delete();
       $i = 1;
        while($i <= 6){
            ResultatExamen::create([
                'ivoirien_g' => $val['col1'][$i],
                'ivoirien_f' => $val['col2'][$i],
                'etranger_g' => $val['col3'][$i],
                'etranger_f' => $val['col4'][$i],
                'ivoirien_g_ad' => $val['col5'][$i],
                'ivoirien_f_ad' => $val['col6'][$i],
                'etranger_g_ad' => $val['col7'][$i],
                'etranger_f_ad' => $val['col8'][$i],
                'ivoirien_g_pr' => $this->calculPrge($val['col1'][$i], 0, $val['col5'][$i], 0),
                'ivoirien_f_pr' => $this->calculPrge(0, $val['col2'][$i], 0, $val['col6'][$i]),
                'ivoirien_t_pr' => $this->calculPrge($val['col1'][$i],$val['col2'][$i], $val['col5'][$i], $val['col6'][$i]),
                'etranger_g_pr' => $this->calculPrge($val['col3'][$i], 0, $val['col7'][$i], 0),
                'etranger_f_pr' => $this->calculPrge(0, $val['col4'][$i], 0, $val['col8'][$i]),
                'etranger_t_pr' => $this->calculPrge($val['col3'][$i],$val['col4'][$i], $val['col7'][$i], $val['col8'][$i]),
                'order' => $i,
                'school_id' => auth()->user()->school_id,
                'school_year_id' => $year['id'],
            ]);
            $i++;
        }
        return to_route('report1.index')->with([
            'str' => 'success',
            'msg' => 'Enregistrement effectué'
        ]);
    }



    private function getStudent($dts){
        $val = $dts->validate([
            'col1' => 'required|array',
            'col2' => 'required|array',
            'col3' => 'required|array',
            'col4' => 'required|array',
            'col5' => 'required|array',
            'col6' => 'required|array'
        ]);
        $year = $this->yearActif();
        OriginStudent::where('school_year_id', $year['id'])->where('school_id', auth()->user()->school_id)->delete();
        $i = 1;
        while($i <= 10){
            OriginStudent::create([
                'col_g_1' => (int)$val['col1'][$i] ?? '0',
                'col_f_2' => (int)$val['col2'][$i] ?? '0',
                'col_g_3' => (int)$val['col3'][$i] ?? '0',
                'col_f_4' => (int)$val['col4'][$i] ?? '0',
                'col_g_5' => (int)$val['col5'][$i] ?? '0',
                'col_f_6' => (int)$val['col6'][$i] ?? '0',
                'col_g_7' => $this->calculTotal([$val['col1'][$i], $val['col3'][$i], $val['col5'][$i]]),
                'col_f_8' => $this->calculTotal([$val['col2'][$i], $val['col4'][$i], $val['col6'][$i]]),
                'order' => $i,
                'school_id' => auth()->user()->school_id,
                'school_year_id' => $year['id'],
            ]);
            $i++;
        }
        return to_route('report1.index')->with([
            'str' => 'success',
            'msg' => 'Enregistrement effectué'
        ]);
    }


    private function getVocation($dts){
        $year = $this->yearActif();
        DoubleVacation::where('school_year_id', $year['id'])->where('school_id', auth()->user()->school_id)->delete();
        DoubleVacation::create([
            'col_1' => (int)$dts['col1'] ?? '0',
            'col_2' => (int)$dts['col2'] ?? '0',
            'col_3' => (int)$dts['col3'] ?? '0',
            'col_4' => (int)$dts['col4'] ?? '0',
            'col_5' => (int)$dts['col5'] ?? '0',
            'col_6' => (int)$dts['col6'] ?? '0',
            'col_7' => (int)$dts['col7'] ?? '0',
            'col_8' => (int)$dts['col8'] ?? '0',
            'col_9' => (int)$dts['col9'] ?? '0',
            'col_10' => (int)$dts['col10'] ?? '0',
            'col_11' => (int)$dts['col11'] ?? '0',
            'col_12' => (int)$dts['col12'] ?? '0',
            'school_id' => auth()->user()->school_id,
            'school_year_id' => $year['id'],
        ]);
        return to_route('report1.index')->with([
            'str' => 'success',
            'msg' => 'Enregistrement effectué'
        ]);
    }



    private function getDiscipline($dts){
        $val = $dts->validate([
            'col1_u' => 'required|array',
            'col2_u' => 'required|array',
            'col3_u' => 'required|array',
            'col4_u' => 'required|array',
            'col1_l' => 'required|array',
            'col2_l' => 'required|array',
            'col3_l' => 'required|array',
            'col4_l' => 'required|array',
            'col1_s' => 'required|array',
            'col2_s' => 'required|array',
            'col3_s' => 'required|array',
            'col4_s' => 'required|array',
            'col1_a' => 'required|array',
            'col2_a' => 'required|array',
            'col3_a' => 'required|array',
            'col4_a' => 'required|array',
        ]);
        $year = $this->yearActif();
        UniversSocial::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->delete();
        UniversLangue::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->delete();
        UniversScience::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->delete();
        UniversAutre::where('school_id', auth()->user()->school_id)->where('school_year_id', $year['id'])->delete();
        $i = 1;
        while($i <= 4){
            // Enregistrement de la table Univers Social
            UniversSocial::create([
                'col_1_h' => (int)$val['col'.$i.'_u'][1],
                'col_2_f' => (int)$val['col'.$i.'_u'][2],
                'col_3_h' => (int)$val['col'.$i.'_u'][3],
                'col_4_f' => (int)$val['col'.$i.'_u'][4],
                'col_5_h' => (int)$val['col'.$i.'_u'][5],
                'col_6_f' => (int)$val['col'.$i.'_u'][6],
                'total_h' => $this->calculTotal([$val['col'.$i.'_u'][1], $val['col'.$i.'_u'][3], $val['col'.$i.'_u'][5]]),
                'total_F' => $this->calculTotal([$val['col'.$i.'_u'][2], $val['col'.$i.'_u'][4], $val['col'.$i.'_u'][6]]),
                'order' => $i,
                'school_id' => auth()->user()->school_id,
                'school_year_id' => $year['id'],
            ]);

            // Enregistrement da la table Langue
            UniversLangue::create([
                'col_1_h' => (int)$val['col'.$i.'_l'][1],
                'col_2_f' => (int)$val['col'.$i.'_l'][2],
                'col_3_h' => (int)$val['col'.$i.'_l'][3],
                'col_4_f' => (int)$val['col'.$i.'_l'][4],
                'col_5_h' => (int)$val['col'.$i.'_l'][5],
                'col_6_f' => (int)$val['col'.$i.'_l'][6],
                'col_7_h' => (int)$val['col'.$i.'_l'][7],
                'col_8_f' => (int)$val['col'.$i.'_l'][8],
                'total_h' => $this->calculTotal([$val['col'.$i.'_l'][1], $val['col'.$i.'_l'][3], $val['col'.$i.'_l'][5], $val['col'.$i.'_l'][7]]),
                'total_f' => $this->calculTotal([$val['col'.$i.'_l'][2], $val['col'.$i.'_l'][4], $val['col'.$i.'_l'][6], $val['col'.$i.'_l'][8]]),
                'order' => $i,
                'school_id' => auth()->user()->school_id,
                'school_year_id' => $year['id'],
            ]);

            // Enregistremeent de la table ScienceTechnologie
            UniversScience::create([
                'col_1_h' => (int)$val['col'.$i.'_s'][1],
                'col_2_f' => (int)$val['col'.$i.'_s'][2],
                'col_3_h' => (int)$val['col'.$i.'_s'][3],
                'col_4_f' => (int)$val['col'.$i.'_s'][4],
                'col_5_h' => (int)$val['col'.$i.'_s'][5],
                'col_6_f' => (int)$val['col'.$i.'_s'][6],
                'col_7_h' => (int)$val['col'.$i.'_s'][7],
                'col_8_f' => (int)$val['col'.$i.'_s'][8],
                'total_h' => $this->calculTotal([$val['col'.$i.'_s'][1], $val['col'.$i.'_s'][3], $val['col'.$i.'_s'][5], $val['col'.$i.'_s'][7]]),
                'total_f' => $this->calculTotal([$val['col'.$i.'_s'][2], $val['col'.$i.'_s'][4], $val['col'.$i.'_s'][6], $val['col'.$i.'_s'][8]]),
                'order' => $i,
                'school_id' => auth()->user()->school_id,
                'school_year_id' => $year['id'],
            ]);

            // Enregistrement de la table AutreDiscipline
            UniversAutre::create([
                'col_1_h' => (int)$val['col'.$i.'_a'][1],
                'col_2_f' => (int)$val['col'.$i.'_a'][2],
                'col_3_h' => (int)$val['col'.$i.'_a'][3],
                'col_4_f' => (int)$val['col'.$i.'_a'][4],
                'col_5_h' => (int)$val['col'.$i.'_a'][5],
                'col_6_f' => (int)$val['col'.$i.'_a'][6],
                'col_7_h' => (int)$val['col'.$i.'_a'][7],
                'col_8_f' => (int)$val['col'.$i.'_a'][8],
                'total_h' => $this->calculTotal([$val['col'.$i.'_a'][1], $val['col'.$i.'_a'][3], $val['col'.$i.'_a'][5], $val['col'.$i.'_a'][7]]),
                'total_f' => $this->calculTotal([$val['col'.$i.'_a'][2], $val['col'.$i.'_a'][4], $val['col'.$i.'_a'][6], $val['col'.$i.'_a'][8]]),
                'order' => $i,
                'school_id' => auth()->user()->school_id,
                'school_year_id' => $year['id'],
            ]);

            $i++;
        }
        $this->saveTotalDisciple($year['id'], auth()->user()->school_id);
        return to_route('report1.index')->with([
            'str' => 'success',
            'msg' => 'Enregistrement effectué'
        ]);
    }



    private function calculPrge($nbreG = 0, $nbreF = 0, $admiG = 0, $admiF = 0)
    {
        $vals = 0;
        if($nbreG || $admiG || $nbreF || $admiF){
            $vals = ($admiG+$admiF) ? (($admiG+$admiF)*100)/($nbreG+$nbreF):0;
        }
        $vals = $vals ? ($vals == 100 ? $vals:number_format($vals, 2, '.', ' ')):0;
        return ($vals < 10 ? '0'.$vals:$vals).'%';
    }


    private function calculTotal($tables = [])
    {
        $total = 0;
        foreach($tables as $item){
            $total += $item;
        }
        return ($total < 10 ? '0'.$total:$total);
    }


    private function saveTotalDisciple($year, $user){

        $val1 = UniversSocial::where('school_id', $user)->where('school_year_id', $year)->get();
        $val2 = UniversLangue::where('school_id', $user)->where('school_year_id', $year)->get();
        $val3 = UniversScience::where('school_id', $user)->where('school_year_id', $year)->get();
        $val4 = UniversAutre::where('school_id', $user)->where('school_year_id', $year)->get();
        Recapitulatif::where('school_id', $user)->where('school_year_id', $year)->delete();
        $i = 0;
        while($i < 4){
            Recapitulatif::create([
                'total_1_h' => $val1[$i]['total_h'],
                'total_2_f' => $val1[$i]['total_f'],
                'total_3_h' => $val2[$i]['total_h'],
                'total_4_f' => $val2[$i]['total_f'],
                'total_5_h' => $val3[$i]['total_h'],
                'total_6_f' => $val3[$i]['total_f'],
                'total_7_h' => $val4[$i]['total_h'],
                'total_8_f' => $val4[$i]['total_f'],
                'total_h' => $this->calculTotal([$val1[$i]['total_h'], $val2[$i]['total_h'], $val3[$i]['total_h'], $val4[$i]['total_h']]),
                'total_f' => $this->calculTotal([$val1[$i]['total_f'], $val2[$i]['total_f'], $val3[$i]['total_f'], $val4[$i]['total_f']]),
                'order' => $i+1,
                'school_id' => $user,
                'school_year_id' => $year,
            ]);
            $i++;
        }
    }


    private function getStatutStudent(){
        $year = $this->yearActif(); // Les Id des niveau consernés -------------
        return  ([
            $this->getStatut(10, $year['id']),
            $this->getStatut(11, $year['id']),
            $this->getStatut(12, $year['id']),
            $this->getStatut(13, $year['id']),
            $this->getTotalStatutCycle([10, 11, 12, 13], $year['id']),
            $this->getStatut(14, $year['id']),
            $this->getStatut(15, $year['id']),
            $this->getStatut(16, $year['id']),
            $this->getTotalStatutCycle([14, 15, 16], $year['id']),
            $this->getStatutTotal($year['id'])
        ]);
    }



    private function getStatut($id, $year){
        $val = StatutStudent::where('level_id', $id)->where('school_id', auth()->user()->school_id)->where('school_year_id', $year)->first();
        return [
            $val['nbre_affect_garcon'] ?? 0, $val['nbre_affect_fille'] ?? 0, 
            $val['nbre_non_affect_garcon'] ?? 0, $val['nbre_non_affect_fille'] ?? 0
        ];
    }


    private function getTotalStatutCycle($tabe = [], $year){
        $affecte_g = 0; $affecte_f = 0; $non_affecte_g = 0; $non_affecte_f = 0;
        foreach($tabe as $id){
            $val = StatutStudent::where('level_id', $id)->where('school_id', auth()->user()->school_id)->where('school_year_id', $year)->first();
            $affecte_g += $val['nbre_affect_garcon'] ?? 0;
            $affecte_f += $val['nbre_affect_fille'] ?? 0;
            $non_affecte_g += $val['nbre_non_affect_garcon'] ?? 0;
            $non_affecte_f += $val['nbre_non_affect_fille'] ?? 0;
        }
        return [$affecte_g, $affecte_f, $non_affecte_g, $non_affecte_f];
    }


    private function getStatutTotal($year){
        $cycle1 = $this->getTotalStatutCycle([10, 11, 12, 13], $year);
        $cycle2 = $this->getTotalStatutCycle([14, 15, 16], $year);
        return [($cycle1[0]+$cycle2[0]), ($cycle1[1]+$cycle2[1]), ($cycle1[2]+$cycle2[2]), ($cycle1[3]+$cycle2[3])];
    }


    private function pyramideRoubant1(){
        $year = $this->yearActif();
        $tab = [10, 11, 12, 13];
        return ([
            $this->getNonReoublant($tab[0], $year['id'], 'oui'),
            $this->getNonReoublant($tab[1], $year['id'], 'oui'),
            $this->getNonReoublant($tab[2], $year['id'], 'oui'),
            $this->getNonReoublant($tab[3], $year['id'], 'oui'),
            $this->totalNonDoublant1($year['id'], 'oui')
        ]);
    }


    private function pyramideNonRoubant1(){
        $year = $this->yearActif();
        $tab = [10, 11, 12, 13];
        return ([
            $this->getNonReoublant($tab[0], $year['id'], 'non'),
            $this->getNonReoublant($tab[1], $year['id'], 'non'),
            $this->getNonReoublant($tab[2], $year['id'], 'non'),
            $this->getNonReoublant($tab[3], $year['id'], 'non'),
            $this->totalNonDoublant1($year['id'], 'non')
        ]);
    }


    private function getNonReoublant($id, $year, $lib){
        $val = PyramideStudent::where('level_id', $id)->where('school_id', auth()->user()->school_id)->where('school_year_id', $year)->first();
        if($lib == 'oui'){
            $dts = [$val['nbre_redoublant_garcon'] ?? 0, $val['nbre_redoublant_fille'] ?? 0,  ($val['nbre_redoublant_garcon'] ?? 0) + ($val['nbre_redoublant_fille'] ?? 0)];
        }
        else{
            $dts = [$val['nbre_non_redoublant_garcon'] ?? 0, $val['nbre_non_redoublant_fille'] ?? 0,  ($val['nbre_non_redoublant_garcon'] ?? 0) + ($val['nbre_non_redoublant_fille'] ?? 0)];
        }
        return $dts;
    }


    private function getClasses($year){
        $tabe = [10, 11, 12, 13];
        $dts = [];
        foreach($tabe as $id){
            $val = Classe::where('level_id', $id)->where('school_id', auth()->user()->school_id)->where('school_year_id', $year)->count();
            $dts[] = $val ?? 0;
        }
        return $dts;
    }


    private function totalNonDoublant1($year, $lib){
        if($lib == 'oui'){
            $val_g = PyramideStudent::whereBetween('level_id', [10, 13])->where('school_id', auth()->user()->school_id)->where('school_year_id', $year)->sum('nbre_redoublant_garcon');
            $val_f = PyramideStudent::whereBetween('level_id', [10, 13])->where('school_id', auth()->user()->school_id)->where('school_year_id', $year)->sum('nbre_redoublant_fille');
        }
        else{
            $val_g = PyramideStudent::whereBetween('level_id', [10, 13])->where('school_id', auth()->user()->school_id)->where('school_year_id', $year)->sum('nbre_non_redoublant_garcon');
            $val_f = PyramideStudent::whereBetween('level_id', [10, 13])->where('school_id', auth()->user()->school_id)->where('school_year_id', $year)->sum('nbre_non_redoublant_fille');
        }
        return ([$val_g, $val_f, ($val_g+$val_f)]);
    }


    private function getClasses2nde($year){
        $level = [14, 15, 16];
        $dts = []; $total = 0;
        foreach($level as $id){
            if($id == 14){
                $serie = [1, 4];
                foreach($serie as $seri){
                    $val = Classe::where('level_id', $id)->where('school_id', auth()->user()->school_id)->where('school_year_id', $year)->where('serie_id', $seri)->count();
                    $dts[] = $val ?? 0; $total += $val ?? 0;
                }
            }
            else{
                $serie = [1, 4, 5]; // 2, 3 Correspond a la serie A1 et A2 qui correspond à la serie A en generale
                foreach($serie as $seri){
                    $val = $seri != 1 ? Classe::where('level_id', $id)->where('school_id', auth()->user()->school_id)->where('school_year_id', $year)->where('serie_id', $seri)->count():
                    Classe::where('level_id', $id)->where('school_id', auth()->user()->school_id)->where('school_year_id', $year)->whereBetween('serie_id', [1, 2, 3])->count();
                    $dts[] = $val ?? 0; $total += $val ?? 0;
                }
            }
            
        }
        // Totale Classe Cycle 2
        $dts[] = $total;
        return $dts;
    }


    private function pyramideNonRoubant2($year){
        $level = [14, 15, 16]; $serie = [1, 4, 5];
        return ([
            $this->getNonReoublant2($level[0], $serie[0], $year, 'non'),
            $this->getNonReoublant2($level[0], $serie[1], $year, 'non'),
            $this->getNonReoublant2($level[1], $serie[0], $year, 'non'),
            $this->getNonReoublant2($level[1], $serie[1], $year, 'non'),
            $this->getNonReoublant2($level[1], $serie[2], $year, 'non'),
            $this->getNonReoublant2($level[2], $serie[0], $year, 'non'),
            $this->getNonReoublant2($level[2], $serie[1], $year, 'non'),
            $this->getNonReoublant2($level[2], $serie[2], $year, 'non'),
        ]);
    }


    private function pyramideRoubant2($year){
        $level = [14, 15, 16]; $serie = [1, 4, 5];
        return ([
            $this->getNonReoublant2($level[0], $serie[0], $year, 'oui'),
            $this->getNonReoublant2($level[0], $serie[1], $year, 'oui'),
            $this->getNonReoublant2($level[1], $serie[0], $year, 'oui'),
            $this->getNonReoublant2($level[1], $serie[1], $year, 'oui'),
            $this->getNonReoublant2($level[1], $serie[2], $year, 'oui'),
            $this->getNonReoublant2($level[2], $serie[0], $year, 'oui'),
            $this->getNonReoublant2($level[2], $serie[1], $year, 'oui'),
            $this->getNonReoublant2($level[2], $serie[2], $year, 'oui'),
        ]);
    }



    private function getNonReoublant2($id, $serie, $year, $lib){
        $val = PyramideStudent::where('level_id', $id)->where('school_id', auth()->user()->school_id)->where('school_year_id', $year)->where('serie_id', $serie)->first();
        if($lib == 'oui'){
            $dts = [$val['nbre_redoublant_garcon'] ?? 0, $val['nbre_redoublant_fille'] ?? 0,  ($val['nbre_redoublant_garcon'] ?? 0) + ($val['nbre_redoublant_fille'] ?? 0)];
        }
        else{
            $dts = [$val['nbre_non_redoublant_garcon'] ?? 0, $val['nbre_non_redoublant_fille'] ?? 0,  ($val['nbre_non_redoublant_garcon'] ?? 0) + ($val['nbre_non_redoublant_fille'] ?? 0)];
        }
        return $dts;
    }


    private function totalNonDoublant2($year, $lib){
        if($lib == 'oui'){
            $val_g = PyramideStudent::whereBetween('level_id', [14, 15, 16])->where('school_id', auth()->user()->school_id)->where('school_year_id', $year)->sum('nbre_redoublant_garcon');
            $val_f = PyramideStudent::whereBetween('level_id', [14, 15, 16])->where('school_id', auth()->user()->school_id)->where('school_year_id', $year)->sum('nbre_redoublant_fille');
        }
        else{
            $val_g = PyramideStudent::whereBetween('level_id', [14, 15, 16])->where('school_id', auth()->user()->school_id)->where('school_year_id', $year)->sum('nbre_non_redoublant_garcon');
            $val_f = PyramideStudent::whereBetween('level_id', [14, 15, 16])->where('school_id', auth()->user()->school_id)->where('school_year_id', $year)->sum('nbre_non_redoublant_fille');
        }
        return ([$val_g, $val_f, ($val_g+$val_f)]);
    }

    /**
     * Remove the specified resource from storage.
     */
    private function yearActif(){
        $year = SchoolYear::where('status', '1')->first();
        return $year;
    }

}