<?php

namespace App\Http\Controllers;
use App\Models\Setting;
use App\Models\SchoolYear;
use App\Models\Classe;
use App\Models\LevelMatter;
use App\Models\CuttingSchoolYear;
use App\Models\EvaluationType;
use App\Models\MoyenneSubMatter;
use App\Models\Evaluation;
use App\Models\SubMatter;
use App\Models\GetNote;
use App\Models\MoyenneMatiere;
use App\Models\Inscription;
use App\Models\ClasseEnseignant;
use App\Models\ApprovedMoyenne;
use App\Models\EvaluatedLevel;
use App\Exports\ListClassStudentNoteExport;
use App\Imports\ListClassStudentNoteImport;
use App\Jobs\CalculMoyenneMatiereJob;
use App\Jobs\BonnusMoyenneMatiereJob;
use App\Jobs\ApprovedMoyenneJob;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use PDF;

class EvaluationController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        try{
            $data = Setting::where('school_id',auth()->user()->school_id)->first();
            return view('pages.evaluations.index',[
                'data' => $this->typeEnseignement($data),
                'compos' => $this->getComposition(),
                'date' => $this->yearActif()['school_year']
            ]);                 
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Get generate pdf form for creating a new resource.
     */
    public function generatePdf($getId)
    {
        try{
            $id = explode('_', $getId); $sub = 0;
            $class = Classe::where('id', $id[0])->first();
            $setting = Setting::where('school_id', $class['school_id'])->first();
            $matter = LevelMatter::where('id', $id[2])->first();
            $nbres = Evaluation::where('classe_id', $id[0])->where('cutting_school_year_id', $id[1])->where('level_matter_id', $id[2])->where('status', '1')->count();
            $verify = array_key_exists($matter['matter']['id'], [8 => "Espagnol", 9 => "Allemad"]);
            if(in_array($class['level_id'], [10,11,12,13]) && $matter['matter_id'] == 2){
                $sub = 1;
            }
            $pdf = PDF::loadView('pdf.'.($sub ? 'list_note_french':'list_note'), [
                'datas' => $this->studentNoteList($getId, $sub ?? null, $verify ? $matter['matter']['libelle']:null),
                'decoup' => CuttingSchoolYear::where('id', $id[1])->first(),
                'matter' => $matter,
                'school' => $setting,
                'class' => $class,
                'nbres' => $nbres
            ]);
            // return $pdf->download('list_note_'.$class['libelle'].'.pdf');
            return $pdf->stream('list_note_'.$class['libelle'].'.pdf');
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Get list notes student the form for creating a new resource.
     */
    public function noteObtenues($identifiant){
        try{
            $id = explode('_', $identifiant); $sub = 0;
            $matter = LevelMatter::where('id', $id[2])->first();
            $class = Classe::where('id', $id[0])->first();
            $nbre = Evaluation::where('classe_id', $id[0])->where('cutting_school_year_id', $id[1])->where('level_matter_id', $id[2])->where('status', '1')->count();
            $verify = array_key_exists($matter['matter']['id'], [8 => "Espagnol", 9 => "Allemad"]);
            if(in_array($class['level_id'], [10,11,12,13]) && $matter['matter_id'] == 2){
                $sub = 1;
            }
            return view('pages.evaluations.'.($sub ? 'list_note_french':'list_note'), [
                'datas' => $this->studentNoteList($identifiant, $sub ?? null, $verify ? $matter['matter']['libelle']:null),
                'decoup' => CuttingSchoolYear::where('id', $id[1])->first(),
                'class' => $class,
                'matter' => $matter,
                'eval' => $nbre,
                'approved' => $this->approvedMoyenneMatter($id[0], $id[2], $id[1]),
                'string' => $identifiant
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    public function bonnus($string)
    {
        try{
            $id = explode('_', $string); $sub = 0;
            $nbre = Evaluation::where('classe_id', $id[0])->where('cutting_school_year_id', $id[1])->where('level_matter_id', $id[2])->where('status', '1')->count();
            if($nbre){
                $matter = LevelMatter::where('id', $id[2])->first();
                $class = Classe::where('id', $id[0])->first();
                $verify = array_key_exists($matter['matter']['id'], [8 => "Espagnol", 9 => "Allemad"]);
                if(in_array($class['level_id'], [10,11,12,13]) && $matter['matter_id'] == 2){
                    $sub = 1;
                }
                return view('pages.evaluations.bonnus',[
                    'datas' => $this->studentNoteList($string, $sub ?? null, $verify ? $matter['matter']['libelle']:null),
                    'decoup' => CuttingSchoolYear::where('id', $id[1])->first(),
                    'class' => $class,
                    'matter' => $matter,
                    'eval' => $nbre,
                    'string' => $string
                ]);
            }
            else{
                return back()->with([
                    'str' => 'danger',
                    'msg' => 'Une erreur est survenue.'
                ]);
            }
            
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }


    public function bonnusUpdate(Request $request, $string)
    {
        try{
            $val = explode('_', $string);
            $tab = [];
            $student = $request['student'];
            $moyens = $request['moyen'];
            $i = 0;
            while($i < sizeof($student)){
                $tab[] = [
                    'id' => explode('_', $student[$i])[0],
                    'sexe' => explode('_', $student[$i])[1],
                    'moyen' => $moyens[$i] ? ($moyens[$i] == 'nc' ? 'nc':number_format(($moyens[$i]), 2, '.', ' ')):'nc'
                ];
                $i++;
            }
            dispatch(new BonnusMoyenneMatiereJob($tab, $val[2], $val[1], auth()->user()->school->id));
            return to_route('evaluation.list',$string)->with([
                'str' => 'info',
                'msg' => 'Bonnus Pris en compris dans quelque temps !'
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    public function approved($string)
    {
        try{
            $val = explode('_', $string);
            $data = MoyenneMatiere::join('inscriptions', 'moyenne_matieres.inscription_id', '=', 'inscriptions.id')
            ->select('moyenne_matieres.moyenne', 'moyenne_matieres.rang', 'inscriptions.id')
            ->where('moyenne_matieres.cutting_school_year_id', $val[1])
            ->where('moyenne_matieres.level_matter_id', $val[2])
            ->where('inscriptions.classe_id', $val[0])->get();
            if($data){
                dispatch(new ApprovedMoyenneJob(json_decode($data, true), $this->getStudentClasse($val[0]), $val[0], $val[2], $this->bilanMatter($val[2]), $val[1], auth()->user()->school_id));
                $aproved = ApprovedMoyenne::where('classe_id', $val[0])->where('level_matter_id', $val[2])->where('cutting_school_year_id', $val[1])->where('approved', '1')->first();
                if(!$aproved){
                    ApprovedMoyenne::create([
                        'classe_id' => $val[0],
                        'level_matter_id' => $val[2],
                        'cutting_school_year_id' => $val[1],
                        'approved' => '1',
                    ]);
                }
                return to_route('evaluation.list',$string)->with([
                    'str' => 'info',
                    'msg' => 'Moyennes partagées avec success.'
                ]);
            }
            else{
                return to_route('evaluation.list',$string)->with([
                    'str' => 'danger',
                    'msg' => 'Une erreur est survenue.'
                ]);
            }
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        } 
    }

    /**
     * Export file the form for creating a new resource.
     */
    public function exportFile($val)
    {
        try{
            $id = explode('_', $val);
            $eval = Evaluation::where('id', $id)->first();
            $name = 'Add_note_'.$eval->classe->libelle.'_'.($eval->levelMatter->matter->abbreviated ?? $eval->levelMatter->matter->libelle).'_'.$eval->date_create;
            return Excel::download(new ListClassStudentNoteExport($id[1], $id[0]), $name.'.xlsx');
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Import file a newly created resource in storage.
     */
    public function importFile(Request $request, $val)
    {
        try{
            $request->validate(['files' => 'required|mimes:xlsx']);
            $id = explode('_', $val);
            Excel::import(new ListClassStudentNoteImport($id[1], $id[0]), $request->file('files'));

            // ----------------------------------------------
            $tudents = Inscription::where('classe_id', $id[1])->get('id');
            $eval = Evaluation::where('id', $id[0])->first();
            foreach($tudents as $item){
                $tab[] = $item['id'];
            }
            dispatch(new CalculMoyenneMatiereJob($tab, $eval['classe_id'], $eval['cutting_school_year_id'], $eval['level_matter_id'], $eval['sub_matter_id']));
            return to_route('evaluation.show',$id[0])->with([
                'str' => 'warning',
                'msg' => 'Notes ajoutées.'
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create($id)
    {
        try{
            $eval = Evaluation::where('id', $id)->first();
            $matiere = LevelMatter::find($eval->level_matter_id)['matter'];
            $verify = array_key_exists($matiere['id'], [8 => "Espagnol", 9 => "Allemad"]);
            return view('pages.evaluations.create',[
                'evaluation' => $eval,
                'students' => $verify ? $this->getLv2StudentClasse($eval->classe_id,$matiere['libelle']):$this->getStudentClasse($eval->classe_id),
                'catching' => 0
            ]);               
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function storeNote(Request $request, $idEval)
    {
        try{
            $val = $request->validate([
                'evalId' => 'required|integer',
                'student' => 'required|array|min:1', 
                'note' => 'required|array|min:1', 
            ]);
            for($i = 0; $i < sizeof($val['student']); $i++){
                GetNote::create([
                    'note' => (!isset($val['note'][$i])) ? 'nc':$val['note'][$i],
                    'inscription_id' => $val['student'][$i],
                    'evaluation_id' => $val['evalId']
                ]);
            }

            // -- Créer un job pour les calcul des moyennes -- //
            $eval = Evaluation::where('id', $val['evalId'])->first();
            dispatch(new CalculMoyenneMatiereJob($val['student'], $eval['classe_id'], $eval['cutting_school_year_id'], $eval['level_matter_id'], $eval['sub_matter_id']));
            return to_route('evaluation.show',$idEval)->with([
                'str' => 'success',
                'msg' => 'Notes ajoutées pour cette évaluation.'
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try{
            $val = $request->validate([
                'idMatter' => 'required|integer',
                'idClass' => 'required|integer',
                'idCutting' => 'required|integer',
                'select' => 'required|string',
                'submatter' => 'nullable|integer',
                'notee' => 'required|string',
                'date' => 'required|string',
            ]);

            $save = Evaluation::create([
                'notee' => $val['notee'],
                'date_create' => $val['date'],
                'sub_matter_id' => $val['submatter'] ?? null,
                'level_matter_id' => $val['idMatter'],
                'classe_id' => $val['idClass'],
                'evaluation_type_id' => $val['select'],
                'cutting_school_year_id' => $val['idCutting'],
            ]);
            return to_route('evaluation.create',$save->id)->with([
                'str' => 'info',
                'msg' => 'Ajoutez les notes de l\' évaluation.'
            ]);
        }
        catch (\Exception $e) {
            return to_route('evaluation.return', $request['idClass'].'_'.$request['idMatter'])->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        try{
            $eval = Evaluation::where('id', $id)->first();
            return view('pages.evaluations.edit',[
                'evaluation' => $eval,
                'approved' => $this->approvedMoyenneMatter($eval['classe_id'], $eval['level_matter_id'], $eval['cutting_school_year_id']),
                'students' => $this->getNoteSutedent($id)
            ]); 
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function getReturn($getId)
    {
        try{
            $id = explode('_', $getId);
            $type = ['secondaire' => 'general', 'technique' => 'technique', 'superieur' => 'superieur'];
            $year = $this->yearActif();
            $class = Classe::where('id', $id[0])->where('school_year_id', $year['id'])->first();
            $matter = LevelMatter::where('id', $id[1])->where('school_id', auth()->user()->school_id)->first();
            $cutting = CuttingSchoolYear::where('type', $type[$class['type']])->where('school_year_id', $year['id'])->get();
            $type = EvaluationType::orderBy('type')->get();
            if(in_array($class['level_id'], [10,11,12,13]) && $matter['matter_id'] == 2){
                $subMatter = SubMatter::orderBy('libelle')->get();
            }
            return view('pages.evaluations.detail',[
                'cutting' => $this->getCutting($cutting, $class['id'], $matter['id']),
                'class' => $class,
                'matter' => $matter,
                'sub_matter' => $subMatter ?? null,
                'type' => $type,
                'teacher' => ClasseEnseignant::where('classe_id', $class['id'])->where('matter_id', $matter['id'])->first()
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Edit the specified resource in storage.
     */
    public function edit(Request $request)
    {
        try{
            $eval = Evaluation::where('id', $request['id'])->first();
            $type = EvaluationType::orderBy('type')->get();
            if($eval['sub_matter_id']){
                $subMatter = SubMatter::orderBy('libelle')->get();
            }
            return response()->json([
                'eval' => $eval,
                'type' => $type,
                'subMatter' => $subMatter ?? null
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function editEval(Request $request, $id)
    {
        try{
            $val = $request->validate([
                'submatter' => 'nullable|integer',
                'select' => 'required|integer',
                'notee' => 'required|string',
                'date' => 'required|date',
                'status' => 'nullable|integer',
            ]);
            
            Evaluation::where('id', $id)->update([
                'notee' => $val['notee'],
                'date_create' => $val['date'],
                'sub_matter_id' => $val['submatter'] ?? null,
                'evaluation_type_id' => $val['select'],
                'status' => $val['status'] ?? '0'
            ]);
            return to_route('evaluation.return', $request['string'])->with([
                'str' => 'info',
                'msg' => 'Mise à jour éffectuée avec succes.'
            ]);
        }
        catch (\Exception $e) {
            return to_route('evaluation.return', $request['string'])->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $idEval)
    {
        try{
            $val = $request->validate([
                'evalId' => 'required|integer'
            ]);

            for($i = 0; $i < sizeof($request['student']); $i++){
                GetNote::where('inscription_id', $request['student'][$i])
                ->where('evaluation_id', $val['evalId'])
                ->update([
                    'note' => (!isset($request['note'][$i])) ? 'nc':$request['note'][$i]
                ]);
            }
            
            // -- Créer un job pour les calcul des moyennes --- //
            $eval = Evaluation::where('id', $idEval)->first();
            dispatch(new CalculMoyenneMatiereJob($request['student'], $eval['classe_id'], $eval['cutting_school_year_id'], $eval['level_matter_id'], $eval['sub_matter_id']));
            return to_route('evaluation.show',$idEval)->with([
                'str' => 'info',
                'msg' => 'Modification éffectuée.'
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Ajax Update the specified resource in storage.
     */
    public function ajaxUpdate(Request $request)
    {
        $data = GetNote::where('inscription_id', $request['student'])
        ->where('evaluation_id', $request['evalId'])
        ->update([
            'note' => (!isset($request['note'])) ? 'nc':$request['note']
        ]);

        // --- Créer un job pour les calcul des moyennes --- //
        $eval = Evaluation::where('id', $request['evalId'])->first();
        $tudents = Inscription::where('classe_id', $eval['classe_id'])->get('id');
        foreach($tudents as $item){
            $tab[] = $item['id'];
        }
        dispatch(new CalculMoyenneMatiereJob($tab, $eval['classe_id'], $eval['cutting_school_year_id'], $eval['level_matter_id'], $eval['sub_matter_id']));
        return $data;
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $val)
    {
        try{
            $val = explode('_',$val);
            $dt = Evaluation::where('id', $val[0])->where('classe_id', $val[1])->first(); 
            $count = GetNote::where('evaluation_id', $val[0])->count();
            if($count){
                $dts = [];
                $tudents = Inscription::where('classe_id', $val[1])->get('id');
                foreach($tudents as $item){
                    $dts[] = $item['id'];
                }
            }

            if($dt){
                $dt->delete();
                $count ? // Declanchement de Job pour le calcul de moyemme
                dispatch(new CalculMoyenneMatiereJob($dts, $dt['classe_id'], $dt['cutting_school_year_id'], $dt['level_matter_id'], $dt['sub_matter_id']))
                :null;
            }
            return to_route('evaluation.return', $val[1].'_'.$dt->level_matter_id)->with([
                'str' => 'info',
                'msg' => 'Suppression éffestuee avec succes.'
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function getDestroy(Request $request){
        $val = explode('_',$request['val']);
        $data = Evaluation::where('id', $val[0])->where('classe_id', $val[1])->first();
        $tab = [
            'type' => $data->evaluationType->type,
            'date' => date('d/m/Y', strtotime($data->date_create))
        ];
        return $tab;
    }

    /**
     * getEvaluation the specified resource from storage.
     */
    public function getEvaluation(Request $request){
        try{
            $request['matter_id'] = explode('_',$request['select'])[0];
            $request['class_id'] = explode('_',$request['select'])[1];
            $val = $request->validate([
                'matter_id' => 'required|integer',
                'class_id' => 'required|integer'
            ]);
            $type = ['secondaire' => 'general', 'technique' => 'technique', 'superieur' => 'superieur'];
            $year = $this->yearActif();
            $class = Classe::where('id', $val['class_id'])->where('school_year_id', $year['id'])->first();
            $matter = LevelMatter::where('matter_id', $val['matter_id'])->where('level_id', $class['level_id'])->where('school_id', auth()->user()->school_id)->first();
            $cutting = CuttingSchoolYear::where('type', $type[$class['type']])->where('school_year_id', $year['id'])->get();
            $type = EvaluationType::orderBy('type')->get();
            if(in_array($class['level_id'], [10,11,12,13]) && $val['matter_id'] == 2){
                $subMatter = SubMatter::where('matter_id', $val['matter_id'])->get();
            }
            return view('pages.evaluations.detail',[
                'cutting' => $this->getCutting($cutting, $class['id'], $matter['id']),
                'class' => $class,
                'matter' => $matter,
                'sub_matter' => $subMatter ?? null,
                'type' => $type,
                'actif' => null,
                'teacher' => ClasseEnseignant::where('classe_id', $class['id'])->where('matter_id', $val['matter_id'])->first()
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }


    /**
     * Get data class the specified resource from storage.
     */
    public function catchingUp($str)
    {
        try{
            $eval = Evaluation::find($str);
            $matiere = LevelMatter::find($eval->level_matter_id)['matter'];
            $verify = array_key_exists($matiere['id'], [8 => "Espagnol", 9 => "Allemad"]);
            
            return view('pages.evaluations.create',[
                'evaluation' => $eval,
                'students' => $this->getCatchingUp($eval->classe_id, $str, $verify, $matiere['libelle']),
                'catching' => 1
            ]);
        } // 
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }



    protected function getCatchingUp($classe, $eval, $exist = null, $lv2 = null,)
    {
        $tables = []; 
        $student = $exist ? $this->getLv2StudentClasse($classe, $lv2):$this->getStudentClasse($classe);
        foreach($student as $item){
            $val = GetNote::where('evaluation_id', $eval)->where('inscription_id', $item->id)->first();
            if(!$val){
                $tables[] = $item;
            }
        }
        return $tables;
    }


    /**
     * Get matter in level the specified resource from storage.
     */
    public function getMatiere(Request $request)
    {
        $class = Classe::where('id', $request['id'])->first();
        if($class['additif']){
            $additif = $class['additif'] == 'AP' ? 'Mus':'AP';
            if($class['lv2'] == 'mixte'){
                $dts = DB::table('matters')
                ->join('level_matter', 'matters.id', '=', 'level_matter.matter_id')
                ->select('matters.id', 'matters.libelle', 'matters.abbreviated')
                ->where('level_matter.school_id', '=', auth()->user()->school_id)
                ->where('level_matter.level_id', '=', $class['level_id'])
                ->where('level_matter.serie_id', '=', $class['serie_id'] ?? null)
                ->where('abbreviated', '<>', $additif)
                ->where('matters.libelle', '<>', 'mixte')
                ->where('level_matter.matter_id', '<>', '15')
                ->orderBy('matters.libelle')
                ->get();
            }
            else{
                $lv2 = $class['lv2'] == 'allemand' ? 'espagnol':'allemand';
                $dts = DB::table('matters')
                ->join('level_matter', 'matters.id', '=', 'level_matter.matter_id')
                ->select('matters.id', 'matters.libelle', 'matters.abbreviated')
                ->where('level_matter.school_id', '=', auth()->user()->school_id)
                ->where('level_matter.level_id', '=', $class['level_id'])
                ->where('level_matter.serie_id', '=', $class['serie_id'] ?? null)
                ->where('matters.libelle', '<>', $lv2 ?? null)
                ->where('abbreviated', '<>', $additif)
                ->where('matters.libelle', '<>', 'mixte')
                ->where('level_matter.matter_id', '<>', '15')
                ->orderBy('matters.libelle')
                ->get();
            }
        }
        else{
            if($class['lv2'] == 'mixte'){
                $dts = DB::table('matters')
                ->join('level_matter', 'matters.id', '=', 'level_matter.matter_id')
                ->select('matters.id', 'matters.libelle', 'matters.abbreviated')
                ->where('level_matter.school_id', '=', auth()->user()->school_id)
                ->where('level_matter.level_id', '=', $class['level_id'])
                ->where('level_matter.serie_id', '=', $class['serie_id'] ?? null)
                ->where('libelle', '<>','Arts plastique')->where('libelle', '<>','Musique')
                ->where('matters.libelle', '<>', 'mixte')
                ->where('level_matter.matter_id', '<>', '15')
                ->orderBy('matters.libelle')
                ->get();
            }
            else{
                $lv2 = $class['lv2'] == 'allemand' ? 'espagnol':'allemand';
                $dts = DB::table('matters')
                ->join('level_matter', 'matters.id', '=', 'level_matter.matter_id')
                ->select('matters.id', 'matters.libelle', 'matters.abbreviated')
                ->where('level_matter.school_id', '=', auth()->user()->school_id)
                ->where('level_matter.level_id', '=', $class['level_id'])
                ->where('level_matter.serie_id', '=', $class['serie_id'] ?? null)
                ->where('matters.libelle', '<>', $lv2 ?? null)
                ->where('libelle', '<>','Arts plastique')->where('libelle', '<>','Musique')
                ->where('matters.libelle', '<>', 'mixte')
                ->where('level_matter.matter_id', '<>', '15')
                ->orderBy('matters.libelle')
                ->get();
            }
        }
        
        return response()->json($dts);
    }

    /**
     * Get data class the specified resource from storage.
     */
    protected function typeEnseignement($dts)
    {
        $tab = []; $i = 0; $primaire = 0; $cycle = 0;
        $school = auth()->user()->school_id;
        $year = $this->yearActif();
        $data = [1 => 'realtime-reorder', 2 => 'basic-col-reorder', 3 => 'saving-reorder', 4 => 'predefine-reorder', 5 => null];
        foreach ($dts->school->typeEnseignements as $item) {
            if(!$primaire && ($item['id'] == 1 || $item['id'] == 2)){
                $tab[] = [
                    'nbre' => $i+=1, 
                    'tab' => $data[$i], 
                    'libelle' => verifyPrimaire($dts->school->typeEnseignements),
                    'data' => Classe::where('type', 'primaire')->where('school_year_id', $year['id'])->where('status', '1')->where('school_id', $school)->orderBy('level_id')->get()
                ];$primaire++;
            }
            elseif(!$cycle && ($item['id'] == 3 || $item['id'] == 4)){
                $tab[] = [
                    'nbre' => $i+=1,
                    'tab' => $data[$i], 
                    'libelle' => verifySeconde($dts->school->typeEnseignements),
                    'data' => Classe::where('type', 'secondaire')->where('school_year_id', $year['id'])->where('status', '1')->where('school_id', $school)->orderBy('level_id')->get(),
                ];$cycle++;
            }
            elseif($item['id'] == 5){
                $val = $item['type_enseignement'];
                $tab[] =[
                    'nbre' => $i+=1, 
                    'tab' => $data[$i], 
                    'libelle' => $val,
                    'data' => Classe::where('type', 'technique')->where('school_year_id', $year['id'])->where('status', '1')->where('school_id', $school)->orderBy('level_id')->get(),
                ];
            }
            elseif($item['id'] == 6){
                $val = $item['type_enseignement'];
                $tab[] =[
                    'nbre' => $i+=1, 
                    'tab' => $data[$i], 
                    'libelle' => $val,
                    'data' => Classe::where('type', 'superieur')->where('school_year_id', $year['id'])->where('status', '1')->where('school_id', $school)->orderBy('level_id')->get(),
                ];
            }
        }
        return $tab;
    }

    /**
     * Gestion the cutting school year the specified resource from storage.
     */
    protected function getCutting($cutting, $classe, $matter)
    {
        $tabs = [];$i = 1;
        $data = [1 => 'realtime-reorder', 2 => 'basic-col-reorder', 3 => 'saving-reorder', 4 => 'predefine-reorder', 5 => null];
        foreach($cutting as $item){
            $tabs[] = [
                'id' => $item->id,
                'libelle' => $item->cutting['libelle'], 
                'actif' => $item->status,
                'tab' => $data[$i],
                'approved' => $this->approvedMoyenneMatter($classe, $matter, $item->id),
                'data' => Evaluation::where('cutting_school_year_id', $item->id)->where('classe_id', $classe)->where('level_matter_id', $matter)->orderBy('date_create', 'DESC')->get()
            ];
            $i++;
        }
        return $tabs;
    }


    protected function approvedMoyenneMatter($class, $matter, $decoupage)
    {
        $first = ApprovedMoyenne::where('cutting_school_year_id', $decoupage)->where('classe_id', $class)->where('level_matter_id', $matter)->first();
        return $first->approved ?? null;
    }


    /**
     * Get school year actif the specified resource from storage.
     */
    protected function getStudentClasse($idclasse)
    {
        $year = $this->yearActif();
        $data = DB::table('students')
            ->join('inscriptions', 'students.id', '=', 'inscriptions.student_id')
            ->select('inscriptions.id', 'students.first_name', 'students.last_name', 'students.matricule', 'students.sexe', 'inscriptions.redoublant')
            ->where('inscriptions.classe_id', '=', $idclasse)
            ->where('inscriptions.school_year_id', '=', $year->id)
            ->orderBy('students.first_name')->orderBy('students.last_name')
            ->get();
        return $data;
    }


    /**
     * Get school year actif the specified resource from storage.
     */
    protected function getLv2StudentClasse($idclasse, $lv2)
    {
        $year = $this->yearActif();
        $data = DB::table('students')
            ->join('inscriptions', 'students.id', '=', 'inscriptions.student_id')
            ->select('inscriptions.id', 'students.first_name', 'students.last_name', 'students.matricule', 'students.sexe', 'inscriptions.redoublant')
            ->where('inscriptions.classe_id', '=', $idclasse)
            ->where('inscriptions.school_year_id', '=', $year->id)
            ->where('inscriptions.lv2', '=', $lv2)
            ->orderBy('students.first_name')->orderBy('students.last_name')
            ->get();
        return $data;
    }



    /**
     * Get school year actif the specified resource from storage.
     */
    protected function getNoteSutedent($idEval)
    {
        $year = $this->yearActif();
        $data = DB::table('students')
            ->join('inscriptions', 'students.id', '=', 'inscriptions.student_id')
            ->join('get_notes', 'inscriptions.id', '=', 'get_notes.inscription_id')
            ->select('inscriptions.id', 'students.first_name', 'students.last_name', 'students.matricule', 'students.sexe', 'inscriptions.redoublant', 'get_notes.note')
            ->where('get_notes.evaluation_id', '=', $idEval)
            ->where('inscriptions.school_year_id', '=', $year->id)
            ->orderBy('students.first_name')->orderBy('students.last_name')
            ->get();
        return $data;
    }


    /**
     * Get liste note end student the specified resource from storage.
     */
    protected function studentNoteList($identif, $sub = null, $lv2 = null)
    {
        $id = explode('_', $identif);
        $dts = $lv2 ? $this->getLv2StudentClasse($id[0] ,$lv2):$this->getStudentClasse($id[0]);
        $tab = [];
        foreach($dts as $item){
            $tab[] = [
                'id' => $item->id,
                'name' => strtoupper($item->first_name).' '.ucwords($item->last_name),
                'matricule' => $item->matricule,
                'sexe' => $item->sexe,
                'notes' => $sub ? $this->subNotes($item->id, $id[0], $id[1], $id[2]):$this->notes($item->id, $id[0], $id[1], $id[2]),
                'moyen' => MoyenneMatiere::where('inscription_id', $item->id)->where('level_matter_id', $id[2])->where('cutting_school_year_id', $id[1])->first()
            ];
        }
        return $tab;
    }

    /**
     *Get liste note the specified resource from storage.
     */
    protected function notes($student, $classe, $decoupage, $matiere){

        $datas = DB::TABLE('evaluations')
        ->JOIN('get_notes', 'evaluations.id', '=', 'get_notes.evaluation_id')
        ->SELECT('get_notes.note', 'evaluations.notee', 'evaluations.sub_matter_id')
        ->WHERE('get_notes.inscription_id', '=', $student)
        ->WHERE('evaluations.classe_id', '=', $classe)
        ->WHERE('evaluations.cutting_school_year_id', '=', $decoupage)
        ->WHERE('evaluations.level_matter_id', '=', $matiere)
        ->WHERE('evaluations.status', '=', '1')
        ->orderBy('evaluations.date_create', 'ASC')->get();
        return json_decode($datas, true); 
    }

    /**
     *Get liste sous note the specified resource from storage.
     */
    protected function subNotes($student, $classe, $decoupage, $matiere)
    {
        $tab1 = [
            'notes' => json_decode($this->getSubNote($student, $classe, $decoupage, $matiere, 1), true),
            'moyenne' => $this->moyenneStudentsSub($student, $decoupage, 1)
        ]; // Composition Française
        $tab2 = [
            'notes' => json_decode($this->getSubNote($student, $classe, $decoupage, $matiere, 2), true),
            'moyenne' => $this->moyenneStudentsSub($student, $decoupage, 2)
        ]; // Orthographe - Grammaire
        $tab3 = [
            'notes' => json_decode($this->getSubNote($student, $classe, $decoupage, $matiere, 3), true),
            'moyenne' => $this->moyenneStudentsSub($student, $decoupage, 3)
        ]; // Expression Orale
        return ['CF' => $tab1, 'OG' => $tab2, 'EO' => $tab3];
    }


    protected function moyenneStudentsSub($student, $decoupage, $item)
    {
        $val = MoyenneSubMatter::where('inscription_id', $student)->where('sub_matter_id', $item)->where('cutting_school_year_id', $decoupage)->first();
        return $val ? $val['moyenne']:'nc';
    }


    protected function getSubNote($student, $classe, $decoupage, $matiere, $val)
    {
        $datas = DB::TABLE('evaluations')
        ->JOIN('get_notes', 'evaluations.id', '=', 'get_notes.evaluation_id')
        ->SELECT('get_notes.note', 'evaluations.notee', 'evaluations.sub_matter_id')
        ->WHERE('get_notes.inscription_id', '=', $student)
        ->WHERE('evaluations.classe_id', '=', $classe)
        ->WHERE('evaluations.cutting_school_year_id', '=', $decoupage)
        ->WHERE('evaluations.level_matter_id', '=', $matiere)
        ->WHERE('evaluations.sub_matter_id', '=', $val)
        ->WHERE('evaluations.status', '=', '1')
        ->orderBy('evaluations.date_create', 'ASC')->get();
        return $datas->where('sub_matter_id', $val);
    }


    protected function getComposition()
    {
        $compos = EvaluatedLevel::where('school_id', auth()->user()->school_id)->where('school_year_id', $this->yearActif()['id'])->orderBy('created_at', 'DESC')->get();
        return $compos;
    }


    protected function bilanMatter($valeur)
    {
        $val = DB::table('matters')
        ->join('level_matter', 'matters.id', '=', 'level_matter.matter_id')
        ->join('libelle_bilan_matter', 'matters.id', '=', 'libelle_bilan_matter.matter_id')
        ->select('libelle_bilan_matter.libelle_bilan_id')->where('level_matter.id', '=', $valeur)->first();
        return $val->libelle_bilan_id;
    }

    /**
     * Get school year actif the specified resource from storage.
     */
    protected function yearActif(){
        $dts = SchoolYear::where('status', '1')->first();
        return $dts;
    }
}