<?php

namespace App\Http\Controllers;
use App\Models\Setting;
use App\Models\Level;
use App\Models\Serie;
use App\Models\SchoolYear;
use App\Models\Classe;
use App\Models\ClasseEnseignant;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use PDF;

class ClasseController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        try{
            $data = Setting::where('school_id',auth()->user()->school_id)->first();
            return view('pages.classe.index',[
                'data' => $this->typeEnseignement($data),
                'lettre' => $data['letter_class'],
                'adictif' => $data['musique_aplastique']
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Generate pdf the form for creating a new resource.
     */
    public function generatePdf($id)
    {
        $class = Classe::where('id', $id)->where('school_id', auth()->user()->school_id)->first();
        $setting = Setting::where('school_id', $class['school_id'])->first();
        $student = $this->getIncrits($id);
        $pdf = PDF::loadView('pdf.list_class',[
            'class' => $class,
            'school' => $setting,
            'student' => $student,
            'nbreF' => count($student->where('sexe', 'F')),
            'nbreM' => count($student->where('sexe', 'M')),
        ]);
        $pdf->setPaper('A4', 'portrait'); // ou 'A4', 'A3', etc.
        // return $pdf->download('liste_de_classe.pdf');
        return $pdf->stream('liste_de_classe_'.$class['libelle'].'.pdf');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        $lib = getIdLevel($request['lib']);
        if(sizeof($lib) == 2){
            $dts = Level::where('type_enseignement_id', $lib[0])->orWhere('type_enseignement_id', $lib[1])->get();
        }
        else{
            $dts = $lib[0] == 6 ? auth()->user()->school->levels:Level::where('type_enseignement_id', $lib[0])->get();
        }
        return response()->json($dts);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function series(Request $request)
    {
        $lib = changeVal($request['lib']);
        if($lib == 'secondaire' || $lib == 'technique'){
            $dts = [];
            $tab = auth()->user()->school->series->where('type', $lib)->where(strtolower($request['val']), '1');
            foreach($tab as $item){
                $dts[] = $item;
            }
        }
        elseif($lib == 'supérieur'){
            $dts = Serie::where('type', 'superieur')->get();
        }
        return response()->json($dts);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try{
            $validated = $request->validate([
                'libelle' => 'required|string',
                'level' => 'required|string',
                'effectif' => 'required|integer',
                'nbre' => 'required|integer',
            ]);
            $level = explode('_', $validated['level']);
            $serie = $request['serie'] ? explode('_', $request['serie']):null;
            $libelle = changeVal($validated['libelle']);
            $school = auth()->user()->school_id;

            if($libelle == 'primaire'){
                $this->primaireSave($level,$validated['effectif'],$libelle,$school,$validated['nbre'],$request['letter']);
            }

            if($libelle == 'secondaire'){
                $this->secondaireSave($level,$validated['effectif'],$request['lv2'],$libelle,$school,$validated['nbre'],$serie,$request['letter'],$request['additif']);
            }

            if($libelle == 'technique'){
                $request->validate(['serie' => 'required|string']);
                $year = SchoolYear::where('status', '1')->first();
                $data = Classe::where('level_id', $level[0])->where('school_year_id', $year['id'])->where('serie_id', $serie[0])->where('school_id', $school)->get();
                $i = 1; $nb = sizeof($data);
                while ($i <= $validated['nbre']) {
                    $classe = $level[1].$serie[1].$this->choiseLetter($nb++);
                    $this->saveData($classe,$validated['effectif'],null,$libelle,$school,$year['id'],$level[0],$serie[0],null,null);
                    $i++;
                }
            }

            if($libelle == 'supérieur'){
                $request->validate(['serie' => 'required|string']);
                $this->superieurSave($level,$validated['effectif'],$school,$validated['nbre'],$serie);
            }

            return back()->with([
                'str' => 'success',
                'msg' => 'Classe ajoutée avec succes.',
                'lib' => $request['libelle']
            ]);
            
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.',
                'lib' => $request['libelle']
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        try{
            $class = Classe::where('id', $id)->where('school_id', auth()->user()->school_id)->first();
            $teacher = ClasseEnseignant::where('classe_id', $id)->where('prof_prl', '1')->first();
            $fille = ($this->getIncrits($id))->where('sexe', 'F')->count();
            $garcon = ($this->getIncrits($id))->where('sexe', 'M')->count();
            return view('pages.classe.detail',[
                'classe' => $class,
                'teacher' => $teacher,
                'incrits' => $this->getIncrits($id),
                'fille' => ($fille <= 9) ? '0'.$fille:$fille,
                'garcon' => ($garcon <= 9) ? '0'.$garcon:$garcon,
                'users' => $this->getTeacher()
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Request $request)
    {
        $data = Classe::where('id', $request['id'])->where('school_id', auth()->user()->school_id)->first();
        return response()->json($data);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        try{
            $val = $request->validate([
                'lib' => 'required|string',
                'id' => 'required|integer',
                'effectif' => 'required|integer',
            ]);
            $dts =  Classe::where('id', $request['id'])->where('school_id', auth()->user()->school_id)->first();
            $dts->update([
                'effectif' => $val['effectif'],
                'lv2' => $request['lv2'] ?? $dts['lv2'],
                'additif' => $request['additif'] ?? null,
                // 'inscrits' => $request['inscrit'] ?? $dts['inscrits'],
                'status' =>  $request['status'] ? '1':'0'
            ]);
            return back()->with([
                'str' => 'info',
                'msg' => 'Mise à jour éffecté',
                'lib' => $request['lib']
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.',
                'lib' => $request['lib']
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        try{
            $val = $request->validate([
                'lib' => 'required|string',
                'id' => 'required|integer'
            ]);
            $dts =  Classe::where('id', $request['id'])->where('school_id', auth()->user()->school_id)->first();
            if($dts && $dts['inscrits'] == 0){
                $dts->delete();
                return back()->with([
                    'str' => 'info',
                    'msg' => 'Suppression effectuée avec succes.',
                    'lib' => $request['lib']
                ]);
            }
            else{
                return back()->with([
                    'str' => 'warning',
                    'msg' => 'Impossible de supprimer cette classe.',
                    'lib' => $request['lib']
                ]);
            }
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.',
                'lib' => $request['lib']
            ]);
        }
    }

    /**
     * Add teacher the specified resource from storage.
     */
    public function teacher(Request $request)
    {
        try{
            $val = $request->validate([
                'teacher' => 'required|string',
                'classe' => 'required|string'
            ]);
            // Suppression l'existent
            $exist = ClasseEnseignant::where('user_id', $val['teacher'])->where('classe_id', $val['classe'])->where('prof_prl', '1')->first();
            if($exist){
                $exist->delete();
            }
            
            ClasseEnseignant::create([
                'user_id' => $val['teacher'],
                'classe_id' => $val['classe'],
                'prof_prl' => '1',
            ]);

            return to_route('classe.show',$val['classe'])->with([
                'str' => 'info',
                'msg' => 'Enseignant ajouté à cette classe.',
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }


    /**
     * Remove the specified resource from storage.
     */
    protected function primaireSave($level,$effectif,$libelle,$school,$nombre,$letter = null){
        $config = Setting::where('school_id',auth()->user()->school_id)->first();
        $year = SchoolYear::where('status', '1')->first();
        if($config['letter_class']){
            $data = Classe::where('level_id', $level[0])->where('school_year_id', $year['id'])->where('letter', $letter)->where('school_id', $school)->get();
            sizeof($data) == 1 ? $data[0]->update(['libelle' => $data[0]->libelle.sizeof($data)]):null;
            $i = 1; $nb = sizeof($data);
            while ($i <= $nombre) {
                $classe = $level[1].$letter.(sizeof($data) > 1 ? $nb+=1:($nombre > 1 ? $nb+=1:null));
                $this->saveData($classe,$effectif,null,$libelle,$school,$year['id'],$level[0],null,$letter,null);
                $i++;
            }
        }
        else{
            $data = Classe::where('level_id', $level[0])->where('school_year_id', $year['id'])->where('school_id', $school)->get();
            if(sizeof($data) == 0 && $nombre == 1){
                $this->saveData($level[1],$effectif,null,$libelle,$school,$year['id'],$level[0],null,null,null);
            }
            else{
                sizeof($data) == 1 ? $data[0]->update(['libelle' => $data[0]->libelle.$this->choiseLetter(0)]):null;
                $i = 1; $nb = sizeof($data);
                while ($i <= $nombre) {
                    $classe = $level[1].$this->choiseLetter($nb++);
                    $this->saveData($classe,$effectif,null,$libelle,$school,$year['id'],$level[0],null,null,null);
                    $i++;
                }
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    protected function secondaireSave($level,$effectif,$lv2 = null,$libelle,$school,$nombre,$serie = null,$letter = null, $additif = null){
        $config = Setting::where('school_id',auth()->user()->school_id)->first();
        $year = SchoolYear::where('status', '1')->first();
        if($level[0] < 14){
            if($config['letter_class']){
                $data = Classe::where('level_id', $level[0])->where('school_year_id', $year['id'])->where('letter', $letter)->where('school_id', $school)->get();
                $i = 1; $nb = sizeof($data);
                while ($i <= $nombre) {
                    $classe = $level[1].$letter.$nb+=1;
                    $this->saveData($classe,$effectif,$lv2,$libelle,$school,$year['id'],$level[0],null,$letter,null, $additif);
                    $i++;
                }
            }
            else{
                $data = Classe::where('level_id', $level[0])->where('school_year_id', $year['id'])->where('school_id', $school)->get();
                $i = 1; $nb = sizeof($data);
                while ($i <= $nombre) {
                    $classe = $level[1].$nb+=1;
                    $this->saveData($classe,$effectif,$lv2,$libelle,$school,$year['id'],$level[0],null,null,null, $additif);
                    $i++;
                }
            }
        }
        else{
            $data = Classe::where('level_id', $level[0])->where('school_year_id', $year['id'])->where('serie_id', $serie[0])->where('school_id', $school)->get();
            $i = 1; $nb = sizeof($data);
            while ($i <= $nombre) {
                $final = in_array($serie[0], [2,3]) ? $this->choiseLetter($nb++):$nb+=1;
                $classe = $level[1].$serie[1].$final;
                $this->saveData($classe,$effectif,$lv2,$libelle,$school,$year['id'],$level[0],$serie[0],null,null, $additif);
                $i++;
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    protected function superieurSave($level,$effectif,$school,$nombre,$serie){
        $bts = $serie[1] == '1ere Année' ? 1:2;
        $year = SchoolYear::where('status', '1')->first();
        $data = Classe::where('level_id', $level[0])->where('school_year_id', $year['id'])->where('bts', $bts)->where('school_id', $school)->get();

        if(sizeof($data) == 0 && $nombre == 1){
            $classe = $level[1].' BTS'.$bts;
            $this->saveData($classe,$effectif,null,'superieur',$school,$year['id'],$level[0],$serie[0],null,$bts);
        }
        else{
            sizeof($data) == 1 ? $data[0]->update(['libelle' => explode(' ',$data[0]->libelle)[0].sizeof($data).' '.explode(' ',$data[0]->libelle)[1]]):null;
            $i = 1; $nb = sizeof($data);
            while ($i <= $nombre) {
                $cls = $level[1].$nb+=1;
                $classe = $cls.' BTS'.$bts;
                $this->saveData($classe,$effectif,null,'superieur',$school,$year['id'],$level[0],$serie[0],null,$bts);
                $i++;
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    protected function choiseLetter($nbre){
        $letter = ['A','B','C','D','E','F','G','H','I','J'];
        return $letter[$nbre];
    }

    /**
     * Remove the specified resource from storage.
     */
    protected function saveData($classe,$effectif,$lv2=null,$libelle,$school,$year,$level,$sere=null,$letter=null,$bts=null, $additif=null){
        Classe::create([
            'libelle' => $classe,
            'effectif' => $effectif,
            'lv2' => $lv2,
            'type' => $libelle,
            'school_id' => $school,
            'school_year_id' => $year,
            'level_id' => $level,
            'serie_id' => $sere,
            'letter' => $letter,
            'bts' => $bts,
            'additif' => $additif
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    protected function typeEnseignement($dts)
    {
        $tab = []; $i = 0; $primaire = 0; $cycle = 0;
        $school = auth()->user()->school_id;
        $year = SchoolYear::where('status', '1')->first();
        $data = [1 => 'realtime-reorder', 2 => 'basic-col-reorder', 3 => 'saving-reorder', 4 => 'predefine-reorder', 5 => null];
        foreach ($dts->school->typeEnseignements as $item) {
            if(!$primaire && ($item['id'] == 1 || $item['id'] == 2)){
                $tab[] = [
                    'nbre' => $i+=1, 
                    'tab' => $data[$i], 
                    'libelle' => verifyPrimaire($dts->school->typeEnseignements),
                    'data' => Classe::where('type', 'primaire')->where('school_year_id', $year['id'])->where('school_id', $school)->orderBy('level_id', 'ASC')->get()
                ];$primaire++;
            }
            elseif(!$cycle && ($item['id'] == 3 || $item['id'] == 4)){
                $tab[] = [
                    'nbre' => $i+=1,
                    'tab' => $data[$i], 
                    'libelle' => verifySeconde($dts->school->typeEnseignements),
                    'data' => Classe::where('type', 'secondaire')->where('school_year_id', $year['id'])->where('school_id', $school)->orderBy('level_id', 'ASC')->get(),
                ]; $cycle++;
            }
            elseif($item['id'] == 5){
                $val = $item['type_enseignement'];
                $tab[] =[
                    'nbre' => $i+=1, 
                    'tab' => $data[$i], 
                    'libelle' => $val,
                    'data' => Classe::where('type', 'technique')->where('school_year_id', $year['id'])->where('school_id', $school)->orderBy('level_id', 'ASC')->get(),
                ];
            }
            elseif($item['id'] == 6){
                $val = $item['type_enseignement'];
                $tab[] =[
                    'nbre' => $i+=1, 
                    'tab' => $data[$i], 
                    'libelle' => $val,
                    'data' => Classe::where('type', 'superieur')->where('school_year_id', $year['id'])->where('school_id', $school)->orderBy('level_id', 'ASC')->get(),
                ];
            }
        }
        return $tab;
    }


    private function getTeacher(){
        $users = User::where('typeEnseignant','maitre')->where('school_id', auth()->user()->school_id)->where('status', '1')->orderBy('first_name', 'ASC')->orderBy('last_name', 'ASC')->get();
        $year = SchoolYear::where('status', '1')->first();
        $teachs = [];
        foreach($users as $user){
            $exist = DB::table('classe_enseignant')
            ->join('classes', 'classes.id', '=', 'classe_enseignant.classe_id')
            ->where('classe_enseignant.user_id', '=', $user->id)
            ->where('classes.school_year_id', '=', $year->id)->count();
            if(!$exist){
                $teachs[] = $user;
            }
        }

        return $teachs;
    }


    protected function getIncrits($id){
        $incrits = DB::table('inscriptions')
        ->join('students', 'students.id', '=', 'inscriptions.student_id')
        ->select()->where('inscriptions.classe_id', '=', $id)
        ->orderBy('students.first_name')->orderBy('students.last_name')->get();
        return $incrits;
    }
}