<?php $__env->startSection('title', 'Gestion des classes'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4>Gestion des classes</h4>
                                    <span id="addBtn">
                                        <button class="btn btn-inverse btn-outline-inverse btn-sm py-1" id="addNew" data-toggle="modal" data-target="#addClass" title="Add New Class"><i class="fas fa-plus m-0"></i></button>
                                        <input type="hidden" id="getInput" value="">
                                        <input type="hidden" id="letter" value="<?php echo e($lettre); ?>">
                                    </span>
                                </div>
                            </div>
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left <?php echo e(session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?> menuStep" id="<?php echo e(session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?>" data-lib="<?php echo e($item['libelle']); ?>" data-toggle="tab" href="#home<?php echo e($item['nbre']); ?>" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i><?php echo e(ucfirst($item['libelle'])); ?> [<?php echo e(count($item['data']) <= 9 ? '0'.count($item['data']):count($item['data'])); ?>]
                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="tab-pane <?php echo e(session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?>" id="home<?php echo e($item['nbre']); ?>" role="tabpanel">
                                            <table id="<?php echo e($item['tab']); ?>" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center">N°</th>
                                                        <th class="text-center">Libelle</th>
                                                        <th class="text-center">Effectif</th>
                                                        <th class="text-center">Status</th>
                                                        <th class="text-center" style="width: 20%">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $i = 1; ?>
                                                    <?php $__currentLoopData = $item['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                        <td class="text-center">
                                                            <div style="width: 100px; text-align:left; margin: auto">
                                                                <?php echo e(ucfirst($val['libelle'])); ?><?php echo e($val['lv2'] ? ' ('.limitCaracts($val['lv2'],3).')':''); ?>

                                                            </div>
                                                        </td>
                                                        <td class="text-center"><?php echo e($val['inscrits'] <= 9 ? '0'.$val['inscrits']:$val['inscrits']); ?>/<?php echo e($val['effectif'] <= 9 ? '0'.$val['effectif']:$val['effectif']); ?></td>
                                                        <td class="text-center">
                                                            <span class="pcoded-badge label label-<?php echo e($val['status'] ? 'success':'danger'); ?>"><?php echo e($val['status'] ? 'Actif':'Inactif'); ?></span>
                                                        </td>
                                                        <td style="width: 20%" class="py-1">
                                                            <div class="card-block remove-label m-0 p-0 text-center">
                                                                <?php if($val['type'] != 'primaire'): ?>
                                                                <a href="<?php echo e(route('time.index', $val['id'].'_'.$item['libelle'])); ?>" class="btn btn-sm btn-warning text-center px-2" title="Timetable & Teacher"><i class="fas fa-sort-amount-up m-0"></i></a>
                                                                <?php endif; ?>
                                                                <a href="<?php echo e(route('classe.show', $val['id'])); ?>" class="btn btn-sm btn-primary text-center px-2 ml-2" title="List student"><i class="fas fa-sliders-h m-0"></i></a>
                                                                <button class="editClass btn btn-sm btn-info text-center px-2 ml-2" data-id="<?php echo e($val['id']); ?>" data-toggle="modal" data-target="#editModal" title="Edit classe"><i class="far fa-edit m-0"></i></button>
                                                                <button class="deletClass btn btn-sm btn-danger text-center px-2 ml-2" title="Delete" data-val="<?php echo e($val['id'].'_'.$val['libelle']); ?>" data-toggle="modal" data-target="#deleteModal"><i class="far fa-trash-alt m-0"></i></button>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal Add Classe-->
<div class="modal fade" id="addClass" tabindex="-1" role="dialog" aria-labelledby="addClassModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="addClassModalLongTitle">Nouvelle classe</h5>
        </div>
        <form action="<?php echo e(route('classe.store')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-body">
                <input type="hidden" name="libelle" id="libelle">
                <div class="form-group mb-2">
                    <label class="col-form-label" for="myLevel">Select level<span class="text-danger">*</span> :</label>
                    <select name="level" id="myLevel" class="form-control">
                        <option value="">Select One option</option>
                    </select>
                </div>
                <div class="form-group mb-2" id="getSerie" style="display: none">
                    <label class="col-form-label" for="mySerie">Select une option<span class="text-danger">*</span> :</label>
                    <select name="serie" id="mySerie" class="form-control" disabled>
                        <option value="">Select One option</option>
                    </select>
                </div>
                <div class="form-group mb-3">
                    <label class="col-form-label" for="effectif">Effectif<span class="text-danger">*</span> :</label>
                    <input type="text" name="effectif" id="effectif" class="form-control number" value="30" min="1" placeholder="Effectif de la classe">
                </div>
                <div class="form-group mb-3" style="display: none" id="lv2">
                    <label class="mx-2" title="Allemand">
                        <input type="radio" name="lv2" class="lv2" value="allemand" checked disabled><span class="mx-1">Allemand</span>
                    </label>
                    <label class="mx-2" title="Espagnol">
                        <input type="radio" name="lv2" class="lv2" value="espagnol" disabled><span class="mx-1">Espagnol</span>
                    </label>
                    <label class="mx-2" title="Allemand et Espagnol">
                        <input type="radio" name="lv2" class="lv2" value="mixte" disabled><span class="mx-1">mixte</span>
                    </label>
                </div>
                <?php if($lettre): ?>
                <div class="form-group mb-0" id="getLetter" style="display:none">
                    <label class="mx-2">
                        <input type="radio" name="letter" value="A" class="letter" disabled checked><span class="mx-1">A</span>
                    </label>
                    <label class="mx-2">
                        <input type="radio" name="letter" value="B" class="letter" disabled><span class="mx-1">B</span>
                    </label>
                    <label class="mx-2">
                        <input type="radio" name="letter" value="C" class="letter" disabled><span class="mx-1">C</span>
                    </label>
                    <label class="mx-2" id="divBm" style="display:none">
                        <input type="radio" name="letter" value="BM" class="letter" title="Bonne Moyenne" disabled><span class="mx-1">BM</span>
                    </label>  
                </div>
                <?php endif; ?>
                <div class="form-group mb-3">
                    <label class="col-form-label" for="nbre">Nombre de classe<span class="text-danger">*</span> :</label>
                    <input type="text" name="nbre" id="nbre" class="form-control number" value="1" min="1" max="3" placeholder="Nombre de classe">
                </div>
                <?php if($adictif): ?>
                <div class="form-group mb-0" style="display:none" id="adictif">
                    <label class="mx-2">
                        <input type="radio" name="additif" value="AP" class="additif" checked disabled><span class="mx-1">Arts Plastique</span>
                    </label>
                    <label class="mx-2">
                        <input type="radio" name="additif" value="Mus" class="additif" disabled><span class="mx-1">Musique</span>
                    </label>
                </div>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
<!-- Modal Edit Classe -->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="editModalLabel">Edit Classe</h5>
          <strong id="libEtid" style="font-size: 19px"></strong>
        </div>
        <form action="<?php echo e(route('classe.update')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <?php echo method_field('put'); ?>
            <div class="modal-body">
                <input type="hidden" name="lib" id="editLib">
                <input type="hidden" name="id" id="editId">
                <div class="form-group mb-3">
                    <label class="col-form-label" for="editEff">Effectif<span class="text-danger">*</span> :</label>
                    <input type="text" name="effectif" id="editEff" class="form-control number" value="">
                </div>
                
                <div id="editLv2"></div>
                <div id="editAddit"></div>
                <div id="editStatus"></div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
<!-- Modal Delete Classe -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-danger py-2">
          <h5 class="modal-title" id="deleteModalTitle">Delete</h5>
        </div>
        <form action="<?php echo e(route('classe.destroy')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <?php echo method_field('delete'); ?>
            <div class="modal-body text-center py-3">
                <div class="text-center mb-3" id="deleteval"></div>
                <p class="my-0">
                    <strong>Vous êtes sur le point de faire une suppression définitive.</strong>
                </p>
                <span>Cliquez sur le 'Valider' pour achéver l'action.</span>
            </div>
            <input type="hidden" name="lib" id="detelLib">
            <input type="hidden" name="id" id="deleteId">
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){
            $('#getInput').val($('#active').data('lib'));
            $('.menuStep').on('click', function(){
                $('#getInput').val($(this).data('lib'));
            });

            $('#addNew').on('click', function() {
                $('#libelle').val($('#getInput').val());
                $('#getSerie').hide();
                $('.itemSelect').remove();
                $.inArray($('#getInput').val(), ['Prescolaire - Primaire','Prescolaire','Primaire']) !== -1 ? $('#divBm').fadeIn():$('#divBm').fadeOut();
                $.ajax({
                    url: '<?php echo e(route('classe.create')); ?>', // La route définie dans web.php
                    method: 'GET',
                    data: {
                        lib: $('#getInput').val()
                    },
                    success: function(data){
                        let i = 0; 
                        while (i < data.length) {
                            var text = data[i].level;
                            var capitalizedText = text.charAt(0).toUpperCase() + text.slice(1);
                            $('#myLevel').append('<option value="'+data[i].id+'_'+data[i].code+'" class="itemSelect">'+data[i].code +'</option>');
                            i++;
                        }
                    }
                });
            });

            $('#myLevel').on('change', function() {
                $val = $(this).val().split('_');
                verifVal($val[0]);
                ($.inArray($('#getInput').val(), ['Collège - Lycée','Lycée','Collège'])!== -1) ? $('#adictif').show():$('#additif').hide();
                ($.inArray($('#getInput').val(), ['Collège - Lycée','Lycée','Collège'])!== -1) ? $('.additif').prop('disabled', false):$('.additif').prop('disabled', true);
                if(($.inArray($('#getInput').val(), ['Collège - Lycée','Lycée','Collège'])!== -1) && ($.inArray($val[1],['4eme','3eme'])!== -1)){
                    $('#lv2').show(); $('.lv2').prop('disabled', false);
                }
                else{
                    $('#lv2').hide(); $('.lv2').prop('disabled', true);
                }
                if($val[0] > 13 && $val[0] != 17){ // id = 17 correspond à la valeur CPU
                    $('#getSerie').show();  $('#mySerie').prop('disabled', false);
                    $('.itemSerie').remove();
                    $.ajax({
                        url: '<?php echo e(route('classe.serie')); ?>',
                        method: 'GET',
                        data: {
                            lib: $('#getInput').val(),
                            val: $val[1]
                        },
                        success: function(data){
                            let i = 0; 
                            while (i < data.length) {
                                $('#mySerie').append('<option value="'+data[i].id+'_'+data[i].serie+'" class="itemSerie">'+data[i].serie+'</option>');
                                i++;
                            }
                        }
                    }); 
                }
                else{
                    $('#getSerie').hide(); $('#mySerie').prop('disabled', true);
                }
            });

            // Gestion des classes des lV2
            $('#mySerie').on('change', function() {
                $val = $(this).val().split('_')[0];
                $id = $('#myLevel').val().split('_')[1] == '2nd' ? '4':null;
                if(($.inArray($('#getInput').val(), ['Collège - Lycée','Lycée','Collège']) !== -1) && ($.inArray($val, ['1','2','3',$id]) !== -1)){
                    $('#lv2').show(); $('.lv2').prop('disabled', false);
                }
                else{
                    $('#lv2').hide(); $('.lv2').prop('disabled', true);
                }
            });

            // Edit Classe .......................................
            $(document).on('click', '.editClass', function() {
                $('#lv2Edit, #additEdit, #libNew, #statusEdit').remove();
                $id = $(this).data('id');
                $('#editLib').val($('#getInput').val()); $('#editId').val($id);
                $.ajax({
                    url: '<?php echo e(route('classe.edit')); ?>', // La route définie dans web.php
                    method: 'GET',
                    data: { id: $id },
                    success: function(data){
                        $('div#editModal').fadeIn();
                        let all = data['lv2'] == 'allemand' ? '<input type="radio" name="lv2" class="lv2" value="allemand" checked>':'<input type="radio" name="lv2" class="lv2" value="allemand">';
                        let esp = data['lv2'] == 'espagnol' ? '<input type="radio" name="lv2" class="lv2" value="espagnol" checked>':'<input type="radio" name="lv2" class="lv2" value="espagnol">';
                        let mixte = data['lv2'] == 'mixte' ? '<input type="radio" name="lv2" class="lv2" value="mixte" checked>':'<input type="radio" name="lv2" class="lv2" value="mixte">';
                        let cheched = data['status'] == 1 ? 'checked':'';
                        let val = data['status'] ? 'Active':'Inactive';
                        $('#libEtid').append('<span id="libNew">'+data['libelle']+'</span>');
                        $('#editEff').val(data['effectif']);
                        // $('#inscrit').val(data['inscrits']);
                        if(data['lv2']){
                            $('#editLv2').append(
                                '<div class="form-group mb-2 mx-3" id="lv2Edit">'+
                                   ' <label class="mx-2" title="Allemand">'+all+'<span class="mx-1">Allemand</span></label>'+
                                    '<label class="mx-2" title="Espagnol">'+esp+'<span class="mx-1">Espagnol</span></label>'+
                                    '<label class="mx-2" title="Allemand et Espagnol">'+mixte+'<span class="mx-1">Classe mixte</span></label>'+
                                '</div>'
                            );
                        }
                        if(data['additif']){
                            let apl = data['additif'] == 'AP' ? '<input type="radio" name="additif" value="AP" checked>':'<input type="radio" name="additif" value="AP">';
                            let mus = data['additif'] == 'Mus' ? '<input type="radio" name="additif" value="Mus" checked>':'<input type="radio" name="additif" value="Mus">';
                            $('#editAddit').append(
                                '<div class="form-group mb-2 mx-3" id="additEdit">'+
                                    '<label class="mx-2">'+apl+'<span class="mx-1">Arts Plastique</span></label>'+
                                    '<label class="mx-2">'+mus+'<span class="mx-1">Musique</span></label>'+
                                '</div>'
                            );
                        }
                        $('#editStatus').append(
                            '<div class="form-group px-2 mx-3" id="statusEdit">'+
                                '<input type="checkbox" id="status" name="status" '+cheched+'>'+
                                '<label class="mx-1" for="status">'+val+'</label>'+
                            '</div>'
                        );
                    }
                });
            });


            // Delete classe ........................
            $(document).on('click', '.deletClass', function() {
                $('#valDelete').remove();
                let val = $(this).data('val').split('_');
                if(val[0]){
                    $('#deleteId').val(val[0]);
                    $('#detelLib').val($('#getInput').val());
                    $('#deleteval').append('<strong id="valDelete" style="font-size: 19px">'+val[1]+'</strong>');
                    $('div#deleteModal').fadeIn();
                }
                else{
                    $('div#matierModal, .modal-backdrop').fadeOut();
                }
            });


            $('.number').on('keypress', function(e) {
                var charCode = e.which ? e.which : e.keyCode;
                if (charCode < 48 || charCode > 57) {
                    e.preventDefault(); // Empêche la saisie si ce n'est pas un chiffre
                }
            });


            // Function .............
            function verifVal($id){ // id = 17 correspond à la valeur CPU
                if(($('#letter').val()) && ($id <= 13 || $id == 17)){
                    $('#getLetter').show(); $('.letter').prop('disabled', false);
                }
                else{
                    $('#getLetter').hide(); $('.letter').prop('disabled', true);
                }
            }

        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views\pages\classe\index.blade.php ENDPATH**/ ?>