<?php $__env->startSection('title', 'List note'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4>Liste des notes - 
                                        <strong style="font-size: 19px"><?php echo e(ucfirst($class->libelle)); ?></strong>
                                    </h4>
                                    <span class="form-control-variant" style="font-size: 17px">
                                        <strong class="mr-2"><?php echo e(ucfirst($decoup->cutting->libelle.' [ '.($matter->matter->abbreviated ?? $matter->matter->libelle).' ]')); ?></strong>
                                    </span>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" title="Approuvez les moyennes" data-toggle="modal" data-target="#ModalConfirm" style="display: <?php echo e($approved ? 'none':''); ?>"><i class="fa fa-thumbs-up m-0"></i></button>
                                        <?php if(!$approved): ?>
                                        <a href="<?php echo e(route('evaluation.bonnus', $string)); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Bonnus moyenne"><i class="fa fa-qrcode mx-0"></i></a>
                                        <?php endif; ?>
                                        <a href="<?php echo e(route('evaluation.pdf', $string)); ?>" target="_blank" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Télécharger la fiche"><i class="fa fa-download mx-0"></i></a>
                                        <a href="<?php echo e(route('evaluation.return', $class->id.'_'.$matter->id)); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="mx-3 my-0">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive px-lg-3">
                                    <table id="saving-reorder" class="table table-stripeds table-bordered">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="width: 3%">N°</th>
                                                <th class="text-uppercase" style="width: 100px">Nom et prénoms</th>
                                                <th class="text-uppercase" style="width: 10px">Genre</th>
                                                <th class="text-uppercase" style="width: 20px">Matricule</th>
                                                <th class="text-center text-uppercase" style="width: 30px" title="Composition Française">CF</th>
                                                <th class="text-center text-uppercase" style="width: 30px" title="Orthographe-Grammaire">OG</th>
                                                <th class="text-center text-uppercase" style="width: 30px" title="Expression Orale">EO</th>
                                                <th class="text-uppercase text-center" style="width: 7%">Moyenne</th>
                                                <th class="text-uppercase text-center" style="width: 5%">Rang</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $i = 1 ?>
                                            <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th class="text-center py-2">
                                                    <div class="mt-2"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></div>
                                                </th>
                                                <td class="py-2">
                                                    <div class="mt-2"><?php echo e($item['name']); ?></div>
                                                </td>
                                                <td class="py-2"><div class="mt-2"><?php echo e(ucfirst($item['sexe'] == 'F' ? 'Féminin':'Masculin')); ?></div></td>
                                                <td class="py-2"><div class="mt-2"><?php echo e($item['matricule']); ?></div></td>
                                                <td class="p-0">
                                                    <table class="table p-0 m-0">
                                                        <tr class="m-0 p-0">
                                                            <?php $__currentLoopData = $item['notes']['CF']['notes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item1): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <td class="text-center m-0 py-1"><?php echo e($item1['note'] ?? 'nc'); ?></td>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tr>
                                                        <tr class="m-0 p-0">
                                                            <td colspan="4" class="py-0 text-center">Moy : <?php echo e($item['notes']['CF']['moyenne']); ?></td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                <td class="p-0">
                                                    <table class="table p-0 m-0">
                                                        <tr class="m-0 p-0">
                                                            <?php $__currentLoopData = $item['notes']['OG']['notes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <td class="text-center m-0 py-1"><?php echo e($item3['note'] ?? 'nc'); ?></td>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tr>
                                                        <tr class="m-0 p-0">
                                                            <td colspan="4" class="py-0 text-center">Moy : <?php echo e($item['notes']['OG']['moyenne']); ?></td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                <td class="p-0">
                                                    <table class="table p-0 m-0">
                                                        <tr class="m-0 p-0">
                                                            <?php $__currentLoopData = $item['notes']['EO']['notes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <td class="text-center m-0 py-1"><?php echo e($item2['note'] ?? 'nc'); ?></td>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tr>
                                                        <tr class="m-0 p-0">
                                                            <td colspan="4" class="py-0 text-center">Moy : <?php echo e($item['notes']['EO']['moyenne']); ?></td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                <th class="py-2 text-center">
                                                    <div class="mt-2"><?php echo e($item['moyen'] ? $item['moyen']['moyenne']:'--'); ?></div>
                                                </th>
                                                <td class="py-2 text-center">
                                                    <div class="mt-2"><?php echo e($item['moyen'] ? $item['moyen']['rang']:'--'); ?></div>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="ModalConfirm" tabindex="-1" role="dialog" aria-labelledby="ModalConfirmTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="ModalConfirmLongTitle">Confirmation</h5>
          <span style="font-size: 17px"><?php echo e(ucfirst($decoup->cutting->libelle)); ?></span>
        </div>
        <div class="modal-body py-3 text-center">
            <p class="mt-2">
                <strong style="font-size: 19px">Confirmation des moyenne !</strong>
            </p>
            " Apres cette action plus de modification <br> ou de suppression à votre niveau "
        </div>
        <div class="modal-footer">
            <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
            <a href="<?php echo e(route('evaluation.approved', $string)); ?>" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</a>
        </div>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){

        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views\pages\evaluations\list_note_french.blade.php ENDPATH**/ ?>