<?php $__env->startSection('title', 'Evaluation par matière'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4>Détail Sanctions</h4>
                                    <span class="form-control-variant" style="font-size: 15px">
                                        <div class="text-center text-muted" style="font-size: 17px"><?php echo e(strtoupper($inscris->student->first_name).' '.ucwords(limitCaracts($inscris->student->last_name,25))); ?> - <?php echo e($inscris->classe->libelle); ?></div>
                                    </span>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" id="getAdd" title="New Santion" data-toggle="modal" data-target="#addModal" style="display: none"><i class="fas fa-plus mx-0"></i></button>
                                        <input type="hidden" id="getdataId" value="">
                                        <a href="<?php echo e(route('sanction.show', $inscris->classe_id)); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left <?php echo e($item['actif'] == 1 ? 'active':''); ?>" data-lib="<?php echo e($item['libelle']); ?>" id="<?php echo e($item['actif'] == 1 ? 'active':'inactif'); ?>" data-actif="<?php echo e($item['actif']); ?>" data-id="<?php echo e($item['id']); ?>" data-conseil="<?php echo e($item['conseil']); ?>" data-toggle="tab" href="#home<?php echo e($item['id']); ?>" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i><?php echo e(ucfirst($item['libelle'])); ?>

                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        <div class="text-center mb-2 text-danger" id="conseil" style="display: none">
                                            <span style="font-size: 17px">Traduit en conseil de discipline <i class="fas fa-chalkboard-teacher"></i></span>
                                        </div>
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="tab-pane <?php echo e($item['actif'] == 1 ? 'active':''); ?>" id="home<?php echo e($item['id']); ?>" role="tabpanel">
                                            <table class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="width: 5%">N°</th>
                                                        <th class="text-center" style="width: 30%">Libelle</th>
                                                        <th class="text-center" style="width: 15%">Sanction</th>
                                                        <th class="text-center" style="width: 15%">Points</th>
                                                        <th class="text-center" style="width: 15%">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $i = 1; ?>
                                                    <?php $__currentLoopData = $item['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                        <td class="px-3"><?php echo e(ucwords($val['motif'])); ?></td>
                                                        <td class="text-center"><?php echo e($val['nbres'] <= 9 ? '0'.$val['nbres']:$val['nbres']); ?></td>
                                                        <td class="text-center" style="<?php echo e($item['conseil'] == 1 ? 'text-decoration: line-through':null); ?>"><?php echo e('0'.($val['total']-($val['nbres'] * $val['valeur'])).'/0'.$val['total']); ?></td>
                                                        <td style="width: 20%">
                                                            <div class="card-block remove-label m-0 p-0 text-center">
                                                                <button class="btn btn-sm btn-warning text-center px-2 ml-2"  data-val="<?php echo e($val['id'].'_'.$item['id']); ?>" data-actif="<?php echo e($item['actif']); ?>" data-toggle="modal" data-target="#listModal"><i class="fas fa-sort-amount-up m-0"></i></button>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                            <div style="float: right; font-size:17px;">
                                                <?php $val = $item['total'] - $item['val']; ?>
                                                Aperçu conduite : <strong><?php echo e($val <= 9 ? '0'.$val:$val); ?></strong> / <span id="total"><?php echo e($item['total'] <= 9 ? '0'.$item['total']:$item['total']); ?></span>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal Add Sanction -->
<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalLongTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="addModalTitle">Nouvelle sanction</h5>
        </div>
        <form action="<?php echo e(route('sanction.store')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-body pt-3">
                <input type="hidden" name="student" value="<?php echo e($inscris->id); ?>" id="student">
                <input type="hidden" name="cutting" value="" id="cutting">
                <div class="mb-3">
                    <label for="typeSanction">Type de sanction<span class="text-danger">*</span> : </label>
                    <select name="type" class="form-control" id="typeSanction">
                        <option selected value=<?php echo e(null); ?>>Open this select</option>
                        <?php $__currentLoopData = $motifs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $motif): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($motif['id']); ?>"><?php echo e(ucwords($motif['motif'])); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mb-3" id="divMotif" style="display: none">
                    <label for="motif">Motif de sanction<span class="text-danger">*</span> : </label>
                    <select name="" class="form-control nameMotif" id="motif">
                        <option selected value=''>Open this select</option>
                    </select>
                </div>
                <div class="mb-3 text-center" id="sanctionGrave" style="display: none">
                    <label class="text-danger" style="font-size: 17px">Sanction grave lui sera appliquée</label>
                    <input type="hidden" name="" value="sanction grave" class="nameMotif" id="inputGet">
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>

<!-- Modal Liste Sanction -->
<div class="modal fade" id="listModal" tabindex="-1" role="dialog" aria-labelledby="listModalLongTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="listModalTitle">Liste sanction</h5>
          <span style="font-size: 17px" id="getCutting"></span>
        </div>
        <div class="modal-body pt-3">
            <table class="table table-bordered" id="table">
                <thead>
                    <tr>
                        <th scope="col" class="text-center" style="width: 10%">N°</th>
                        <th scope="col" class="text-center" style="width: 25%">Date</th>
                        <th scope="col" class="text-center" style="width: 45%">Motif</th>
                        <th scope="col" style="width: 20%">Actions</th>
                    </tr>
                </thead>
                
                <tbody>
                </tbody>
              </table>
        </div>
        <div class="modal-footer">
            <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Fermer</button>
        </div>
      </div>
    </div>
</div>

 <!-- Modal delete -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLongTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <form action="<?php echo e(route('sanction.destroy')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <?php echo method_field('get'); ?>
                <div class="modal-header bg-dark py-2">
                    <h5 class="modal-title" id="deleteModalTitle">Suppression</h5>
                    <i class="far fa-angry mt-1"></i>
                </div>
                <div class="modal-body">
                    <p class="text-center"><b id="sanction"></b></p>
                    <div class="text-center" id="motifs"></div>
                    <p class="text-center">Le <span id="date"></span></p>
                    <div class="text-center mt-3">Cliquez sur 'valider' pour la suppression !</div>
                    <input type="hidden" name="sanction" id="idSanction" value="">
                    <input type="hidden" name="student" value="<?php echo e($inscris->id); ?>">
                </div>
                <div class="modal-footer">
                    <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Fermer</button>
                    <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment-with-locales.min.js"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){
            moment.locale('fr'); // on définit la langue

            $actif = $("#active").data('actif');
            $('#cutting').val($("#active").data('id'));
            $("#active").data('conseil') ? $('#conseil').slideDown():$('#conseil').slideUp();
            if($actif && $actif != 2){
                $('#getAdd').slideDown()
            }
            else{
                $('#getAdd').slideUp()
            }

            $('.nav-link').on('click', function(){
                $actif = $(this).data('actif');
                $actif == 2 ? $('#getAdd').hide():$('#getAdd').slideDown();
                $(this).data('conseil') ? $('#conseil').slideDown():$('#conseil').slideUp();
                $('#cutting').val($(this).data('id'));
                
            });


            $('#typeSanction').on('change', function() {
                $('.itemMotif').remove();
                $('.nameMotif').removeAttr("name");
                if($(this).val() != 5){
                    $('#motif').attr('name', 'motif');
                    $('#divMotif').slideDown(); $('#sanctionGrave').slideUp();
                    $tabs = getListeItemsMotifs($(this).val());
                    $i = 0;
                    while($i < $tabs.length){
                        $('#motif').append('<option class="itemMotif" value="'+$tabs[$i]+'">'+$tabs[$i]+'</option>');
                        $i++;
                    }
                }
                else{
                    $('#inputGet').attr('name', 'motif');
                    $('#divMotif').slideUp(); $('#sanctionGrave').slideDown();
                }
            });


            $('.btn-warning').on('click', function() {
                $val = $(this).data('val').split('_');
                $actif = $(this).data('actif');
                $('.addRow').remove();
                if($('#student').val() && $(this).data('val')){
                    $.ajax({
                        url: '<?php echo e(route('sanction.edit')); ?>',
                        method: 'GET',
                        data: {
                            student : $('#student').val(),
                            cutting : $val[1],
                            sanction : $val[0],
                        },
                        success: function(data){
                            $('div#listModal').fadeIn();
                            $('#getCutting').text(data['cutting']);
                            if(data['data'].length){
                                $i = 0; $disabled = ($actif != 1 ? 'disabled':null);
                                while ($i < data['data'].length) {
                                    $("#table tbody").append('<tr class="addRow">'+
                                        '<th scope="row" class="text-center">'+(($i+1) <= 9 ? ('0'+($i+1)):($i+1))+'</th>'+
                                        '<td>'+moment(data['data'][$i]['created_at']).format("dddd D MMMM YYYY")+'</td>'+
                                        '<td>'+data['data'][$i]['motif']+'</td>'+
                                        '<td class="text-center py-2">'+
                                            '<button class="btn btn-sm btn-danger px-2 text-center" data-id="'+data['data'][$i]['id']+'" data-toggle="modal" data-target="#deleteModal" '+$disabled+'><i class="far fa-trash-alt m-0"></i></button>'+
                                        '</td>'+
                                    '</tr>');
                                    $i++;
                                }
                            }
                            else{
                                $('#table tbody').append('<tr class="addRow"><th colspan="5" class="text-center">Données introuvables</th></tr>');
                            }
                        }
                    });

                }
            });


            // Get delete sanction
            $('#table tbody').on('click', '.btn-danger', function() {
                $('#idSanction').val('');
                $('div#listModal').modal('toggle');
                if($(this).data('id')){
                    $('#idSanction').val($(this).data('id'));
                    $.ajax({
                        url: '<?php echo e(route('sanction.search')); ?>',
                        method: 'GET',
                        data: {
                            id : $(this).data('id')
                        },
                        success: function(data){
                            $('#sanction').text(data['sanction']);
                            $('#motifs').text(data['motif']);
                            $('#date').text(data['date']);
                        }
                    });
                } 
            });


            function getListeItemsMotifs($val) {
                let items = [];
                switch ($val) {
                    case "3":
                        items = [
                            'Fraude',
                            'Tricherie',
                            'Vol',
                            'Extorsion de fond aux plus vulnérable',
                            'Attouchement/sexe dans l\'enceinte de l\'établissement',
                            'Port d\'arme, consommation d\'alcool, de tabac et autres stupéfiant'
                        ];
                        break;
                    case '2':
                        items = [
                            'Non-respect des instructions officielles',
                            'Non-respect du règlement intérieur de l\'établissement',
                            'Attroupement devant les sales de classe',
                            'Sorties sans autorisation',
                            'Pertubation des cours',
                            'Désobéissance aux personnels de l\'établissement',
                            'Dégradation des infrastructures',
                            'Agression et violation',
                            'Destrution des auxiliaires pédagogiques',
                            'Subtilisation des auxiliaires pédagogiques'
                        ];
                        break;
                    case "4":
                        items = [
                            'Propreté corporelle',
                            'Tenue vestimentaire'
                        ]
                        break;
                    default:
                        items = null;
                }
                return items;
            }

        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views\pages\sanction\create.blade.php ENDPATH**/ ?>