<?php $__env->startSection('title', 'Gestion des utilisateurs'); ?>
<?php $__env->startSection('link'); ?>
    <!-- Data Table Css -->
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/extensions/autofill/css/autoFill.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/extensions/autofill/css/select.dataTables.min.css')); ?>">
    <style>
        .dataTables_length{
            display: none;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-2">
                                    <h4>Gestion Admins & Enseignants Inactifs</h4>
                                    <span>
                                        <a href="<?php echo e(route('user.index')); ?>" class="btn btn-inverse btn-outline-inverse btn-sm mx-1 py-1" title="Return back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <div class="tab-content card-block">
                                        <table id="autofill" class="table table-striped table-bordered nowrap">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="width:15px">N°</th>
                                                    <th>Nom</th>
                                                    <th>Prénoms</th>
                                                    <th>Sexe</th>
                                                    <th>E-mail</th>
                                                    <th>Téléphone</th>
                                                    <th>Profil</th>
                                                    <th class="text-center">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $i = 1; ?>
                                                <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                    <td><?php echo e(strtoupper($user->first_name)); ?></td>
                                                    <td><?php echo e(ucwords($user->last_name)); ?></td>
                                                    <td><?php echo e($user->sexe == 'F' ? ucfirst('Femme'):ucfirst('Homme')); ?></td>
                                                    <td><?php echo e($user->email); ?></td>
                                                    <td><?php echo e($user->telephon); ?></td>
                                                    <td class="text-center"><?php echo e(ucfirst($user->role->role)); ?></td>
                                                    <td>
                                                        <div class="card-block remove-label m-0 p-0 text-center">
                                                            <a href="<?php echo e(route('user.show',$user->id)); ?>" class="btn btn-sm btn-primary text-center px-2" title="Detail"><i class="fas fa-ellipsis-h mx-0"></i></a>
                                                            <a href="<?php echo e(route('user.edit',$user->id)); ?>" class="btn btn-sm btn-info text-center px-2" title="Edit"><i class="fas fa-edit mx-0"></i></a>
                                                            <button class="userDelete btn btn-sm btn-danger text-white text-center px-2" title="Delete" data-id="<?php echo e($user->id); ?>" data-toggle="modal" data-target="#userModel"><i class="far fa-trash-alt mx-0"></i></button>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div> 
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="userModel" tabindex="-1" role="dialog" aria-labelledby="userModelTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="userModelLongTitle">Delete</h5>
            </div>
            <div class="modal-body">
            <div class="row">
                <div class="col-12 text-center">
                    <div class="divUser" id="divUser"></div>
                    <p class="my-0">
                        <strong>Vous êtes sur le point de faire une suppression définitive.</strong>
                    </p>
                    <span>Cliquez sur le 'Valider' pour achéver l'action.</span>
                </div>
            </div>
            </div>
            <form method="post" id="myUser">
                <?php echo csrf_field(); ?> 
                <?php echo method_field('delete'); ?>
                <div class="modal-footer">
                    <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                    <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/vfs_fonts.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.select.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/extensions-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){

            $urls = window.location.href;
            $url = $urls.split('user');

            // Delete user ................................ 
            $(document).on('click', '.userDelete', function() {
                $('#modalUser, #roleModal').remove();
                $id = $(this).data('id');
                $('#myUser').attr('action', $url[0]+'user/destroy/'+$id);
                $.ajax({
                    url: '<?php echo e(route('user.search')); ?>',
                    method: 'GET',
                    data: { data: $id},
                    success: function(response){
                        if(response){
                            $('#divUser').append(
                                '<h5 class="mb-1 mt-2" id="modalUser">'+response['nom']+' '+response['prenom']+'</h5>'+
                                '<p class="text-muted" id="roleModal"><strong>'+response['role']+'</strong></p>'
                            );
                            $('div#userModel').fadeIn();
                        }
                    }
                });
            });
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views\pages\users\inactive.blade.php ENDPATH**/ ?>