<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="Educas est une application de gestion d'ecole dans son ensemble">
    <meta name="author" content="Jean-Marius Yao">
    <title>Liste de classe <?php echo e($class->libelle); ?></title>
</head>
<style>
    body {
        font-size: .875em;
        overflow-x: hidden;
        color: #353c4e;
        font-family: "Open Sans", sans-serif;
    }

    /* applies border to the table */
    #tabled,th,td {
        border: 1px solid #dee2e6;
        padding: 10px;
        text-align: center
    }

    #tabled {
        width: 100%;
        border: 1px solid #dee2e6;
        border-collapse: collapse;
        table-layout: auto;
        border-spacing: 2px;
    }

    th, td {
        white-space: nowrap;
    }
</style>
<body>
    <header style="margin: 5px auto; border-bottom: 1px solid #dee2e6; height: 100px; padding-bottom: 15px">
        <div style="display: flex; flex-direction: row; justify-content: space-between;">
            <table style="width: 100%">
                <tbody>
                    <tr style="margin-bottom: 0%">
                        <td style="width: 50%; border:none">
                            <div style="text-align: center; font-size: 8px">Ministère de l'Education Nationale, de l'Enseignement <br> Technique et de la   Formation Professionnelle</div>
                        </td>
                        <td style="width: 50%; border:none">
                            <div style="text-align: center; font-size: 8px;">
                                <b >REPUBLIQUEDE COTE D'IVOIRE</b><br>
                                <i>Union - Discipline - Travail</i>
                            </div>
                        </td>
                    </tr>
                    <tr style="margin-bottom: 0%">
                        <td style="width: 40%; border:none">
                            <img src="<?php echo e(public_path($school->logoUrl())); ?>" class="m-b-10 w-100" alt="Logo établissement" style="height: 55px;">
                        </td>
                        <td style="width: 60%; border:none">
                            <div style="text-align: center">
                                <div style="text-align: center;">
                                    <b style="font-size: 15px;"><?php echo e(mb_strtoupper($school->school->name_school)); ?></b><br>
                                    <i style="font-size: 9px"><?php echo e($school->address_email); ?> / <?php echo e($school->phon_school); ?></i><br>
                                    <i style="font-size: 11px;">Année Scolaire : <b><?php echo e($class->schoolYear->school_year); ?></i>
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </header>
    
    <section style="margin: 5px auto;">
        <div style="margin-top: 20px">
            <div style="margin-top: 35px; text-align: center; font-size:21px; text-decoration: underline;">
                <b>LISTE DE CLASSE <?php echo e($class->libelle); ?></b>
            </div>
            <div style="margin-top: 25px; margin-left: 15px; margin-bottom: 0px">
                <span>Effectif : <?php echo e(count($student) <= 9 ? '0'.count($student):count($student)); ?></span>
                <span style="margin: 0px 15px"> | F : <?php echo e($nbreF <= 9 ? '0'.$nbreF:$nbreF); ?></span>
                <span style="margin: 0px 15px"> | M : <?php echo e($nbreM <= 9 ? '0'.$nbreM:$nbreM); ?></span>
            </div>
            <table id="tabled" style="margin-top: 0px">
                <thead>
                    <tr>
                        <th style="width: 3%"></th>
                        <th>Matricule</th>
                        <th>Nom et Prenoms</th>
                        <th>Genre</th>
                        
                        <?php if(!($class['type'] == 'primaire')): ?>
                        <th>Affecté</th>
                        <?php endif; ?>
                        <th>Redoublant</th>
                        <?php if(!($class['type'] == 'primaire')): ?>
                        <td>Boursier</th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; ?>
                    <?php $__currentLoopData = $student; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                        <td><?php echo e($item->matricule); ?></td>
                        <td style="text-align: left"><?php echo e(mb_strtoupper($item->first_name).' '.ucfirst($item->last_name)); ?></td>
                        <td><?php echo e(ucfirst($item->sexe == 'F' ? 'F':'M')); ?></td>
                        
                        <?php if($item->affecte): ?>
                        <td><?php echo e(ucfirst($item->affecte)); ?></td>
                        <?php endif; ?>
                        <td><?php echo e(ucfirst($item->redoublant)); ?></td>
                        <?php if($item->boursier): ?>
                        <td><?php echo e(ucfirst($item->boursier)); ?></td>
                        <?php endif; ?>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </section>
</body>
</html><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views\pdf\list_class.blade.php ENDPATH**/ ?>