<?php $__env->startSection('title', 'List school year'); ?>
<?php $__env->startSection('link'); ?>
    <!-- Data Table Css -->
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/extensions/autofill/css/autoFill.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/extensions/autofill/css/select.dataTables.min.css')); ?>">
    <style>
        .dataTables_length{
            display: none;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <div class="main-body">
        <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-2">
                                    <h4>Gestion des années scolaires</h4>
                                    <span>
                                        <a href="<?php echo e(route('school_year.create')); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Add New School Year"> <i class="fas fa-plus mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <table id="autofill" class="table table-striped table-bordered nowrap">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="width:15px">N°</th>
                                                <th>Année scolaire</th>
                                                <th>Découpage</th>
                                                <th>Status</th>
                                                <th class="text-center">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $i = 1; ?>
                                            <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                <td><?php echo e($item->school_year); ?></td>
                                                <td><?php echo e(ucwords($item->decoupage)); ?></td>
                                                <td><?php echo e($item->status ? 'Actif':'Inactif'); ?></td>
                                                <td class="py-1">
                                                    <div class="card-block remove-label m-0 p-0 text-center">
                                                        <a href="<?php echo e(route('school_year.edit',$item->id)); ?>" class="btn btn-sm btn-info text-center px-2" title="Edit"><i class="fas fa-edit mx-0"></i></a>
                                                        <button class="getIdButton btn btn-sm btn-danger text-white text-center px-2" title="Delete" data-id="<?php echo e($item->id); ?>" data-toggle="modal" data-target="#exampleModalCenter" <?php echo e($item->status ? 'disabled':''); ?>><i class="far fa-trash-alt mx-0"></i></button>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table> 
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
<?php echo $__env->make('includes._modal_simple', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/pages/data-table/js/jszip.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/pages/data-table/js/pdfmake.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/pages/data-table/js/vfs_fonts.js')); ?>"></script>
<script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.select.min.js')); ?>"></script>
<script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
<script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
<!-- i18next.min.js -->
<script src="<?php echo e(asset('bower_components/i18next/i18next.min.js')); ?>"></script>
<script src="<?php echo e(asset('bower_components/i18next-xhr-backend/i18nextXHRBackend.min.js')); ?>"></script>
<script src="<?php echo e(asset('bower_components/i18next-browser-languagedetector/i18nextBrowserLanguageDetector.min.js')); ?>"></script>
<script src="<?php echo e(asset('bower_components/jquery-i18next/jquery-i18next.min.js')); ?>"></script>
<!-- Custom js -->
<script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/extensions-custom.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
<script>
    $('docemnt').ready(function(){
        
        $urls = window.location.href;
        $url = $urls.split('school_year');

        $('.getIdButton').click(function() {
            $id = $(this).data('id');
            $('#myForm').attr('action', $url[0]+'/school_year/destroy/'+$id);
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views\pages\school_year\index.blade.php ENDPATH**/ ?>