<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->enum('sexe',['F','H'])->nullable();
            $table->string('email')->unique();
            $table->string('residence')->nullable();
            $table->string('telephon')->nullable()->unique();
            $table->enum('matrimoniale',['marié','célibataire'])->nullable();
            $table->enum('embauche', ['permanent', 'vacataire'])->nullable();
            $table->enum('typeEnseignant', ['maitre', 'professeur'])->nullable();
            $table->enum('domaine', ['primaire', 'secondaire', 'technique', 'superiaur', 'tout'])->nullable(); // pour la gestion de la caisse
            $table->enum('autorisation', [0, 1])->nullable();
            $table->string('num_autorisation')->unique()->nullable();
            $table->string('date_autorisation')->nullable();
            $table->string('diplome')->nullable();
            $table->unsignedBigInteger('school_id')->nullable();
            $table->unsignedBigInteger('role_id')->nullable();
            $table->unsignedBigInteger('type_enseignement_id')->nullable(); // Pour les profils sous-directeurs
            $table->unsignedBigInteger('level_id')->nullable(); // Pour les profils educateurs Ou Surveillants
            $table->string('photo')->nullable();
            $table->enum('status',['0','1'])->default('1');
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->rememberToken();
            $table->timestamps();

            // Définir la clé étrangère
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('role_id')->references('id')->on('roles')->onDelete('cascade');
            $table->foreign('type_enseignement_id')->references('id')->on('type_enseignements')->onDelete('cascade');
            $table->foreign('level_id')->references('id')->on('levels')->onDelete('cascade');
        });

        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};
