<?php

namespace App\Http\Controllers;

use App\Models\AfterNoonTime;
use App\Models\MorningTime;
use Illuminate\Http\Request;

class SlotTimeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        try{
            $morning = MorningTime::where('school_id', auth()->user()->school_id)->get();
            $after = AfterNoonTime::where('school_id', auth()->user()->school_id)->get();
            return view('pages.time_slot.index', [
                'morning' => $morning,
                'after' => $after,
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        try{
            $morning = MorningTime::where('school_id', auth()->user()->school_id)->get();
            $after = AfterNoonTime::where('school_id', auth()->user()->school_id)->get();
            return view('pages.time_slot.create',[
                'nbre' => 5,
                'morning' => $morning,
                'after' => $after,
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try{
            $mtDbts = $request['mtDbts'];
            $mtFns = $request['mtFns'];
            $mdDbts = $request['mdDbts'];
            $mdFns = $request['mdFns'];
            if(count($mtDbts) == count($mtFns) && count($mdDbts) == count($mdFns)){
                $this->deleteTimeMorning();
                $this->deleteTimeAfter();
                // Save data for time morning
                $this->saveTimeMorning($mtDbts, $mtFns);
                // Save data for time after noon
                $this->saveTimeAfterNoon($mdDbts, $mdFns);

                return redirect()->route('time_slot.index')->with([
                    'str' => 'success',
                    'msg' => 'plage horaire ajoutée'
                ]);
            }
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function update(Request $request){
        try{
            $val = $request->validate([
                'id' => 'required|string',
                'debut' => 'required|date_format:H:i',
                'fin' => 'required|date_format:H:i',
            ]);
            $ids = explode('_', $val['id']);
            $dts = $ids[1] == 1 ? MorningTime::find($ids[0]):AfterNoonTime::find($ids[0]);

            if($dts){
                $dts->update([
                    'debut' => $val['debut'],
                    'fin' => $val['fin']
                ]);
                return back()->with([
                    'str' => 'success',
                    'msg' => 'Modification prise en compte.'
                ]);
            }
            else{
                return back()->with([
                    'str' => 'danger',
                    'msg' => 'Une erreur est survenue.'
                ]);
            }
            
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    protected function deleteTimeMorning(){
        MorningTime::where('school_id', auth()->user()->school_id)->delete();
    }

    /**
     * Update the specified resource in storage.
     */
    protected function deleteTimeAfter(){
        AfterNoonTime::where('school_id', auth()->user()->school_id)->delete();
    }

    /**
     * Save the form for editing the specified resource.
     */
    protected function saveTimeMorning($debut, $fin){
        for($i = 0; $i < sizeof($debut); $i++){
            if($debut[$i] && $fin[$i]){
                MorningTime::create([
                    'debut' => $debut[$i],
                    'fin' => $fin[$i],
                    'numero' => $i+1,
                    'school_id' => auth()->user()->school_id
                ]);
            }
        }
    }

    /**
     * Save the form for editing the specified resource.
     */
    protected function saveTimeAfterNoon($debut, $fin){
        for($i = 0; $i < sizeof($debut); $i++){
            if($debut[$i] && $fin[$i]){
                AfterNoonTime::create([
                    'debut' => $debut[$i],
                    'fin' => $fin[$i],
                    'numero' => $i+1,
                    'school_id' => auth()->user()->school_id
                ]);
            }
        }
    }
}
