<?php

namespace App\Http\Controllers;
use App\Models\School;
use App\Models\Setting;
Use App\Models\Student;
use App\Models\SchoolYear;
use App\Models\CuttingSchoolYear;
use Carbon\Carbon;

class DashboardController extends Controller
{
    public function dashboard(){
        $this->updateOfcutting();
        $year = $this->SchoolYear();
        session(['year' => $year ? $year['school_year']:null]);
       
        // 
        $schools = School::where('status', '1')->get();
        $data = Setting::where('school_id', auth()->user()->school_id)->first();
        return view('dashboard', [
            'schools' => $schools,
            'effetifs' => auth()->user()->id ==  1 ? []:$this->typeStudent($data, auth()->user()->school_id)
        ]);
    }



    /**
     * Remove the specified resource from storage.
     */
    private function typeStudent($dts, $school)
    {
        $tables = []; $primaire = 0; $cycle = 0;
        if($dts){
            foreach ($dts->school->typeEnseignements as $item) {
                if(!$primaire && ($item['id'] == 1 || $item['id'] == 2)){
                    $tables[] = [
                        'libelle' => verifyPrimaire($dts->school->typeEnseignements),
                        'effectif' => Student::where('type', 'primaire')->where('school_id', $school)->where('status', '1')->count()
                    ];$primaire++;
                }
                elseif(!$cycle && ($item['id'] == 3 || $item['id'] == 4)){
                    $tables[] = [
                        'libelle' => verifySeconde($dts->school->typeEnseignements),
                        'effectif' => Student::where('type', 'secondaire')->where('school_id', $school)->where('status', '1')->count(),
                    ]; $cycle++;
                }
                elseif($item['id'] == 5){
                    $val = $item['type_enseignement'];
                    $tables[] =[
                        'libelle' => $val,
                        'effectif' => Student::where('type', 'technique')->where('school_id', $school)->where('status', '1')->count(),
                    ];
                }
                elseif($item['id'] == 6){
                    $val = $item['type_enseignement'];
                    $tables[] =[
                        'libelle' => $val,
                        'effectif' => Student::where('type', 'superieur')->where('school_id', $school)->where('status', '1')->count(),
                    ];
                }
            }
        }
        return $tables;
    }


    private function SchoolYear(){
        $year = SchoolYear::where('status', '1')->first();
        return $year;
    }




    private function updateOfcutting(){
        // Verification et mis à jour des decoupage de l'année scolaire en cours .....
        $curentDate = Carbon::now()->format('d-m-Y'); // La date du jour
        $yearActif = $this->SchoolYear(); 
        $datas = $yearActif ? CuttingSchoolYear::where('school_year_id', $yearActif['id'])->where('status', '<>', '2')->get():null;
        if($datas){
            foreach($datas as $item){
                $val = verifyDateDecoupage($item['start_date'], $item['end_date'], $curentDate);
                if($item['status'] != verifyDateDecoupage($item['start_date'], $item['end_date'], $curentDate)){
                    CuttingSchoolYear::where('school_year_id', $yearActif['id'])->where('cutting_id', $item['cutting_id'])->update(['status' => $val]);
                }
            }
        }
    }
}
