@extends('app')
@section('title', 'Evaluation par matière')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4>Détail Résultat</h4>
                                    <span class="form-control-variant" style="font-size: 15px">
                                        <strong class="mr-2">{{$classe['libelle']}}</strong>[{{$enseignant ? :'Non defini'}}]
                                    </span>
                                    <span>
                                        <a id="btnLink" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Vus d'ensemble"><i class="far fa-eye m-0"></i></a>
                                        <a href="{{route('resultat.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        @foreach ($datas as $item)
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left {{$item['actif'] == 1 ? 'active':''}}" data-lib="{{$item['libelle']}}" id="{{$item['actif'] == 1 ? 'active':'inactif'}}" data-actif="{{$item['actif']}}" data-id="{{$item['id']}}" data-toggle="tab" href="#home{{$item['id']}}" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i>{{ucfirst($item['libelle'])}}
                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        @endforeach
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        @foreach ($datas as $item)
                                        <div class="tab-pane {{$item['actif'] == 1 ? 'active':''}}" id="home{{$item['id']}}" role="tabpanel">
                                            <div class="card">
                                                <div class="card-block">
                                                    <div class="row">
                                                        
                                                        <div class="col-12 text-center mb-3">
                                                            <h3><strong>{{$item['plus']  ? $item['plus']:'00'}}%</strong></h3>
                                                            <p>Taux De Réussite</p>
                                                            <hr class="mx-3 my-0">
                                                        </div>
                                                        <!--  -->
                                                        @if (count($item['data']))    
                                                            <div class="col-xl-4 col-md-12">
                                                                <div class="card-header pl-0">
                                                                    <h4></h4>
                                                                    <div style="font-size: 17px; font-weight: bold; text-decoration: underline;">Statistique de Classe</div>
                                                                </div>
                                                                <table class="table table-bordered nowrap">
                                                                    <tbody>
                                                                        <tr>
                                                                            <td style="width: 30%">Moyenne de classe</td>
                                                                            <th class="text-center" style="width: 70%">{{$item['resultat']['moyenne'] ? $item['resultat']['moyenne'].'/20':null}} <!-- {{$item['resultat']['rang']}} --></th>
                                                                        </tr>
                                                                        <tr>
                                                                            <td style="width: 30%">Moyenne supérieur à 10</td>
                                                                            <th class="text-center" style="width: 70%">
                                                                                {{$item['resultat']['nbre_superieur'] <= 9 ? '0'.$item['resultat']['nbre_superieur']:$item['resultat']['nbre_superieur']}} soit 
                                                                                {{$item['resultat']['nbre_superieur'] ? round(($item['resultat']['nbre_superieur'] / $classe['inscrits'])*100):'0'}}%
                                                                            </th>
                                                                        </tr>
                                                                        <tr>
                                                                            <td style="width: 30%">Moyenne entre 9.99 et 8.50</td>
                                                                            <th class="text-center" style="width: 70%">
                                                                                {{$item['resultat']['nbre_entre'] <= 9 ? '0'.$item['resultat']['nbre_entre']:$item['resultat']['nbre_entre']}} soit 
                                                                                {{$item['resultat']['nbre_entre'] ? round(( $item['resultat']['nbre_entre'] / $classe['inscrits'])*100):'00'}}%
                                                                            </th>
                                                                        </tr>
                                                                        <tr>
                                                                            <td style="width: 30%">Moyenne inférieur à 8.50</td>
                                                                            <th class="text-center" style="width: 70%">
                                                                                {{$item['resultat']['nbre_inferieur'] <= 9 ? '0'.$item['resultat']['nbre_inferieur']:$item['resultat']['nbre_inferieur']}} soit 
                                                                                {{$item['resultat']['nbre_inferieur'] ? round(($item['resultat']['nbre_inferieur'] / $classe['inscrits'])*100):'00'}}%
                                                                            </th>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>

                                                            <div class="col-xl-4 col-md-12 px-0">
                                                                <div class="user-activity-card ml-1">
                                                                    <div class="card-header pl-0">
                                                                        <div style="font-size: 17px; font-weight: bold; text-decoration: underline;">Les Trois Prémiers</div>
                                                                    </div>
                                                                    <div style="border-left: 1px solid rgb(177, 174, 174)">
                                                                        @foreach ($item['data'] as $student)
                                                                        <div class="row mb-3">
                                                                            <div class="col-auto p-r-0">
                                                                                <div class="u-img">
                                                                                    @if ($student['photo'])
                                                                                    <img src="{{asset('storage/'.$student['photo'])}}" alt="Photo" class="img-radius cover-img" style="height:40px; width:40px">
                                                                                    @else
                                                                                    <img src="{{asset($student['sexe'] == 'F' ? 'assets/images/stdt_w.png':'assets/images/stdt_m.png')}}" class="img-radius mx-0" alt="Icon" style="height:40px; width:40px">
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                            <div class="col">
                                                                                <h6 class="m-b-5" style="font-weight: bold;">{{strtoupper($student['first_name']).' '.ucwords($student['last_name'])}}</h6>
                                                                                <p class="text-muted m-b-0"><strong>{{$student['rang']}}</strong> avec <strong>{{$student['moyenne']}}</strong> de moyenne.</p>
                                                                            </div>
                                                                        </div>
                                                                        @endforeach
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="col-xl-4 col-md-12">
                                                                <div class="card-header pl-0">
                                                                    <h4></h4>
                                                                    <div style="font-size: 17px; font-weight: bold; text-decoration: underline;">Pourcentage Des Elèves</div>
                                                                </div>
                                                                <table class="table table-bordered nowrap">
                                                                    <thead>
                                                                        <tr>
                                                                            <th style="width:20%"></th>
                                                                            <th class="text-center">Fille</th>
                                                                            <th class="text-center">Garçon</th>
                                                                            <th class="text-center">Total</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <tr>
                                                                            <td>Moyenne < 10</td>
                                                                            <th class="text-center">{{$item['sexeF9'] ? $item['sexeF9']:'00'}}%</th>
                                                                            <th class="text-center">{{$item['sexeM9'] ? $item['sexeM9']:'00'}}%</th>
                                                                            <th class="text-center">{{$item['moins'] ? $item['moins']:'00'}}%</th>
                                                                        </tr>
                                                                        <tr>
                                                                            <td>Moyenne > = 10</td>
                                                                            <th class="text-center">{{$item['sexeF10'] ? $item['sexeF10']:'00'}}%</th>
                                                                            <th class="text-center">{{$item['sexeM10'] ? $item['sexeM10']:'00'}}%</th>
                                                                            <th class="text-center">{{$item['plus'] ? $item['plus']:'00'}}%</th>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                            {{-- <div class="col-12 text-center">
                                                                <b class="my-2" id="monTexte">{{$student->classe->type == 'technique' ? ucwords(appreciationTechnique($resultat->moyenne)):ucwords(appreciationGeneral($resultat->moyenne))}}</b>
                                                                <p>Appréssiation de la classe</p>
                                                            </div> --}}
                                                        @else
                                                        <div class="col-12 text-center my-3">
                                                            <span class="text-center">
                                                                Information non disponible pour le moment ...
                                                            </span>
                                                        </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        @endforeach
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>

    <script>
        $(document).ready(function(){

            var currentUrl = window.location.href;
            let debutUrl = currentUrl.split("resultat");

            $('#btnLink').attr('href', debutUrl[0]+'resultat/list/'+{{$classe->id}}+'_'+$("#active").data('id'));
            $('.nav-link').on('click', function(){
                $('#btnLink').attr('href', debutUrl[0]+'resultat/list/'+{{$classe->id}}+'_'+$(this).data('id'));
            });


            new CircleType(document.getElementById('monTexte')).radius(200);

        })
    </script>
@endsection