<?php

namespace App\Jobs;

use App\Models\Inscription;
use App\Models\MoyenneMatiere;
use App\Models\MoyenneSubMatter;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class CalculMoyenneFrenchCycle1 implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $cutting; 
    protected $student;
    protected $matter;
    /**
     * Create a new job instance.
     */
    public function __construct($student, $cutting, $matter)
    {
        $this->student = $student;
        $this->cutting = $cutting;
        $this->matter = $matter;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $dts = getClassement($this->calculMoyenneStudent());
        foreach($dts as $item){
            $existe = MoyenneMatiere::where('inscription_id', $item['id'])->where('level_matter_id', $this->matter)->where('cutting_school_year_id', $this->cutting)->first();
            if($existe){
                $existe->update([
                    'moyenne' => $item['moyen'],
                    'rang' => $item['rang']
                ]);
            }
            else{
                $this->saveDataNew($item['id'], $item['moyen'], $item['rang']);
            }
        }
    }

    /**
     * Calcul de moyene pour chaque eleves.
     */
    protected function calculMoyenneStudent()
    {
        $tabs = [];
        foreach($this->student as $item){
            $tabs[] = [
                'moyen' => moyenneFrenchcycle1($this->subMoyennes($item)),
                'id' => $item,
                'sexe' => Inscription::find($item)['student']['sexe']
            ];
        }
        return $tabs;
    }

    /**
     *Get liste sous note the specified resource from storage.
     */
    protected function subMoyennes($student)
    {
        $tab[] = $this->getSubMoyenne($student, 1); // Composition Française
        $tab[] = $this->getSubMoyenne($student, 2); // Orthographe - Grammaire
        $tab[] = $this->getSubMoyenne($student, 3); // Expression Orale
        return $tab;
    }


    protected function getSubMoyenne($student, $item)
    {
        $val = MoyenneSubMatter::where('inscription_id', $student)->where('sub_matter_id', $item)->where('cutting_school_year_id', $this->cutting)->first();
        return $val ? [$val['moyenne'], $val['coefficient']]:'nc';
    }


    protected function saveDataNew($student, $moyenne, $rang)
    {
        MoyenneMatiere::create([
            'inscription_id' => $student,
            'level_matter_id' => $this->matter,
            'cutting_school_year_id' => $this->cutting,
            'moyenne' => $moyenne,
            'rang' => $rang
        ]);
    }
}
