<?php

namespace App\Imports;

use App\Models\GetNote;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToArray;
use Maatwebsite\Excel\Concerns\OnFailure;
use Maatwebsite\Excel\Concerns\WithHeadingRow;


class ListClassStudentNoteImport implements ToArray, WithHeadingRow 
{
    protected $class;
    protected $eval;

    public function __construct($class, $eval)
    {
        $this->classe_id = $class;
        $this->eval_id = $eval;
    }

    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function array(array $data)
    {
        foreach($data as $item){
            $student = explode('_', $item['id']);
            if($student[0] == $this->classe_id && $student[2] == $this->eval_id){
                GetNote::create([
                    'note' => is_null($item['note']) ? 'nc':($item['note'] <= 9 ? '0'.$item['note']:$item['note']),
                    'inscription_id' => $student[1],
                    'evaluation_id' => $student[2]
                ]);
            }
        }
    }
    
}
