<?php

namespace App\Http\Controllers;
use App\Models\User;
use App\Models\Role;
use App\Models\Level;
use App\Models\Setting;
use App\Models\MatterUser;
use App\Models\SchoolMatter;
use App\Jobs\SendMailJob;
use App\Imports\UserExcelImport;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        try{
            $profs = User::where('role_id', '6')->where('status', '1')
            ->where('school_id', auth()->user()->school_id)
            ->orderBy('first_name', 'ASC')->orderBy('last_name', 'ASC')
            ->get();
            return view('pages.users.index', ['profs' => $profs]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Display a listing of the resource.
     */
    public function index1()
    {
        try{
            $users = User::where('role_id', '!=', '6') // Id du role Enseignant .....
            ->where('status', '1')
            ->where('school_id', auth()->user()->school_id)
            ->orderBy('first_name', 'ASC')->orderBy('last_name', 'ASC')
            ->get();
            return view('pages.users.index1', ['users' => $users]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    public function inactif()
    {
        try{
            $datas = User::where('status', '0')
            ->where('school_id', auth()->user()->school_id)
            ->orderBy('first_name', 'ASC')->orderBy('last_name', 'ASC')
            ->get();
            return view('pages.users.inactive', ['datas' => $datas]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function download(){
        try{
            $filename = 'add_enseignant.xlsx';
            return response()->download(storage_path('app/public/download/'.$filename));
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function import(Request $request)
    {
        try{
            $request->validate(['files' => 'required|mimes:xlsx']);
            $school = Setting::where('school_id', auth()->user()->school_id)->first();
            $role = Role::where('id', 6)->first(); // Profil Enseignant
            Excel::import(new UserExcelImport(auth()->user()->school_id, $role->id), $request->file('files'));
            return redirect()->route('user.index')->with([
                'str' => 'info',
                'msg' => 'Importation réussie !'
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        try{
            return view('pages.users.create', [
                'disciplies' => $this->getMatters(),
                'role' => Role::where('role', 'enseignant')->first(),
                'user' => null
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create1()
    {
        try{
            return view('pages.users.create1', [
                'role' => $this->getRole(),
                'user' => null
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue.'
            ]);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'profilUser' => 'required|integer',
            'firstNameUser' => 'required|string',
            'latsNameUser' => 'required|string',
            'sexeUser' => 'required|string',
            'mailUser' => 'required|email|unique:users,email',
            'numUser' => 'required|numeric|unique:users,telephon',
            'matrimonialUser' => 'required|string',
            'typeEmbauche' => 'nullable|string',
        ]);

        if(($request['enseignant'] == 'professeur') && !$request['discips']){
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }

        /** @var UploadedFile $img */ 
        if($request->img){
            $img = $request->validate(['img' => 'image', 'mimes:jpg,png,jpeg']);
            $name =  explode('@', $request['mailUser'])[0].auth()->user()->school_id.'.png';
            $path = $img['img']->storeAs('user', $name, 'public');
        }

        // Générer un mot de passe pour l'utilisateur de 6 caractères au moins.
        // $mpd = generatePwd();
        $mpd = '000000'; // Mot de passe par defaut 

        // Save User.
        $user = User::create([
            'role_id' => $validated['profilUser'],
            'first_name' => $validated['firstNameUser'],
            'last_name' => $validated['latsNameUser'],
            'sexe' => $validated['sexeUser'],
            'email' => $validated['mailUser'],
            'telephon' => $validated['numUser'],
            'residence' => $request['residence'],
            'matrimoniale' => $validated['matrimonialUser'],
            'embauche' => $validated['typeEmbauche'] ?? null,
            'typeEnseignant' => $validated['profilUser'] == 6 ? $request['enseignant']:null,
            'type_enseignement_id' => $request['type_id'] ?? null,
            'level_id' => $validated['profilUser'] == 5 ? $request['level_id']:null,
            'autorisation' => $request['auto'],
            'num_autorisation' => $request['numAuto'] ?? null,
            'date_autorisation' => $request['dateAuto'] ?? null,
            'diplome' => $request['diplome'] ?? null,
            'photo'  => $path ?? null,
            'school_id' => auth()->user()->school_id,
            'password' => Hash::make($mpd),
            'remember_token' => Str::random(10),
        ]);

        if($request['discips'] && ($user && $user['role_id'] == 6)){
            $this->createUserMatter($user->id, $request['discips']);
        }
        // $url = explode("user", url()->previous())[0].'login';
        // dispatch(new SendMailJob($user, $mpd, $url));

        // Redirection sur la liste des établissement
        return to_route($user['role_id'] == 6 ? 'user.index':'user.index1')->with([
            'str' => 'success',
            'msg' => 'Enregistrement effectué !'
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        try{
            $user = User::find($id);
            return view('pages.users.detail', ['user' => $user]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        try{
            $user = User::find($id);
            return view($user['role_id'] != 6 ? 'pages.users.create1':'pages.users.create', [
                'disciplies' => $this->getMatters(),
                'role' => $user['role_id'] != 6 ? $this->getRole():Role::where('role', 'enseignant')->first(),
                'user' => $user
            ]);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'profilUser' => 'required|string',
            'firstNameUser' => 'required|string',
            'latsNameUser' => 'required|string',
            'sexeUser' => 'required|string',
            'mailUser' => 'required|email',
            'numUser' => 'required|numeric',
            'matrimonialUser' => 'nullable|string',
            'typeEmbauche' => 'nullable|string',
            'status' => 'nullable|string',
        ]);

        if(($request['enseignant'] == 'professeur') && !$request['discips']){
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }

        $user = User::find($id);

        /** @var UploadedFile $img */ 
        if($request->img){
            $img = $request->validate(['img' => 'image', 'mimes:jpg,png,jpeg']);
            if ($user->photo && Storage::exists('app/public/user/'.$user->photo)) {
                Storage::delete('app/public/user/'.$user->photo);
            }
            $name = explode('@', $request['mailUser'])[0].auth()->user()->school_id.'.png';
            $file = $img['img']->storeAs('user', $name, 'public');
        }

        // Save update info user
        $user->update([
            'role_id' => $validated['profilUser'],
            'first_name' => $validated['firstNameUser'],
            'last_name' => $validated['latsNameUser'],
            'sexe' => $validated['sexeUser'],
            'email' => $validated['mailUser'],
            'telephon' => $validated['numUser'],
            'residence' => $request['residence'],
            'matrimoniale' => $validated['matrimonialUser'],
            'embauche' => $validated['typeEmbauche'] ?? null,
            'autorisation' => $request['auto'],
            'num_autorisation' => $request['numAuto'] ?? null,
            'date_autorisation' => $request['dateAuto'] ?? null,
            'diplome' => $request['diplome'] ?? null,
            'photo'  => $file ?? $user->photo,
            'status' => $validated['status'] ? '1':'0',
        ]);

        if($request['discips'] && ($user && $user['role_id'] == 6)){
            $this->createUserMatter($user->id, $request['discips']);
        }

        // Redirection sur la liste des établissement
        return to_route($user['role_id'] == 6 ? 'user.index':'user.index1')->with([
            'str' => 'info',
            'msg' => 'Modification prise en compte'
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function search(Request $request){
        try{
            $user = User::where('id', $request['data'])->first();
            $tab = [
                'nom' => strtoupper($user->first_name),
                'prenom' => ucfirst($user->last_name),
                'role' => ucfirst($user->role->role)
            ];
            return response()->json($tab);
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }



    public function searchAjax(Request $request){
        $setting = Setting::where('school_id',auth()->user()->school_id)->first();
        $verify = $this->existTypeEnseignement($setting->school->typeEnseignements);
        $typeEnseig = $request['val'] == 7 ? $this->typeEnseignement($setting->school->typeEnseignements):(count($verify) == 2 ? $verify:null);
        return response()->json([
            'type' => $typeEnseig,
            'level' => count($verify) == 1 ? $this->getDataLevel($verify[0]['id']):null
        ]);
    }


    public function getlevel(Request $request){
        return response()->json($this->getDataLevel($request['val']));
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        try{
            $user = User::Where('id',$id)->where('school_id', auth()->user()->school_id)->fisrt();
            if ($user) {
                if ($user->photo && Storage::exists('app/public/user/'.$user->photo)) {
                    Storage::delete('app/public/user/'.$user->photo);
                }
                $user->delete();
                return back()->with([
                    'str' => 'info',
                    'msg' => 'Utilisateur supprimé avec succès !'
                ]);
            } 
        }
        catch (\Exception $e) {
            return back()->with([
                'str' => 'danger',
                'msg' => 'Une erreur est survenue !'
            ]);
        }
    }


    private function existTypeEnseignement($datas){
        $dts = [];
        foreach($datas as $item){
            if($item->id == 4 || $item->id == 5){
                $dts[] = [
                    'id' =>  $item->id,
                    'libelle' => ucwords( $item->id == 5 ? $item->type_enseignement:'Secondaire ('.verifySeconde($datas).')')
                ];
            }
        }
        return $dts;
    }



    private function getDataLevel($val)
    {
        if($val == 5){
            $data = Level::where('type_enseignement_id', '4')->where('status', '1')->get();
        }
        else{
            $data = Level::where('type_enseignement_id', '3')->orWhere('type_enseignement_id', '4')->where('status', '1')->get();
        }

        return $data;
    }



    private function typeEnseignement($datas)
    {
        $dts = []; $exist = 0;
        foreach($datas as $item){
            if(!$exist && ($item->id == 3 || $item->id == 4)){
                $dts[] = [
                    'id' =>  $item->id,
                    'libelle' => 'Secondaire ('.verifySeconde($datas).')'
                ];
                $exist++;
            }
            elseif($item->id == 1 || $item->id == 2 || $item->id == 5 || $item->id == 6) {
                $dts[] = [
                    'id' =>  $item->id,
                    'libelle' => $item->type_enseignement
                ];
            }
        }
        return $dts;
    }


    private function getRole()
    {
        $setting = Setting::where('school_id',auth()->user()->school_id)->first();
        $roles = Role::where('role', '<>', 'superAdmin')->where('role', '<>', 'enseignant')->orderBy('role')->get();
        $vals = $this->verifyRole($setting->school->typeEnseignements);
        $tab = [];
        foreach($roles as $role){
            if(($role->role == 'surveillant') && in_array(6, $vals)){
                $tab[] = $role;
            }
            elseif(($role->role == 'educateur') && (in_array(3, $vals) || in_array(4, $vals) || in_array(5, $vals))){
                $tab[] = $role;
            }
            else{
                $tab[] = $role;
            }
        }
        return $tab;
    }


    private function createUserMatter($user, $matters){
        MatterUser::where('user_id', $user)->where('school_id', auth()->user()->school_id)->delete();
        $i = 0;
        while($i < sizeof($matters)){
            MatterUser::create([
                'user_id' => $user,
                'matter_id' => $matters[$i],
                'school_id' => auth()->user()->school_id
            ]);
            $i++;
        }
        return 'Bien joué';
    }


    private function getMatters(){
        return SchoolMatter::join('matters', 'matters.id', '=', 'school_matter.matter_id')
        ->where('school_matter.school_id', auth()->user()->school_id)
        ->where('matters.libelle', '!=', 'conduite')
        ->select('matters.*')->orderBy('matters.libelle', 'ASC')
        ->distinct()
        ->get();
    }


    private function verifyRole($vals)
    {
        $tabs = [];
        $i = 0;
        while($i < sizeof($vals)){
            $tabs[] = $vals[$i]['id'];
            $i++;
        }

        return $tabs;
    }
}