<?php $__env->startSection('title','time slot'); ?> 
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header my-0">
                                <div class="d-flex justify-content-between">
                                    <h4>Time Slot</h4>
                                    <div class="invoice-btn-group text-center">
                                        <?php if(!(count($morning) && count($after))): ?>
                                            <a href="<?php echo e(route('time_slot.create')); ?>" class="btn btn-inverse btn-outline-inverse py-1">Places horaire</a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <hr class="my-0 py-0">
                                <div class="card-block my-2">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="dt-responsive table-responsive">
                                                <table class="table table-striped table-bordered">
                                                    <thead>
                                                        <tr>
                                                            <th class="text-center" style="width: 10%">N°</th>
                                                            <th class="text-center">Libellé</th>
                                                            <th class="text-center">Debut</th>
                                                            <th class="text-center">Fin</th>
                                                            <th class="text-center">Actions</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php if(($morning && $after)): ?>
                                                            <?php $i = 1; ?>
                                                            <?php $__currentLoopData = $morning; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                                <td class="ml-3"><?php echo e($item['numero'] == 1 ? $item['numero'].'ère Heure':$item['numero'].'ème Heure'); ?></td>
                                                                <td class="text-center">
                                                                    <?php $dts = explode(':', $item['debut']);?> <?php echo e($dts[0].'h'.$dts[1]); ?>

                                                                </td>
                                                                <td class="text-center">
                                                                    <?php $dts = explode(':', $item['fin']);?> <?php echo e($dts[0].'h'.$dts[1]); ?>

                                                                </td>
                                                                <td class="text-center py-1">
                                                                    <button class="btn btn-sm btn-info text-center px-2 my-0 editTime" data-id="<?php echo e($item['id'].'_'.'1'); ?>" data-debut="<?php echo e($item['debut']); ?>" data-fin="<?php echo e($item['fin']); ?>"  title="Edit" data-toggle="modal" data-target="#editModal"><i class="fas fa-edit m-0"></i></button>
                                                                </td>
                                                            </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <th colspan="5" class="text-center py-2">
                                                                    <div class="d-flex justify-content-between">
                                                                        <span>- - - - - - - - - -</span>
                                                                        <span>- - - - - - - - - -</span>
                                                                        <span>- - - - - - - - - -</span>
                                                                        <span>- - - - - - - - - -</span>
                                                                        <span>- - - - - - - - - -</span>
                                                                    </div>
                                                                </th>
                                                            </tr>
                                                            <?php $__currentLoopData = $after; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                                <td class="ml-3"><?php echo e($item['numero'] == 1 ? $item['numero'].'ère Heure':$item['numero'].'ème Heure'); ?></td>
                                                                <td class="text-center">
                                                                    <?php $dts = explode(':', $item['debut']);?> <?php echo e($dts[0].'h'.$dts[1]); ?>

                                                                </td>
                                                                <td class="text-center">
                                                                    <?php $dts = explode(':', $item['fin']);?> <?php echo e($dts[0].'h'.$dts[1]); ?>

                                                                </td>
                                                                <td class="text-center py-1">
                                                                    <button class="btn btn-sm btn-info text-center px-2 my-0 editTime" data-id="<?php echo e($item['id'].'_'.'2'); ?>" data-debut="<?php echo e($item['debut']); ?>" data-fin="<?php echo e($item['fin']); ?>"  title="Edit" data-toggle="modal" data-target="#editModal"><i class="fas fa-edit m-0"></i></button>
                                                                </td>
                                                            </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php else: ?>
                                                            <tr>
                                                                <th colspan="5" class="text-center py-3">Données Introuvables</th>
                                                            </tr>
                                                        <?php endif; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal Edit Classe -->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="editModalLabel">Edit Time Slot</h5>
          <strong id="libEtid" style="font-size: 19px"></strong>
        </div>
        <form action="<?php echo e(route('time_slot.update')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-body">
                <input type="hidden" name="id" id="id" value="">
                <div class="form-group mb-3">
                    <label class="col-form-label" for="debut">Heure Debut<span class="text-danger">*</span> :</label>
                    <input type="time" name="debut" id="debut" class="form-control" value="">
                </div>
                <div class="form-group mb-3">
                    <label class="col-form-label" for="fin">Heure Fin<span class="text-danger">*</span> :</label>
                    <input type="time" name="fin" id="fin" class="form-control" value="">
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){

            // Edit Classe .......................................
            $('.editTime').on('click', function() {
                $('#id').val($(this).data('id'));
                $('#debut').val($(this).data('debut'));
                $('#fin').val($(this).data('fin'));
            });


        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/v4-test/app_v4_teste/resources/views/pages/time_slot/index.blade.php ENDPATH**/ ?>