<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="Educas est une application de gestion d'ecole dans son ensemble">
    <meta name="author" content="Jean-Marius Yao">
    <title>Emploi du temps <?php echo e($class->libelle); ?></title>
</head>
<style>
    body {
        font-size: .875em;
        overflow-x: hidden;
        color: #353c4e;
        font-family: "Open Sans", sans-serif;
    }

    /* applies border to the table */
    #tabled,th,td {
        border: 1px solid #dee2e6;
        padding: 10px;
        text-align: center
    }

    #tabled {
        width: 100%;
        border: 1px solid #dee2e6;
        border-collapse: collapse;
        table-layout: auto;
        border-spacing: 2px;
    }

    th, td {
        white-space: nowrap;
    }
</style>
<body>
    <header style="margin: 5px auto; border-bottom: 1px solid #dee2e6; height: 100px; padding-bottom: 15px">
        <div style="display: flex; flex-direction: row; justify-content: space-between;">
            <table style="width: 100%">
                <tbody>
                    <tr style="margin-bottom: 0%">
                        <td style="width: 50%; border:none">
                            <div style="text-align: center; font-size: 8px">Ministère de l'Education Nationale, de l'Enseignement <br> Technique et de la   Formation Professionnelle</div>
                        </td>
                        <td style="width: 50%; border:none">
                            <div style="text-align: center; font-size: 8px;">
                                <b >REPUBLIQUEDE COTE D'IVOIRE</b><br>
                                <i>Union - Discipline - Travail</i>
                            </div>
                        </td>
                    </tr>
                    <tr style="margin-bottom: 0%">
                        <td style="width: 40%; border:none">
                            <img src="<?php echo e(public_path($school->logoUrl())); ?>" class="m-b-10 w-100" alt="Logo établissement" style="height: 55px;">
                        </td>
                        <td style="width: 60%; border:none">
                            <div style="text-align: center">
                                <div style="text-align: center;">
                                    <b style="font-size: 15px;"><?php echo e(mb_strtoupper($school->school->name_school)); ?></b><br>
                                    <i style="font-size: 9px"><?php echo e($school->address_email); ?> / <?php echo e($school->phon_school); ?></i><br>
                                    <i style="font-size: 11px;">Année Scolaire : <b><?php echo e($class->schoolYear->school_year); ?></i>
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </header>
    
    <section style="margin: 5px auto;">
        <div style="margin-top: 20px">
            <div style="margin-top: 35px; text-align: center; font-size:21px; text-decoration: underline;">
                <b>EMPLOI DU TEMPS CLASSE : <?php echo e($class->libelle); ?></b>
            </div>
            <table id="tabled" style="margin-top: 25px">
                <thead>
                    <tr style="display: table-row; vertical-align: inherit; unicode-bidi: isolate; border-color: inherit;">
                        <th>Horaires</th>
                        <?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th><?php echo e(ucfirst($day['day'])); ?></th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $morning; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mrg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($mrg['debut']); ?> - <?php echo e($mrg['fin']); ?></td>
                        <?php for($i = 0; $i < count($days); $i++): ?>
                        <td>
                            <?php $__currentLoopData = $dtsMrg; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item['ligne'] == $i+1 ? ($item['morning_time_id'] == $mrg['id'] ? $item->matter['abbreviated'] ?? $item->matter['libelle']:null):null); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <?php endfor; ?>
                    </tr> 
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr style="letter-spacing: 1rem; font-size: 15px">
                        <th colspan="<?php echo e(count($days)+1); ?>" class="text-center py-2">APRES - MIDI</th>
                    </tr>
                    <?php $__currentLoopData = $after; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $atr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($atr['debut']); ?> - <?php echo e($atr['fin']); ?></td>
                        <?php for($i = 0; $i < count($days); $i++): ?>
                        <td>
                            <?php $__currentLoopData = $dtsAfter; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item['ligne'] == $i+1 ? ($item['after_noon_time_id'] == $atr['id'] ? $item->matter['abbreviated'] ?? $item->matter['libelle']:null):null); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <?php endfor; ?>
                    </tr> 
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </section>
</body>
</html><?php /**PATH /home/educasnsa/public_html/v4-test/app_v4_teste/resources/views/pdf/emploi_temps.blade.php ENDPATH**/ ?>