<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="Educas est une application de gestion d'ecole dans son ensemble">
    <meta name="author" content="Jean-Marius Yao">
    <title><?php echo e('liste_moyenne_'.$decoup->cutting->libelle.'_'.$class->libelle); ?></title>
</head>
<style>
    @page {
        margin: 0cm; /* Supprime toutes les marges */
    }

    body {
        margin: 0cm;
        padding: 0cm;
        font-size: .875em;
        overflow-x: hidden;
        color: #353c4e;
        font-family: sans-serif;
    }

    /* applies border to the table */
    #tabled,th,td {
        border: 1px solid #dee2e6;
        padding: 10px;
        text-align: center
    }

    #tabled {
        width: 100%;
        border: 1px solid #dee2e6;
        border-collapse: collapse;
        table-layout: auto;
        border-spacing: 2px;
    }

    th, td {
        white-space: nowrap;
    }
</style>
<body>
    <header style="margin: 5px auto; border-bottom: 1px solid #dee2e6; height: 100px; padding-bottom: 15px">
        <div style="display: flex; flex-direction: row; justify-content: space-between;">
            <table style="width: 100%">
                <tbody>
                    <tr style="margin-bottom: 0%">
                        <td style="width: 50%; border:none">
                            <div style="text-align: center; font-size: 8px">Ministère de l'Education Nationale, de l'Enseignement <br> Technique et de la   Formation Professionnelle</div>
                        </td>
                        <td style="width: 50%; border:none">
                            <div style="text-align: center; font-size: 8px;">
                                <b >REPUBLIQUEDE COTE D'IVOIRE</b><br>
                                <i>Union - Discipline - Travail</i>
                            </div>
                        </td>
                    </tr>
                    <tr style="margin-bottom: 0%">
                        <td style="width: 40%; border:none">
                            <img src="<?php echo e(public_path($school->logoUrl())); ?>" class="m-b-10 w-100" alt="Logo Etablissement" style="height: 55px;">
                        </td>
                        <td style="width: 60%; border:none">
                            <div style="text-align: center">
                                <div style="text-align: center;">
                                    <b style="font-size: 15px;"><?php echo e(mb_strtoupper($school->school->name_school)); ?></b><br>
                                    <i style="font-size: 9px"><?php echo e($school->address_email); ?> / <?php echo e($school->phon_school); ?></i><br>
                                    <i style="font-size: 11px;">Année Scolaire : <b><?php echo e($class->schoolYear->school_year); ?></i>
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </header>
    
    <section style="margin: 5px auto;">
        <div style="margin-top: 20px">
            <div style="margin-top: 35px; text-align: center; font-size:21px; text-decoration: underline;">
                <b>Moyenne <?php echo e(strtoupper($decoup->cutting->libelle)); ?> <?php echo e($class->libelle); ?></b>
            </div>
            <table id="tabled" style="margin-top: 25px">
                <thead>
                    <tr>
                        <th class="text-center" style="width: 3%">N°</th>
                        <th class="text-center text-uppercase">Nom & Prénoms</th>
                        <th class="text-center text-uppercase">Sexe</th>
                        
                        <?php $__currentLoopData = $matters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $matter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th class="text-center text-uppercase"><?php echo e($matter['abbreviated'] ?? $matter['libelle']); ?></th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <th class="text-center text-uppercase">Moy</th>
                        <th class="text-center text-uppercase">Rang</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; ?>
                    <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                        <td style="text-align: left"><?php echo e(Str::limit($data['name'], 20, '...')); ?></td>
                        <td class="text-center"><?php echo e($data['sexe']); ?></td>
                        
                        <?php $__currentLoopData = $data['moyens']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $moyen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td class="text-center"><?php echo e($moyen ? $moyen['moyenne']:'nc'); ?></td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <th class="text-center"><?php echo e($data['moyen']); ?></th>
                        <td class="text-center"><?php echo e($data['rang']); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </section>
</body>
</html><?php /**PATH /home/educasnsa/public_html/v4-test/app_v4_teste/resources/views/pdf/list_moyenne.blade.php ENDPATH**/ ?>