<?php $__env->startSection('title', 'Gestion des appels'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4>Gestion des Appels</h4>
                                </div>
                            </div>
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left <?php echo e(session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?> menuStep" id="<?php echo e(session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?>" data-lib="<?php echo e($item['libelle']); ?>" data-toggle="tab" href="#home<?php echo e($item['nbre']); ?>" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i><?php echo e(ucfirst($item['libelle'])); ?> [<?php echo e(count($item['data']) <= 9 ? '0'.count($item['data']):count($item['data'])); ?>]
                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="tab-pane <?php echo e(session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?>" id="home<?php echo e($item['nbre']); ?>" role="tabpanel">
                                            <table id="<?php echo e($item['tab']); ?>" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="width: 3%">N°</th>
                                                        <th class="text-center">Libelle</th>
                                                        <th class="text-center">Effectif</th>
                                                        <th class="text-center" style="width: 20%">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $i = 1; ?>
                                                    <?php $__currentLoopData = $item['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                        <td class="text-center">
                                                            <?php echo e(ucfirst($val['libelle'])); ?>

                                                        </td>
                                                        <td class="text-center"><?php echo e($val['inscrits'] <= 9 ? '0'.$val['inscrits']:$val['inscrits']); ?>/<?php echo e($val['effectif'] <= 9 ? '0'.$val['effectif']:$val['effectif']); ?></td>
                                                        <td style="width: 20%" class="py-1">
                                                            <div class="card-block remove-label m-0 p-0 text-center">
                                                                <?php if($val['type'] == 'primaire'): ?>
                                                                <a href="<?php echo e(route('appel.primary',$val['id'])); ?>" class="editEval btn btn-sm btn-warning text-center px-2" title="Détails primaire"><i class="fas fa-paste m-0"></i></a>
                                                                <?php else: ?>
                                                                <button class="btn btn-sm btn-warning text-center px-2 detailGet" title="View list" data-id="<?php echo e($val['id']); ?>" data-toggle="modal" data-target="#matierModal"><i class="fas fa-paste m-0"></i></button>
                                                                <?php endif; ?>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="matierModal" tabindex="-1" role="dialog" aria-labelledby="matierModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="matierModalLongTitle">Choise matter</h5>
        </div>
        <form action="<?php echo e(route('appel.show')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <?php echo method_field('get'); ?>
            <div class="modal-body">
                <div class="m-b-30 mt-3">
                    <label for="seletMatter">Select one matter<span class="text-danger">*</span> : </label>
                    <select name="select" class="form-control" id="seletMatter">
                        
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){

            $(document).on('click', '.detailGet', function() {
                $('.matter').remove();
                $id = $(this).data('id');
                if($id){
                    $.ajax({
                        url: '<?php echo e(route('evaluation.matiere')); ?>',
                        method: 'GET',
                        data: { id: $id },
                        success: function(data){
                            $('div#matierModal').fadeIn();
                            if(data.length){
                                $i = 0;
                                while ($i < data.length) {
                                    $('#seletMatter').append('<option value="'+data[$i].id+'_'+$id+'" class="matter" title="'+data[$i].libelle+'">'+data[$i].abbreviated+'</option>');
                                    $i++;
                                }
                            }
                            else{
                                $('#seletMatter').append('<option class="matter">Matière non disponible !</option>');
                            }
                        }
                    });
                }
            });
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/v4-test/app_v4_teste/resources/views/pages/appels/index.blade.php ENDPATH**/ ?>