<?php $__env->startSection('title', 'Gestion des classes'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4>Liste de classe</h4>
                                    <p class="m-0"><strong><?php echo e($classe['libelle']); ?></strong> [<?php echo e(count($data)<= 9 ? '0'.count($data):count($data)); ?> élèves]</p>
                                    <div class="right">
                                        
                                        <span style="float: right">
                                            <?php if(in_array($classe['type'], ['secondaire', 'technique'])): ?>
                                                <a href="<?php echo e(route('conduite.index',$classe['id'])); ?>" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mr-2" title="Generate Conduite"><i class="fas fa-book-reader m-0"></i></a>
                                            <?php endif; ?>
                                            <a href="<?php echo e(route('sanction.index')); ?>" class="btn btn-inverse btn-outline-inverse btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <hr class="mx-3 mt-0">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <table id="simpletable"
                                        class="table table-striped table-bordered nowrap">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="width: 5%">N°</th>
                                                <th style="width: 22%">Nom et Prenoms</th>
                                                <th style="width: 12%">Genre</th>
                                                <th style="width: 12%">Matricule</th>
                                                <th style="width: 12%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $i = 1; ?>
                                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                <td><?php echo e(mb_strtoupper($item['first_name']).' '.ucfirst($item['last_name'])); ?></td>
                                                <td><?php echo e(ucfirst($item['sexe'] == 'F' ? 'Féminin':'Masculin')); ?></td>
                                                <td><?php echo e($item['matricule']); ?></td>
                                                <td class="py-1">
                                                    <div class="card-block remove-label m-0 p-0 text-center">
                                                        <a href="<?php echo e(route('sanction.create', $item['id'])); ?>" class="btn btn-sm btn-info text-center px-2" title="Détail sanctions"><i class="fas fa-align-left m-0"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/js/data-table-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){
           
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/v4-test/app_v4_teste/resources/views/pages/sanction/detail.blade.php ENDPATH**/ ?>