@extends('app')
@section('title','List student')
@section('link')
    <!-- Data Table Css -->
    <link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
    <link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/extensions/autofill/css/autoFill.dataTables.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/extensions/autofill/css/select.dataTables.min.css')}}">
    <style>
        .dataTables_length label{
            display: none;
        }
    </style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between mb-2">
                                    <h4>Etablissement non Disponible - {{count($schools) <= 9 ? '0'.count($schools):count($schools)}}</h4>
                                    <span>
                                        <a href="{{route('dashboard')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="mx-3 my-0">
                            <div class="card-block my-0">
                                <div class="dt-responsive table-responsive">
                                    <table id="key-intergration" class="table table-striped table-bordered nowrap" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="width: 8%">N°</th>
                                                <th style="width: 32%">Etablissement</th>
                                                <th style="width: 20%">Numéro Autorisation</th>
                                                <th style="width: 20%">Code Etablissement</th>
                                                <th class="text-center" style="width: 20%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $i = 1 @endphp
                                            @foreach ($schools as $school)
                                            <tr>
                                                <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                <td>{{ucfirst($school->name_school)}}</td>
                                                <td>{{ucfirst($school->num_autorisation)}}</td>
                                                <td>{{ucfirst($school->code_school)}}</td>
                                                <td>
                                                    <div class="card-block remove-label m-0 p-0 text-center">
                                                        <a href="{{route('school.edit',$school->id)}}" class="btn btn-sm btn-info text-center px-2"><i class="far fa-edit mx-0"></i></a>
                                                        <button class="getIdButton btn btn-sm btn-danger text-white text-center px-2" data-id="{{$school->id}}" data-toggle="modal" data-target="#deleteModalCenter"><i class="far fa-trash-alt mx-0"></i></button>
                                                    </div>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="deleteModalCenter" tabindex="-1" role="dialog" aria-labelledby="deleteModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-dark py-2">
                <h5 class="modal-title" id="deleteModalLongTitle">Delete School</h5>
            </div>
            <div class="modal-body">
            <div class="row">
                <div class="col-12 text-center">
                    <p class="my-0">
                        <strong>Suppression définitive.</strong>
                    </p>
                    <span>Cliquez Sur Le 'Valider' Pour Achéver Cette action.</span>
                </div>
            </div>
            </div>
            <form method="post" id="myForm">
                @csrf
                @method('delete')
                <div class="modal-footer">
                    <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                    <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/jszip.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/pdfmake.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/vfs_fonts.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.select.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/extensions-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){

            $urls = window.location.href;
            $url = $urls.split('school');

            $('.getIdButton').click(function() {
                $id = $(this).data('id');
                $('#myForm').attr('action', $url[0]+'school/destroy/'+$id);
            });
        })
    </script>
@endsection