@extends('app')
@section('title', 'School year')
@section('link')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-2">
                                    <h4>Découpage pour {{$item}}</h4>
                                    <span class="form-control-variant">Les champ avec asterisk (<code>*</code>) sont obligatoires.</span>
                                    <span>
                                        <a href="{{route('decoupage.index',$item)}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            <div class="card-block my-3">
                                <form action="{{route($data[0]->cutting ? 'decoupage.update':'decoupage.store',$data[0]->cutting ? ['str' => $item, 'id' => $data[0]->cutting_id]:$item)}}" method="post">
                                    @csrf
                                    @method($data[0]->cutting ? 'put':'post')
                                    <div class="form-group row my-3">
                                        <div class="col-12">
                                            <div class="card-block">
                                                <div class="table-responsive">
                                                    <table class="table  table-borderless">
                                                        <tbody>
                                                            <input type="hidden" name="type" value="{{$item}}">
                                                            @foreach ($data as $item)
                                                            <tr>
                                                                <th scope="row"></th>
                                                                <th>
                                                                    <div class="col-form-label">{{ucfirst($item->cutting ? $item->cutting->libelle:$item['libelle'])}}</div>
                                                                    <input type="hidden" name="decoupage{{$item->cutting ? '':'[]'}}" value="{{$item->cutting ? $item->cutting_id:$item['id']}}">
                                                                </th>
                                                                <td>
                                                                    <div class="form-group row m-0 p-0">
                                                                        <label class="col-sm-2 col-form-label" for="dateDebut_{{$item->cutting ? $item->cutting_id:$item['id']}}">Date debut<span class="text-danger">*</span> :</label>
                                                                        <div class="col-sm-10">
                                                                            <input type="text" name="dateDebut{{$item->cutting ? '':'[]'}}" id="dateDebut_{{$item->cutting ? $item->cutting_id:$item['id']}}" class="form-control form-control-normal bg-white m-0 @error('dateDebut') is-invalid @enderror" value="{{$item->cutting ? $item->start_date:''}}" placeholder="Date debute {{$item['libelle']}}">
                                                                            @error('dateDebut')
                                                                                <span class="form-bar text-danger" role="alert">
                                                                                    {{$message}}
                                                                                </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group row m-0 p-0">
                                                                        <label class="col-sm-2 col-form-label" for="dateFin_{{$item->cutting ? $item->cutting_id:$item['id']}}">Date fin<span class="text-danger">*</span> :</label>
                                                                        <div class="col-sm-10">
                                                                            <input type="text" name="dateFin{{$item->cutting ? '':'[]'}}" id="dateFin_{{$item->cutting ? $item->cutting_id:$item['id']}}" class="form-control form-control-normal bg-white m-0 @error('dateFin') is-invalid @enderror" value="{{$item->cutting ? $item->end_date:''}}" placeholder="Date fin {{$item['libelle']}}">
                                                                            @error('dateFin')
                                                                                <span class="form-bar text-danger" role="alert">
                                                                                    {{$message}}
                                                                                </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="text-center">
                                        <button type="submit" class="btn btn-inverse btn-outline-inverse py-2"> <i class="fas fa-check-circle"></i> Valider les informations</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/fr.js"></script>
<script src="{{asset('assets/js/pcoded.min.js')}}"></script>
<script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
<script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
<script>
    $(document).ready(function() {
        // Initialiser le date picker sur le champ avec l'ID 'datepicker'
        flatpickr(".form-control-normal", {
            locale: "fr",  // Utilise le français pour l'affichage
            dateFormat: "d-m-Y", // Format de la date
            altInput: true, // Afficher un format alternatif de la date
            altFormat: "d-m-Y", // Format alternatif pour afficher la date
        });

        var url = window.location.href; // Récupère l'URL actuelle
        var motRecherche = 'decoupage';
        if (url.indexOf(motRecherche) !== -1) {
            $('#idDecoup').addClass('pcoded-trigger')
        } 
    });
  </script>
@endsection