<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('origin_students', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('col_g_1')->nullable(); // Eleve Garçon Ivoirien
            $table->string('col_f_2')->nullable(); // Eleve Fille Ivoirienne
            $table->string('col_g_3')->nullable(); // Eleve Garçon Africain
            $table->string('col_f_4')->nullable(); // Eleve Fille Africainne
            $table->string('col_g_5')->nullable(); // Eleve Garçon Non-Africain
            $table->string('col_f_6')->nullable(); // Eleve Fille Non-Africain
            $table->string('col_g_7')->nullable(); // Total Eleve Garçon
            $table->string('col_f_8')->nullable(); // Total Eleve Fille
            $table->enum('order',[1,2,3,4,5,6,7,8,9,10]);
            $table->unsignedBigInteger('school_id');
            $table->unsignedBigInteger('school_year_id');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('school_year_id')->references('id')->on('school_years')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('origin_students');
    }
};
