<?php $__env->startSection('title', 'Gestion des classes'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-2">
                                    <div>
                                        <h4 class="m-0">Liste de classe <?php echo e($classe['libelle']); ?></h4>
                                        <p class="m-0">Effecif : <?php echo e((count($incrits)<= 9) ? '0'.count($incrits):count($incrits)); ?> - F : <?php echo e($fille); ?> - M : <?php echo e($garcon); ?></p>
                                    </div>
                                    <p class="m-0" style="font-size: 15px">
                                        <?php echo e($teacher ? ($teacher->user->sexe == 'F' ? ('Mde '.strtoupper($teacher->user->first_name).' '.ucwords($teacher->user->last_name)):('Mr. '.strtoupper($teacher->user->first_name).' '.ucwords($teacher->user->last_name))):'Non encore défini'); ?>

                                        
                                    </p>
                                    <div class="right">
                                        
                                        <span style="float: right">
                                            <?php if($classe['type'] == 'primaire'): ?>
                                            <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mr-2"  data-toggle="modal" data-target="#addModal" title="Add Teacher"><i class="fas fa-user m-0"></i></button>
                                            <?php endif; ?>
                                            <?php if(count($incrits)): ?>
                                            <a href="<?php echo e(route('classe.pdf',$classe->id)); ?>" target="_blank" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mr-2" title="Télécharger la liste"> <i class="fas fa-download mx-0"></i></a>
                                            <?php endif; ?>
                                            <a href="<?php echo e(route('classe.index')); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <hr class="mx-3 my-0">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <table id="simpletable"
                                        class="table table-striped table-bordered nowrap">
                                        <thead>
                                            <tr>
                                                <th style="width: 3%"></th>
                                                <th style="width: 22%">Nom et Prenoms</th>
                                                <th style="width: 12%">Genre</th>
                                                <th style="width: 12%">Date de nais...</th>
                                                <th style="width: 12%">Matricule</th>
                                                <?php if(!($classe['type'] == 'primaire')): ?>
                                                <th style="width: 12%">Affecté</th>
                                                <?php endif; ?>
                                                <th style="width: 12%">Redoublant</th>
                                                <?php if(!($classe['type'] == 'primaire')): ?>
                                                <th style="width: 12%">Boursier</th>
                                                <?php endif; ?>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $i = 1; ?>
                                            <?php $__currentLoopData = $incrits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                <td><?php echo e(mb_strtoupper($item->first_name).' '.ucfirst($item->last_name)); ?></td>
                                                <td><?php echo e(ucfirst($item->sexe == 'F' ? 'Féminin':'Masculin')); ?></td>
                                                <td><?php echo e($item->date_birth.' à '.ucfirst($item->place_birth)); ?></td>
                                                <td><?php echo e($item->matricule); ?></td>
                                                <?php if(!($classe['type'] == 'primaire')): ?>
                                                <td><?php echo e(ucfirst($item->affecte)); ?></td>
                                                <?php endif; ?>
                                                <td><?php echo e(ucfirst($item->redoublant)); ?></td>
                                                <?php if(!($classe['type'] == 'primaire')): ?>
                                                <td><?php echo e(ucfirst($item->boursier)); ?></td>
                                                <?php endif; ?>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- @Modal -->
<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="addModalTitle">Teacher management</h5>
          <span id="libelle" style="font-size: 18px"></span>
        </div>
        <form action="<?php echo e(route('classe.teacher')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-body">
                <input type="hidden" name="classe" value="<?php echo e($classe['id']); ?>">
                <div class="form-group mb-2">
                    <label class="col-form-label" for="teacher">Select Teacher<span class="text-danger">*</span> :</label>
                    <select name="teacher" id="teacher" class="form-control">
                        <option value="<?php echo e($teacher ? $teacher->user_id:null); ?>"><?php echo e($teacher ? (($teacher->user->sexe == "F" ? 'Mde. ':'Mr. ').strtoupper($teacher->user->first_name).' '.ucwords($teacher->user->last_name)):'Select One option'); ?></option>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($user->id); ?>"><?php echo e(($user->sexe == "F" ? 'Mde. ':'Mr. ').strtoupper($user->first_name).' '.ucwords($user->last_name)); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
              <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" id="formUrl">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/js/data-table-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){
           
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views\pages\classe\detail.blade.php ENDPATH**/ ?>