<?php $__env->startSection('title', 'Gestion des appels'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4>Frais Annexes</h4>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-toggle="modal" data-target="#addFraisModal" title="Add New Annex Fee"><i class="fas fa-exchange-alt m-0"></i></button>
                                    </span>                                
                                </div>
                            </div>
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left <?php echo e(session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?> menuStep" id="<?php echo e(session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?>" data-lib="<?php echo e($item['libelle']); ?>" data-toggle="tab" href="#home<?php echo e($item['nbre']); ?>" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i><?php echo e(ucfirst($item['libelle'])); ?>

                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="tab-pane <?php echo e(session('lib') ? (session('lib') == $item['libelle'] ? 'active':'' ):($item['nbre'] == 1 ? 'active':'')); ?>" id="home<?php echo e($item['nbre']); ?>" role="tabpanel">
                                            <table id="<?php echo e($item['tab']); ?>" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center">N°</th>
                                                        <th class="text-center">Libelle</th>
                                                        <th class="text-center">Montants</th>
                                                        <th class="text-center" style="width: 20%">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $i = 1; ?>
                                                    <?php $__currentLoopData = $item['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                        <td class="text-left pl-3">
                                                            <?php echo e($val['niveau'] == 1 ? 'Tout les niveaux':ucfirst($val->level->level)); ?>

                                                        </td>
                                                        <td class="text-center"><?php echo e(preg_replace('/\B(?=(\d{3})+(?!\d))/', ' ', $val->amount->montant)); ?> FR CFA</td>
                                                        <td style="width: 20%" class="py-1">
                                                            <div class="card-block remove-label m-0 p-0 text-center">
                                                                <button class="getDelet btn btn-sm btn-danger text-white text-center px-2" title="Delete" data-id="<?php echo e($val->id); ?>" data-amount="<?php echo e($val->amount->montant); ?>" data-toggle="modal" data-target="#deleteModalCenter"><i class="far fa-trash-alt"></i></button>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- @Modal -->
<div class="modal fade" id="addFraisModal" tabindex="-1" role="dialog" aria-labelledby="addFraisModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="addFraisModalLongTitle">Add Annex Fee</h5>
            <strong style="font-size: 17px"><?php echo e($year['school_year']); ?></strong>
        </div>
        <form action="<?php echo e(route('frais.store')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-body py-3">
                <input type="hidden" name="type" id="type">
                <input type="hidden" name="year" value="<?php echo e($year['id']); ?>">
                <div class="form-group pt-2">
                    <label for="amount" class="form-label">Montant<span class="text-danger">*</span> :</label>
                    <input type="text" id="amount" name="amount" class="form-control" placeholder="Entrez le montant ..." required>
                </div>
                <div class="form-group">
                    <label class="form-label">Montant pour tout les niveau :</label>
                    <span class="ml-3">
                        <input type="radio" id="oui" name="statut" value="oui" checked><label for="oui" class="mx-1">oui</label>
                        <input type="radio" id="non" name="statut" value="non"><label for="non" class="ml-1">non</label>
                    </span>
                </div>
                <div class="form-group mb-3" id="addLevel" style="display: none">
                    <label for="level" class="form-label text-muted"><span id="monText"></span> <span class="text-danger">*</span> :</label>
                    <select name="level" id="level" class="form-control select2 bg-white">
                        <option value="" class="text-muted">Selection one option</option>
                    </select>    
                </div>
                <div class="form-group" id="blockText" style="display: none">
                    <label for="checkbox">Gestion des séries </label> <input type="checkbox" class="mx-1" id="checkbox">
                </div>
                <div class="form-group mb-3" id="addSerie" style="display: none">
                    <label for="serie" class="form-label text-muted">Série <span class="text-danger">*</span> :</label>
                    <select name="serie" id="serie" class="form-control select2 bg-white">
                        <option value="" class="text-muted">Selection one option</option>
                    </select>    
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
    </div>
  </div>
</div>
<!-- @Modal désactif discipline -->
<div class="modal fade" id="deleteModalCenter" tabindex="-1" role="dialog" aria-labelledby="deleteModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-dark py-2">
                <h5 class="modal-title" id="deleteModalLongTitle">Delete Data</h5>
            </div>
            <div class="modal-body">
            <div class="row">
                <div class="col-12 text-center">
                    <p id="addVal"></p>
                    <p class="my-0">
                        <strong>Vous êtes sur le point de supprimer ce montant !</strong>
                    </p>
                    <span>Cliquez sur 'Valider'.</span>
                </div>
            </div>
            </div>
            <form method="post" id="myDelete">
                <?php echo csrf_field(); ?>
                <?php echo method_field('put'); ?>
                <input type="hidden" name="type" id="deletType">
                <div class="modal-footer">
                    <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){
            var currentUrl = window.location.href;
            let debutUrl = currentUrl.split("frais");
            
            $('#amount').on('input', function () {
                let value = $(this).val().replace(/\s/g, '');
                value = value.replace(/\D/g, '');
                let formatted = value.replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
                $(this).val(formatted);
            });


            $('input[type="radio"]').on('change', function() {
                $('.level,.serie').remove();
                if($(this).val() == "non"){
                    $('#addLevel').slideDown();
                    $('#level').attr('required', true);
                    $('#monText').text($("#type").val() == 'supérieur' ? 'Filières':'Niveaux');
                    addLevel();
                }
                else{
                    $('#level').attr('required', false);
                    $('#addLevel, #addSerie, #blockText').slideUp();
                    $('#checkbox').prop('checked', false);
                }
            });


            $('#level').on('change', function() {
                $(this).val() > 13 ?
                $('#blockText').slideDown():
                $('#blockText').slideUp();
            });


            $('#checkbox').on('click', function() {
                $('.serie').remove();
                if($(this).is(':checked')){
                    $('#serie').attr('required', true);
                    $('#addSerie').slideDown();
                    addSerie();
                }
                else{
                    $('#serie').attr('required', false);
                    $('#addSerie').slideUp();
                }
            });


            $('#type').val($("#active").data('lib'));
            $('.nav-link').on('click', function() {
                $('#type').val($(this).data('lib'));
            });


            $(document).on('click', '.getDelet', function() {
                $('#data').remove(); $amount = $(this).data('amount');
                $id = $(this).data('id'); $('#deletType').val($("#type").val());
                $('#myDelete').attr('action', debutUrl[0]+'frais/destroy/'+$id); // Add action form Modal
                $('#addVal').append('<h5 class="mb-1 mt-2" id="data">'+formatVal($amount)+' FR CFA</h4>');
            });


            function addLevel()
            {
                $.ajax({
                    url: '<?php echo e(route('frais.create')); ?>',
                    method: 'GET',
                    data: {
                        type: $("#type").val()
                    },
                    success: function(data){
                        $i = 0;
                        while($i < data.length){
                            $('#level').append('<option value="'+data[$i].id+'" data-code="'+data[$i].code+'" class="level">'+strUcFirst(data[$i].level)+'</option>');
                            $i++;
                        }
                    }
                });
            }


            function addSerie()
            {
                $.ajax({
                    url: '<?php echo e(route('frais.edit')); ?>',
                    method: 'GET',
                    data: {
                        type: $("#type").val(),
                        level: $('#level option:selected').data('code')
                    },
                    success: function(data){
                        $i = 0;
                        while($i < data.length){
                            $('#serie').append('<option value="'+data[$i].id+'" class="serie">'+strUcFirst(data[$i].serie)+'</option>');
                            $i++;
                        }
                    }
                });
            }

            function strUcFirst($text)
            {
                return ($text+'').charAt(0).toUpperCase() + ($text+'').substr(1);
            }


            function formatVal($val)
            {
                return $val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
            }
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views/pages/frais/index.blade.php ENDPATH**/ ?>