@extends('app')
@section('title', 'Add School')
@section('content')
<div class="pcoded-inner-content">
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-2">
                                    <h4>{{$school ? 'Edition d\'':'Nouvel '}}établissement</h4>
                                    <span class="form-control-variant">Les champ avec asterisk (<code>*</code>) sont obligatoires.</span>
                                    <span>
                                        <a href="{{route('dashboard')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            @if (session('msg'))
                            <div class="alert alert-{{session('str')}} background-{{session('str')}} w-50" style="margin: auto">
                                <button class="close btn" data-dismiss="alert" aria-label="Close">
                                    <i class="fas fa-times text-white"></i>
                                </button>
                                <strong><i class="fas fa-check-double"></i> {{session('msg')}}</strong>	
                            </div>
                            @endif
                            <div class="card-block my-3">
                                <form action="{{route($school ? 'school.update':'school.store', $school ? $school->id:'')}}" method="post">
                                    @csrf
                                    @method($school ? 'put':'post')
                                    <div class="mb-4">
                                        <strong style="font-size: 19px form-control-variant">Informations Etablissement</strong>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label text-right" for="belonging">Appartenance<span class="text-danger">*</span> :</label>
                                        <div class="col-sm-10">
                                                <input type="radio" name="belonging" id="cdec" value="cdec" {{ old('belonging') == 'cdec' ? 'checked':null }} {{$user ? ($school->belonging == 'cdec' ? 'checked':null):null}}>
                                                <label for="cdec" class="mx-1 form-control-variant">CDEC</label>
                                            </span>
                                            <span class="mx-3">
                                                <input type="radio" name="belonging" id="dren" value="dren" {{ old('belonging') == 'dren' ? 'checked':null }} {{$user ? ($school->belonging == 'dren' ? 'checked':null):'checked'}}>
                                                <label for="dren" class="mx-1 form-control-variant">DREN</label>
                                            </span> <br>
                                            @error('belonging')
                                                <span class="form-bar text-danger" role="alert">
                                                    {{$message}}
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label text-right" for="nameSchool">Nom de Etablissement<span class="text-danger">*</span> :</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="nameSchool" id="nameSchool" class="form-control form-control-normal @error('nameSchool') is-invalid @enderror" value="{{ old('nameSchool', $school ? $school->name_school:'') }}" placeholder="Entrez le nom complet de l'établissement ...">
                                            @error('nameSchool')
                                                <span class="form-bar text-danger" role="alert">
                                                    {{$message}}
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label text-right" for="numAutorastion">Numéro Autorisation<span class="text-danger">*</span> :</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="numAutorastion" id="numAutorastion" class="form-control form-control-normal @error('numAutorastion') is-invalid @enderror" value="{{ old('numAutorastion',$school ? $school->num_autorisation:'') }}" placeholder="Numéro decision autorisation ...">
                                            @error('numAutorastion')
                                                <span class="form-bar text-danger" role="alert">
                                                    {{$message}}
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label text-right" for="codeSchool">Code Etablissement<span class="text-danger">*</span> :</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="codeSchool" id="codeSchool" class="form-control form-control-normal @error('codeSchool') is-invalid @enderror" value="{{ old('codeSchool', $school ? $school->code_school:'') }}" placeholder="Code de l'établissement ...">
                                            @error('codeSchool')
                                                <span class="form-bar text-danger" role="alert">
                                                    {{$message}}
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <hr class="mt-2">

                                    <div class="my-4">
                                        <strong style="font-size: 19px form-control-variant">Informations Admin</strong>
                                    </div>
                                    
                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label text-right" for="firstUser">Nom<span class="text-danger">*</span> :</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="firstUser" id="firstUser" class="form-control form-control-normal @error('firstUser') is-invalid @enderror" value="{{ old('firstUser', $user ? $user->first_name:'') }}" placeholder="Nom ...">
                                            @error('firstUser')
                                                <span class="form-bar text-danger" role="alert">
                                                    {{$message}}
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label text-right" for="lastuser">Prénom<span class="text-danger">*</span> :</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="lastuser" id="lastuser" class="form-control form-control-normal @error('lastuser') is-invalid @enderror" value="{{ old('lastuser', $user ? $user->last_name:'') }}" placeholder="Prénom ...">
                                            @error('lastuser')
                                                <span class="form-bar text-danger" role="alert">
                                                    {{$message}}
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label text-right" for="sexeUser">Sexe<span class="text-danger">*</span> :</label>
                                        <div class="col-sm-10">
                                            <span class="mr-3">
                                                <input type="radio" name="sexeUser" id="femme" value="F" {{ old('sexeUser') == 'F' ? 'checked':null }} {{$user ? ($user->sexe == 'F' ? 'checked':null):null}}>
                                                <label for="femme" class="mx-1 form-control-variant">Femme</label>
                                            </span>
                                            <span class="mx-3">
                                                <input type="radio" name="sexeUser" id="homme" value="H" {{ old('sexeUser') == 'H' ? 'checked':null }} {{$user ? ($user->sexe == 'H' ? 'checked':null):'checked'}}>
                                                <label for="homme" class="mx-1 form-control-variant">Homme</label>
                                            </span> <br>
                                            @error('sexeUser')
                                                <span class="form-bar text-danger" role="alert">
                                                    {{$message}}
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label text-right" for="emailUser">Adresse mail<span class="text-danger">*</span> :</label>
                                        <div class="col-sm-10">
                                            <input type="email" name="emailUser" id="emailUser" class="form-control form-control-normal @error('emailUser') is-invalid @enderror" value="{{ old('emailUser', $user ? $user->email:'') }}" placeholder="Adresse mail ...">
                                            @error('emailUser')
                                                <span class="form-bar text-danger" role="alert">
                                                    {{$message}}
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label text-right" for="numPhon">Téléphone<span class="text-danger">*</span> :</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="numPhon" id="numPhon" class="form-control form-control-normal @error('numPhon') is-invalid @enderror" value="{{ old('numPhon', $user ? $user->telephon:'') }}" maxlength="10" placeholder="Numéro de téléphone ...">
                                            @error('numPhon')
                                                <span class="form-bar text-danger" role="alert">
                                                    {{$message}}
                                                </span><br class="my-0 py-0">
                                            @enderror
                                        </div>
                                    </div>
                                    @if ($school)
                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label" ></label>
                                        <div class="col-sm-10">
                                            <input type="checkbox" name="status" id="status" {{$school->status ? 'checked':''}}>
                                            <label for="status" class="mx-1 form-control-variant">{{$school->status ? 'Actif':'Inactif'}}</label>
                                        </div>
                                    </div>
                                    @endif
                                    <div class="text-center">
                                        <button type="submit" class="btn btn-inverse btn-outline-inverse py-2"> <i class="fas fa-check-circle"></i> Valider les informations</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script src="{{asset('assets/js/pcoded.min.js')}}"></script>
<script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
<script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
<script>
    $(document).ready(function(){
        $('#numPhon').on('keypress', function(e) {
            var charCode = e.which ? e.which : e.keyCode;
            if (charCode < 48 || charCode > 57) {
                e.preventDefault(); // Empêche la saisie si ce n'est pas un chiffre
            }
        });
    })
</script>
@endsection