<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->enum('status',['0', '1'])->default('0');
            $table->enum('type',['primaire', 'secondaire', 'technique', 'superieur']);
            $table->unsignedBigInteger('school_id');
            $table->unsignedBigInteger('annex_fee_id');
            $table->unsignedBigInteger('scolaritie_id');
            $table->unsignedBigInteger('inscription_id');
            $table->unsignedBigInteger('school_year_id');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('annex_fee_id')->references('id')->on('annex_fees')->onDelete('cascade');
            $table->foreign('scolaritie_id')->references('id')->on('scolarities')->onDelete('cascade');
            $table->foreign('inscription_id')->references('id')->on('inscriptions')->onDelete('cascade');
            $table->foreign('school_year_id')->references('id')->on('school_years')->onDelete('cascade');
            $table->timestamps();
        });
        Schema::enableForeignKeyConstraints();
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
