<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SchoolRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'nameSchool' => 'required|string|max:100',
            'numAutorastion' => 'required|string|unique:schools,num_autorisation',
            'codeSchool' => 'required|string|unique:schools,code_school',
            'firstUser' => 'required|string|min:3',
            'lastuser' => 'required|string',
            'sexeUser' => 'required|string',
            'emailUser' => 'required|email|unique:users,email',
            'numPhon' => 'required|numeric|min:10|unique:users,telephon',
        ];
    }


    /**
     * Messages de validation personnalisés.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'nameSchool.required' => 'Le nom de l\'établissement est obligatoire.',
            'numAutorastion.required' => 'Le numéro d\'autorisation de l\'établissement est obligatoire.',
            'codeSchool.required' => 'Le code de l\'établissement est obligatoire.',
            'firstUser.required' => 'Le nom d\'utilisateur est obligatoire.',
            'lastuser.required' => 'Le prénoms d\'utilisateur est obligatoire.',
            'emailUser.required' => 'L\'adresse E-mail d\'utilisateur est obligatoire.',
            'numPhon.required' => 'Le numéro de téléphone d\'utilisateur est obligatoire.',
            'email.required' => 'L\'email est obligatoire.',
            'emailUser.email' => 'L\'adresse E-mail d\'utilisateur est invalide.',
            'password.required' => 'Le mot de passe est obligatoire.',
        ];
    }
}
