@extends('app')
@section('title', 'Get Teacher')
@section('link')
    <!-- Data Table Css -->
    <link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
    <link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/extensions/autofill/css/autoFill.dataTables.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/pages/data-table/extensions/autofill/css/select.dataTables.min.css')}}">
    <style>
        .dataTables_length{
            display: none;
        }
    </style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-0 mb-0">
                                    <h4>Enseignants</h4>
                                    <span>
                                        <a href="{{route('user.create')}}" class="btn btn-inverse btn-outline-inverse  btn-sm mx-1 py-1" title="Add Teacher"> <i class="fas fa-plus mx-0"></i></a>
                                        <a href="{{route('user.index1')}}" class="btn btn-inverse btn-outline-inverse  btn-sm mx-1 py-1" title="User List"> <i class="fab fa-cloudsmith m-0"></i></a>
                                        <a href="{{route('user.inactif')}}" class="btn btn-inverse btn-outline-inverse  btn-sm mx-1 py-1" title="Disabled"> <i class="fas fa-underline m-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <div class="tab-content card-block">
                                        <table class="table table-striped table-bordered nowrap" id="myTable">
                                            <thead>
                                                <tr>
                                                    <th style="width: 5%"></th>
                                                    <th>Nom</th>
                                                    <th class="py-2">Prénoms</th>
                                                    <th>Sexe</th>
                                                    <th>E-mail</th>
                                                    <th>Téléphone</th>
                                                    <th>Profil</th>
                                                    <th class="text-center">Actions</th>
                                                </tr>
                                            </thead>
                                            <!-- Content Table -->
                                        </table>
                                    </div> 
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/jszip.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/pdfmake.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/vfs_fonts.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.select.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/extensions-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){
            $('#myTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{ route('user.data1') }}',
                columns: [
                    { data: 'image', className: "text-center fw-bold py-1", orderable: false, searchable: false},
                    { data: 'firstName', className: "py-1" },
                    { data: 'lastName', className: "py-1" },
                    { data: 'sexe', className: "py-1" },
                    { data: 'email', className: "py-1" },
                    { data: 'telephon', className: "py-1"},
                    { data: 'profil', className: "py-1"},
                    { data: 'action', className: "text-center py-1", orderable: false, searchable: false}
                ],
                pageLength: 10,
                language: {
                    url: "//cdn.datatables.net/plug-ins/1.13.6/i18n/fr-FR.json"
                }
            });
        })
    </script>
@endsection