@extends('app')
@section('title', 'School detail')
@section('link')
    <style>
        #fa-expand {
            font-size: 100px;
            animation: heartbeat 1s infinite;
            color: rgb(136, 134, 134) !important
        }

        @keyframes heartbeat {
            0% {
                transform: scale(1);
            }
            25% {
                transform: scale(1.2);
            }
            50% {
                transform: scale(1);
            }
            75% {
                transform: scale(1.1);
            }
        }
    </style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="container">
                    <div class="card">
                        @if ($school)
                        <div class="card-block">
                            <div class="row invoice-contac px-2 py-4">
                                <div class="col-sm-2 text-center py-5">
                                    <h5 class="my-3">Logo</h5>
                                    @if ($school->image)
                                    <img src="{{ asset($school->logoUrl()) }}"  class="m-b-10 w-100" alt="Logo School">
                                    @else
                                    <span >Pas de logo</span>
                                    @endif
                                    <strong>{{ ucfirst($school->getDren->libelle) }}</strong>
                                </div>
                                <div class="col-sm-10">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th class="text-center">
                                                        <h4>{{ ucfirst($school->school->name_school) }}</h4>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <table class="table table-striped table-bordered mt-0">
                                                        <tbody>
                                                            {{-- <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">DREN</span></td>
                                                                <td><strong>{{ucfirst($school->getDren->libelle)}}</strong></td>
                                                            </tr> --}}
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Code établissement</span></td>
                                                                <td><strong>{{ ucfirst($school->school->code_school) }}</strong></td>
                                                            </tr>
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Numéro autorisation</span></td>
                                                                <td><strong>{{ ucfirst($school->school->num_autorisation) }}</strong></td>
                                                            </tr>
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Adresse E-mail</span></td>
                                                                <td><strong>{{ $school->address_email }}</strong></td>
                                                            </tr>
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Boîte postale</span></td>
                                                                <td><strong>{{ $school->addres_postal }}</strong></td>
                                                            </tr>
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Téléphone</span></td>
                                                                <td><strong>{{ $school->phon_school }}</strong></td>
                                                            </tr>
                                                            @if ($school->address_iep)
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">EIP</span></td>
                                                                <td><strong>{{ $school->address_iep }}</strong></td>
                                                            </tr>
                                                            @endif
                                                            @if ($school->addictive_matter)
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Matière addictionnel</span></td>
                                                                <td><strong>Oui</strong></td>
                                                            </tr>
                                                            @endif
                                                            @if ($school->addictive_matter)
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Classe avec des lettree</span></td>
                                                                <td><strong>Oui</strong></td>
                                                            </tr>
                                                            @endif
                                                            @if ($school->transport)
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Bus pour les élèves</span></td>
                                                                <td><strong>Oui</strong></td>
                                                            </tr>
                                                            @endif
                                                            @if ($school->canteen)
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Cantine scolaire</span></td>
                                                                <td><strong>Oui</strong></td>
                                                            </tr>
                                                            @endif
                                                            <tr>
                                                                <td style="width: 350px"><span style="font-size: 14px">Type d'enseignment</span></td>
                                                                <td><strong>{{ getAffiche($school->school->typeEnseignements) }}</strong></td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <!-- Invoice card end -->
                            <div class="row text-center">
                                <div class="col-sm-12 invoice-btn-group text-center">
                                    <a href="{{ route('setting.edit',$school->id) }}" class="btn btn-inverse btn-outline-inverse py-1"> <i class="fas fa-edit"></i> Modifications</a>
                                </div>
                            </div>
                        </div>
                        @else
                         <div class="text-center py-5">
                            <p class="text-center">
                                <i class="fas fa-expand" id="fa-expand"></i>
                            </p>
                            <h5 class="my-3">Passez au parametrage</h5>
                            <a href="{{ route('setting.create') }}" class="btn btn-inverse btn-outline-inverse py-1">Paramètrage</a>
                         </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script src="{{asset('assets/js/pcoded.min.js')}}"></script>
<script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
<script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
@endsection